/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.filters.unsupervised.attribute.Add;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.SubstringLabelerRules;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="SubstringLabeler", category="Tools", toolTipText="Label instances according to substring matches in String attributes The user can specify the attributes to match against and associated label to create by defining 'match' rules. A new attribute is appended to the data to contain the label. Rules are applied in order when processing instances, and the label associated with the first matching rule is applied. Non-matching instances can either receive a missing value for the label attribute or be 'consumed' (i.e. they are not output).", iconPath="weka/gui/knowledgeflow/icons/DefaultFilter.gif")
public class SubstringLabeler
extends BaseStep {
    private static final long serialVersionUID = 1409175779108600014L;
    protected String m_matchDetails = "";
    protected transient SubstringLabelerRules m_matches;
    protected boolean m_nominalBinary;
    protected boolean m_consumeNonMatchingInstances;
    protected Add m_addFilter;
    protected String m_attName = "Match";
    protected boolean m_isReset;
    protected Data m_streamingData;
    protected boolean m_streaming;

    @ProgrammaticProperty
    public void setMatchDetails(String details) {
        this.m_matchDetails = details;
    }

    public String getMatchDetails() {
        return this.m_matchDetails;
    }

    @OptionMetadata(displayName="Make a nominal binary attribute", description="Whether to encode the new attribute as nominal when it is binary (as opposed to numeric)", displayOrder=1)
    public void setNominalBinary(boolean nom) {
        this.m_nominalBinary = nom;
    }

    public boolean getNominalBinary() {
        return this.m_nominalBinary;
    }

    @OptionMetadata(displayName="Consume non matching instances", description="Instances that do not match any rules will be consumed, rather than being output with a missing value for the new attribute", displayOrder=2)
    public void setConsumeNonMatching(boolean consume) {
        this.m_consumeNonMatchingInstances = consume;
    }

    public boolean getConsumeNonMatching() {
        return this.m_consumeNonMatchingInstances;
    }

    @OptionMetadata(displayName="Name of the new attribute", description="Name to give the new attribute", displayOrder=0)
    public void setMatchAttributeName(String name) {
        this.m_attName = name;
    }

    public String getMatchAttributeName() {
        return this.m_attName;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_isReset = true;
        this.m_streamingData = new Data("instance");
        this.m_streaming = false;
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return this.getStepManager().numIncomingConnections() == 0 ? Arrays.asList("instance", "dataSet", "trainingSet", "testSet") : null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<StepManager>> e2 : this.getStepManager().getIncomingConnections().entrySet()) {
            if (e2.getValue().size() <= 0) continue;
            result.add(e2.getKey());
        }
        return result;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_isReset) {
            Instances structure;
            if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
                Instance inst = (Instance)data.getPrimaryPayload();
                structure = inst.dataset();
                this.m_streaming = true;
            } else {
                structure = (Instances)data.getPrimaryPayload();
                structure = new Instances(structure, 0);
            }
            try {
                this.m_matches = new SubstringLabelerRules(this.m_matchDetails, this.m_attName, this.getConsumeNonMatching(), this.getNominalBinary(), structure, ((StepManagerImpl)this.getStepManager()).stepStatusMessagePrefix(), this.getStepManager().getLog(), this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
            this.m_isReset = false;
        }
        if (this.m_streaming) {
            if (this.getStepManager().isStreamFinished(data)) {
                this.m_streamingData.clearPayload();
                this.getStepManager().throughputFinished(this.m_streamingData);
                return;
            }
            this.processStreaming(data);
        } else {
            this.processBatch(data);
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
        } else if (!this.m_streaming) {
            this.getStepManager().finished();
        }
    }

    protected void processStreaming(Data data) throws WekaException {
        this.getStepManager().throughputUpdateStart();
        Instance toProcess = (Instance)data.getPrimaryPayload();
        try {
            Instance result = this.m_matches.makeOutputInstance(toProcess, false);
            if (result != null) {
                this.m_streamingData.setPayloadElement("instance", result);
                this.getStepManager().outputData(this.m_streamingData);
                this.getStepManager().throughputUpdateEnd();
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected void processBatch(Data data) throws WekaException {
        if (this.isStopRequested()) {
            return;
        }
        Instances batch = (Instances)data.getPrimaryPayload();
        for (int i = 0; i < batch.numInstances(); ++i) {
            Instance current = batch.instance(i);
            Instance result = null;
            try {
                result = this.m_matches.makeOutputInstance(current, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.isStopRequested()) {
                return;
            }
            if (result == null) continue;
            this.m_matches.getOutputStructure().add(result);
        }
        Data outputD = new Data(data.getConnectionName(), this.m_matches.getOutputStructure());
        outputD.setPayloadElement("aux_set_num", data.getPayloadElement("aux_set_num"));
        outputD.setPayloadElement("aux_max_set_num", data.getPayloadElement("aux_max_set_num"));
        this.getStepManager().outputData(outputD);
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().numIncomingConnections() > 0) {
            for (Map.Entry<String, List<StepManager>> e2 : this.getStepManager().getIncomingConnections().entrySet()) {
                if (e2.getValue().size() <= 0) continue;
                StepManager incoming = e2.getValue().get(0);
                String incomingConnType = e2.getKey();
                Instances incomingStruc = this.getStepManager().getIncomingStructureFromStep(incoming, incomingConnType);
                if (incomingStruc == null) {
                    return null;
                }
                try {
                    SubstringLabelerRules rules = new SubstringLabelerRules(this.m_matchDetails, this.m_attName, this.getConsumeNonMatching(), this.getNominalBinary(), incomingStruc, ((StepManagerImpl)this.getStepManager()).stepStatusMessagePrefix(), null, Environment.getSystemWide());
                    return rules.getOutputStructure();
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
        }
        return null;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.SubstringLabelerStepEditorDialog";
    }
}

