/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Instance;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="StripChart", category="Visualization", toolTipText="Plot streaming data", iconPath="weka/gui/knowledgeflow/icons/StripChart.gif")
public class StripChart
extends BaseStep {
    private static final long serialVersionUID = -2569383350174947630L;
    protected List<PlotNotificationListener> m_plotListeners = new ArrayList<PlotNotificationListener>();
    protected int m_xValFreq = 500;
    private int m_refreshFrequency = 5;
    private int m_userRefreshWidth = 1;
    protected boolean m_reset;
    protected int m_instanceWidth;

    public String xLabelFreqTipText() {
        return "Show x axis labels this often";
    }

    public int getXLabelFreq() {
        return this.m_xValFreq;
    }

    public void setXLabelFreq(int freq) {
        this.m_xValFreq = freq;
    }

    public String refreshFreqTipText() {
        return "Plot every x'th data point";
    }

    public void setRefreshFreq(int freq) {
        this.m_refreshFrequency = freq;
    }

    public int getRefreshFreq() {
        return this.m_refreshFrequency;
    }

    public String refreshWidthTipText() {
        return "The number of pixels to shift the plot by every time a point is plotted.";
    }

    public void setRefreshWidth(int width) {
        if (width > 0) {
            this.m_userRefreshWidth = width;
        }
    }

    public int getRefreshWidth() {
        return this.m_userRefreshWidth;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_reset = true;
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        if (this.isStopRequested()) {
            return;
        }
        if (this.getStepManager().isStreamFinished(data)) {
            Data d = new Data(data.getConnectionName());
            this.getStepManager().throughputFinished(d);
            return;
        }
        this.getStepManager().throughputUpdateStart();
        if (this.m_plotListeners.size() > 0) {
            if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
                int i;
                Instance instance = (Instance)data.getPayloadElement("instance");
                if (this.m_reset) {
                    this.m_reset = false;
                    ArrayList<String> legendEntries = new ArrayList<String>();
                    for (i = 0; i < instance.dataset().numAttributes() && i < 10; ++i) {
                        legendEntries.add(instance.dataset().attribute(i).name());
                    }
                    this.m_instanceWidth = i;
                    for (PlotNotificationListener l : this.m_plotListeners) {
                        l.setLegend(legendEntries, 0.0, 1.0);
                    }
                }
                double[] dataPoint = new double[this.m_instanceWidth];
                for (i = 0; i < dataPoint.length; ++i) {
                    if (instance.isMissing(i)) continue;
                    dataPoint[i] = instance.value(i);
                }
                for (PlotNotificationListener l : this.m_plotListeners) {
                    l.acceptDataPoint(dataPoint);
                }
            } else if (this.getStepManager().numIncomingConnectionsOfType("chart") > 0) {
                if (this.m_reset) {
                    this.m_reset = false;
                    double min2 = data.getPayloadElement("chart_min", 0.0);
                    double max2 = data.getPayloadElement("chart_max", 1.0);
                    List legend = (List)data.getPayloadElement("chart_legend");
                    for (PlotNotificationListener l : this.m_plotListeners) {
                        l.setLegend(legend, min2, max2);
                    }
                }
                double[] dataPoint = (double[])data.getPayloadElement("chart_data_point");
                for (PlotNotificationListener l : this.m_plotListeners) {
                    l.acceptDataPoint(dataPoint);
                }
            }
        }
        this.getStepManager().throughputUpdateEnd();
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("instance", "chart");
        }
        return new ArrayList<String>();
    }

    public synchronized void addPlotNotificationListener(PlotNotificationListener listener) {
        this.m_plotListeners.add(listener);
    }

    public synchronized void removePlotNotificationListener(PlotNotificationListener l) {
        this.m_plotListeners.remove(l);
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return new ArrayList<String>();
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        views.put("Show chart", "weka.gui.knowledgeflow.steps.StripChartInteractiveView");
        return views;
    }

    public static interface PlotNotificationListener {
        public void setLegend(List<String> var1, double var2, double var4);

        public void acceptDataPoint(double[] var1);
    }
}

