/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import weka.core.Attribute;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="FlowByExpression", category="Flow", toolTipText="Route instances according to the evaluation of a logical expression. The expression can test the values of one or more incoming attributes. The test can involve constants or comparing one attribute's values to another. Inequalities along with string operations such as contains, starts-with, ends-with and regular expressions may be used as operators. \"True\" instances can be sent to one downstream step and \"False\" instances sent to another.", iconPath="weka/gui/knowledgeflow/icons/FlowByExpression.png")
public class FlowByExpression
extends BaseStep {
    private static final long serialVersionUID = 7006511778677802572L;
    protected boolean m_isReset;
    protected ExpressionNode m_root;
    protected String m_expressionString = "";
    protected String m_customNameOfTrueStep = "";
    protected String m_customNameOfFalseStep = "";
    protected Instances m_incomingStructure;
    protected AtomicInteger m_batchCount;
    protected boolean m_validTrueStep;
    protected boolean m_validFalseStep;
    protected Data m_streamingData;

    public void setExpressionString(String expressionString) {
        this.m_expressionString = expressionString;
    }

    public String getExpressionString() {
        return this.m_expressionString;
    }

    public void setTrueStepName(String trueStep) {
        this.m_customNameOfTrueStep = trueStep;
    }

    public String getTrueStepName() {
        return this.m_customNameOfTrueStep;
    }

    public void setFalseStepName(String falseStep) {
        this.m_customNameOfFalseStep = falseStep;
    }

    public String getFalseStepName() {
        return this.m_customNameOfFalseStep;
    }

    public List<String> getDownstreamStepNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (List<StepManager> o : this.getStepManager().getOutgoingConnections().values()) {
            for (StepManager m : o) {
                result.add(m.getName());
            }
        }
        return result;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_isReset = true;
        this.m_streamingData = null;
        this.m_validTrueStep = this.getStepManager().getOutgoingConnectedStepWithName(this.environmentSubstitute(this.m_customNameOfTrueStep)) != null;
        this.m_validFalseStep = this.getStepManager().getOutgoingConnectedStepWithName(this.environmentSubstitute(this.m_customNameOfFalseStep)) != null;
        this.m_incomingStructure = null;
        if (this.m_expressionString == null || this.m_expressionString.length() == 0) {
            throw new WekaException("No expression defined!");
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet", "instance");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("instance") == 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet");
        }
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
            result.add("instance");
        } else if (this.getStepManager().numIncomingConnections() > 0) {
            if (this.getStepManager().numIncomingConnectionsOfType("dataSet") > 0) {
                result.add("dataSet");
            }
            if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0) {
                result.add("trainingSet");
            }
            if (this.getStepManager().numIncomingConnectionsOfType("testSet") > 0) {
                result.add("testSet");
            }
        }
        return result;
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        Iterator<Map.Entry<String, List<StepManager>>> iterator;
        if (this.getStepManager().numIncomingConnections() > 0 && (iterator = this.getStepManager().getIncomingConnections().entrySet().iterator()).hasNext()) {
            Map.Entry<String, List<StepManager>> e2 = iterator.next();
            String incomingConnType = e2.getKey();
            Instances incomingStruc = this.getStepManager().getIncomingStructureFromStep(e2.getValue().get(0), incomingConnType);
            return incomingStruc;
        }
        return null;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_isReset) {
            this.m_isReset = false;
            if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
                this.m_streamingData = new Data("instance");
                Instance inst = (Instance)data.getPrimaryPayload();
                this.m_incomingStructure = new Instances(inst.dataset(), 0);
            } else {
                this.m_incomingStructure = (Instances)data.getPrimaryPayload();
                this.m_incomingStructure = new Instances(this.m_incomingStructure, 0);
                this.m_batchCount = new AtomicInteger(this.getStepManager().numIncomingConnections());
                this.getStepManager().processing();
            }
            this.m_root = new BracketNode();
            this.m_root.parseFromInternal(this.m_expressionString);
            this.m_root.init(this.m_incomingStructure, this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
        }
        if (this.m_streamingData == null) {
            Instances batch = (Instances)data.getPrimaryPayload();
            if (!this.m_incomingStructure.equalHeaders(batch)) {
                throw new WekaException("Incoming batches with different structure: " + this.m_incomingStructure.equalHeadersMsg(batch));
            }
            this.processBatch(data);
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
            } else if (this.m_batchCount.get() == 0) {
                this.getStepManager().finished();
            }
        } else {
            this.processStreaming(data);
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
            }
        }
    }

    protected void processStreaming(Data data) throws WekaException {
        if (this.getStepManager().isStreamFinished(data)) {
            this.m_streamingData.clearPayload();
            this.getStepManager().throughputFinished(this.m_streamingData);
            return;
        }
        this.getStepManager().throughputUpdateStart();
        Instance toProcess = (Instance)data.getPrimaryPayload();
        boolean result = this.m_root.evaluate(toProcess, true);
        this.m_streamingData.setPayloadElement("instance", toProcess);
        if (result) {
            if (this.m_validTrueStep) {
                this.getStepManager().outputData("instance", this.m_customNameOfTrueStep, this.m_streamingData);
            }
        } else if (this.m_validFalseStep) {
            this.getStepManager().outputData("instance", this.m_customNameOfFalseStep, this.m_streamingData);
        }
        this.getStepManager().throughputUpdateEnd();
    }

    protected void processBatch(Data data) throws WekaException {
        Instances incoming = (Instances)data.getPrimaryPayload();
        Instances trueBatch = new Instances(incoming, 0);
        Instances falseBatch = new Instances(incoming, 0);
        for (int i = 0; i < incoming.numInstances(); ++i) {
            if (this.isStopRequested()) {
                return;
            }
            Instance current = incoming.instance(i);
            boolean result = this.m_root.evaluate(current, true);
            if (result) {
                if (!this.m_validTrueStep) continue;
                trueBatch.add(current);
                continue;
            }
            if (!this.m_validFalseStep) continue;
            falseBatch.add(current);
        }
        Integer setNum = data.getPayloadElement("aux_set_num", 1);
        Integer maxSetNum = data.getPayloadElement("aux_max_set_num", 1);
        if (this.m_validTrueStep) {
            this.getStepManager().logDetailed("Routing " + trueBatch.numInstances() + " instances to step " + this.m_customNameOfTrueStep);
            Data outputData = new Data(data.getConnectionName(), trueBatch);
            outputData.setPayloadElement("aux_set_num", setNum);
            outputData.setPayloadElement("aux_max_set_num", maxSetNum);
            this.getStepManager().outputData(data.getConnectionName(), this.m_customNameOfTrueStep, outputData);
        }
        if (this.m_validFalseStep) {
            this.getStepManager().logDetailed("Routing " + falseBatch.numInstances() + " instances to step " + this.m_customNameOfFalseStep);
            Data outputData = new Data(data.getConnectionName(), falseBatch);
            outputData.setPayloadElement("aux_set_num", setNum);
            outputData.setPayloadElement("aux_max_set_num", maxSetNum);
            this.getStepManager().outputData(data.getConnectionName(), this.m_customNameOfFalseStep, outputData);
        }
        if (setNum == maxSetNum) {
            this.m_batchCount.decrementAndGet();
        }
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.FlowByExpressionStepEditorDialog";
    }

    public static class ExpressionClause
    extends ExpressionNode
    implements Serializable {
        private static final long serialVersionUID = 2754006654981248325L;
        protected ExpressionType m_operator;
        protected String m_lhsAttributeName;
        protected int m_lhsAttIndex = -1;
        protected String m_rhsOperand;
        protected boolean m_rhsIsAttribute;
        protected int m_rhsAttIndex = -1;
        protected String m_resolvedLhsName;
        protected String m_resolvedRhsOperand;
        protected Pattern m_regexPattern;
        protected double m_numericOperand;

        public ExpressionClause() {
        }

        public ExpressionClause(ExpressionType operator2, String lhsAttributeName, String rhsOperand, boolean rhsIsAttribute, boolean isAnOr) {
            this.m_operator = operator2;
            this.m_lhsAttributeName = lhsAttributeName;
            this.m_rhsOperand = rhsOperand;
            this.m_rhsIsAttribute = rhsIsAttribute;
            this.m_isAnOr = isAnOr;
        }

        public String getLHSAttName() {
            return this.m_lhsAttributeName;
        }

        public void setLHSAttName(String attName) {
            this.m_lhsAttributeName = attName;
        }

        public String getRHSOperand() {
            return this.m_rhsOperand;
        }

        public void setRHSOperand(String opp) {
            this.m_rhsOperand = opp;
        }

        public boolean isRHSAnAttribute() {
            return this.m_rhsIsAttribute;
        }

        public void setRHSIsAnAttribute(boolean rhs) {
            this.m_rhsIsAttribute = rhs;
        }

        public ExpressionType getOperator() {
            return this.m_operator;
        }

        public void setOperator(ExpressionType opp) {
            this.m_operator = opp;
        }

        @Override
        public void init(Instances structure, Environment env) {
            super.init(structure, env);
            this.m_resolvedLhsName = this.m_lhsAttributeName;
            this.m_resolvedRhsOperand = this.m_rhsOperand;
            try {
                this.m_resolvedLhsName = this.m_env.substitute(this.m_resolvedLhsName);
                this.m_resolvedRhsOperand = this.m_env.substitute(this.m_resolvedRhsOperand);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Attribute lhs = null;
            if (this.m_resolvedLhsName.toLowerCase().startsWith("/first")) {
                lhs = structure.attribute(0);
            } else if (this.m_resolvedLhsName.toLowerCase().startsWith("/last")) {
                lhs = structure.attribute(structure.numAttributes() - 1);
            } else {
                try {
                    int indx = Integer.parseInt(this.m_resolvedLhsName);
                    lhs = structure.attribute(--indx);
                }
                catch (NumberFormatException indx) {
                    // empty catch block
                }
            }
            if (lhs == null) {
                lhs = structure.attribute(this.m_resolvedLhsName);
            }
            if (lhs == null) {
                throw new IllegalArgumentException("Data does not contain attribute \"" + this.m_resolvedLhsName + "\"");
            }
            this.m_lhsAttIndex = lhs.index();
            if (this.m_rhsIsAttribute) {
                Attribute rhs = null;
                if (this.m_resolvedRhsOperand.toLowerCase().equals("/first")) {
                    rhs = structure.attribute(0);
                } else if (this.m_resolvedRhsOperand.toLowerCase().equals("/last")) {
                    rhs = structure.attribute(structure.numAttributes() - 1);
                } else {
                    try {
                        int indx = Integer.parseInt(this.m_resolvedRhsOperand);
                        rhs = structure.attribute(--indx);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (rhs == null) {
                    rhs = structure.attribute(this.m_resolvedRhsOperand);
                }
                if (rhs == null) {
                    throw new IllegalArgumentException("Data does not contain attribute \"" + this.m_resolvedRhsOperand + "\"");
                }
                this.m_rhsAttIndex = rhs.index();
            } else if (this.m_operator != ExpressionType.CONTAINS && this.m_operator != ExpressionType.STARTSWITH && this.m_operator != ExpressionType.ENDSWITH && this.m_operator != ExpressionType.REGEX && this.m_operator != ExpressionType.ISMISSING) {
                if (lhs.isNominal()) {
                    this.m_numericOperand = lhs.indexOfValue(this.m_resolvedRhsOperand);
                    if (this.m_numericOperand < 0.0) {
                        throw new IllegalArgumentException("Unknown nominal value '" + this.m_resolvedRhsOperand + "' for attribute '" + lhs.name() + "'");
                    }
                } else {
                    try {
                        this.m_numericOperand = Double.parseDouble(this.m_resolvedRhsOperand);
                    }
                    catch (NumberFormatException e2) {
                        throw new IllegalArgumentException("\"" + this.m_resolvedRhsOperand + "\" is not parseable as a number!");
                    }
                }
            }
            if (this.m_operator == ExpressionType.REGEX) {
                this.m_regexPattern = Pattern.compile(this.m_resolvedRhsOperand);
            }
        }

        @Override
        public boolean evaluate(Instance inst, boolean result) {
            boolean thisNode = this.m_operator.evaluate(inst, this.m_lhsAttIndex, this.m_rhsOperand, this.m_numericOperand, this.m_regexPattern, this.m_rhsIsAttribute, this.m_rhsAttIndex);
            if (this.isNegated()) {
                boolean bl = thisNode = !thisNode;
            }
            return this.isOr() ? result || thisNode : result && thisNode;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            this.toStringDisplay(buff);
            return buff.toString();
        }

        @Override
        public void toStringDisplay(StringBuffer buff) {
            this.toString(buff, false);
        }

        @Override
        public void toStringInternal(StringBuffer buff) {
            this.toString(buff, true);
        }

        @Override
        public DefaultMutableTreeNode toJTree(DefaultMutableTreeNode parent) {
            parent.add(new DefaultMutableTreeNode(this));
            return parent;
        }

        private void toString(StringBuffer buff, boolean internal) {
            if (internal || this.m_showAndOr) {
                if (this.m_isAnOr) {
                    buff.append("|| ");
                } else {
                    buff.append("&& ");
                }
            }
            if (this.isNegated()) {
                buff.append("!");
            }
            buff.append("[");
            buff.append(this.m_lhsAttributeName);
            if (internal) {
                buff.append("@EC@" + this.m_operator.toString());
            } else {
                buff.append(" " + this.m_operator.toString());
            }
            if (this.m_operator != ExpressionType.ISMISSING) {
                if (internal) {
                    buff.append("@EC@" + (this.m_rhsIsAttribute ? "@@" : "") + this.m_rhsOperand);
                } else {
                    buff.append(" " + (this.m_rhsIsAttribute ? "ATT: " : "") + this.m_rhsOperand);
                }
            } else if (internal) {
                buff.append("@EC@");
            } else {
                buff.append(" ");
            }
            buff.append("]");
        }

        @Override
        protected String parseFromInternal(String expression) {
            if (expression.startsWith("|| ")) {
                this.m_isAnOr = true;
            }
            if (expression.startsWith("|| ") || expression.startsWith("&& ")) {
                expression = expression.substring(3, expression.length());
            }
            if (expression.charAt(0) == '!') {
                this.setNegated(true);
                expression = expression.substring(1, expression.length());
            }
            if (expression.charAt(0) != '[') {
                throw new IllegalArgumentException("Was expecting a \"[\" to start this ExpressionClause!");
            }
            expression = expression.substring(1, expression.length());
            this.m_lhsAttributeName = expression.substring(0, expression.indexOf("@EC@"));
            expression = expression.substring(expression.indexOf("@EC@") + 4, expression.length());
            String oppName = expression.substring(0, expression.indexOf("@EC@"));
            expression = expression.substring(expression.indexOf("@EC@") + 4, expression.length());
            for (ExpressionType n : ExpressionType.values()) {
                if (!n.toString().equals(oppName)) continue;
                this.m_operator = n;
                break;
            }
            if (expression.startsWith("@@")) {
                expression = expression.substring(2, expression.length());
                this.m_rhsIsAttribute = true;
            }
            this.m_rhsOperand = expression.substring(0, expression.indexOf(93));
            if ((expression = expression.substring(expression.indexOf(93) + 1, expression.length())).charAt(0) == ' ') {
                expression = expression.substring(1, expression.length());
            }
            return expression;
        }

        public static enum ExpressionType {
            EQUALS(" = "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (rhsIsAttribute) {
                        if (inst.isMissing(lhsAttIndex) && inst.isMissing(rhsAttIndex)) {
                            return true;
                        }
                        if (inst.isMissing(lhsAttIndex) || inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        return inst.value(lhsAttIndex) == inst.value(rhsAttIndex);
                    }
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    return inst.value(lhsAttIndex) == numericOperand;
                }
            }
            ,
            NOTEQUAL(" != "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return !EQUALS.evaluate(inst, lhsAttIndex, rhsOperand, numericOperand, regexPattern, rhsIsAttribute, rhsAttIndex);
                }
            }
            ,
            LESSTHAN(" < "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (rhsIsAttribute) {
                        if (inst.isMissing(lhsAttIndex) || inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        return inst.value(lhsAttIndex) < inst.value(rhsAttIndex);
                    }
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    return inst.value(lhsAttIndex) < numericOperand;
                }
            }
            ,
            LESSTHANEQUAL(" <= "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (rhsIsAttribute) {
                        if (inst.isMissing(lhsAttIndex) || inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        return inst.value(lhsAttIndex) <= inst.value(rhsAttIndex);
                    }
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    return inst.value(lhsAttIndex) <= numericOperand;
                }
            }
            ,
            GREATERTHAN(" > "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return !LESSTHANEQUAL.evaluate(inst, lhsAttIndex, rhsOperand, numericOperand, regexPattern, rhsIsAttribute, rhsAttIndex);
                }
            }
            ,
            GREATERTHANEQUAL(" >= "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return !LESSTHAN.evaluate(inst, lhsAttIndex, rhsOperand, numericOperand, regexPattern, rhsIsAttribute, rhsAttIndex);
                }
            }
            ,
            ISMISSING(" isMissing "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    return inst.isMissing(lhsAttIndex);
                }
            }
            ,
            CONTAINS(" contains "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    if (rhsIsAttribute) {
                        if (inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        try {
                            String rhsString = inst.stringValue(rhsAttIndex);
                            return lhsString.contains(rhsString);
                        }
                        catch (IllegalArgumentException ex) {
                            return false;
                        }
                    }
                    return lhsString.contains(rhsOperand);
                }
            }
            ,
            STARTSWITH(" startsWith "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    if (rhsIsAttribute) {
                        if (inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        try {
                            String rhsString = inst.stringValue(rhsAttIndex);
                            return lhsString.startsWith(rhsString);
                        }
                        catch (IllegalArgumentException ex) {
                            return false;
                        }
                    }
                    return lhsString.startsWith(rhsOperand);
                }
            }
            ,
            ENDSWITH(" endsWith "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    if (rhsIsAttribute) {
                        if (inst.isMissing(rhsAttIndex)) {
                            return false;
                        }
                        try {
                            String rhsString = inst.stringValue(rhsAttIndex);
                            return lhsString.endsWith(rhsString);
                        }
                        catch (IllegalArgumentException ex) {
                            return false;
                        }
                    }
                    return lhsString.endsWith(rhsOperand);
                }
            }
            ,
            REGEX(" regex "){

                @Override
                boolean evaluate(Instance inst, int lhsAttIndex, String rhsOperand, double numericOperand, Pattern regexPattern, boolean rhsIsAttribute, int rhsAttIndex) {
                    if (inst.isMissing(lhsAttIndex)) {
                        return false;
                    }
                    if (regexPattern == null) {
                        return false;
                    }
                    String lhsString = "";
                    try {
                        lhsString = inst.stringValue(lhsAttIndex);
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    return regexPattern.matcher(lhsString).matches();
                }
            };

            private final String m_stringVal;

            abstract boolean evaluate(Instance var1, int var2, String var3, double var4, Pattern var6, boolean var7, int var8);

            private ExpressionType(String name) {
                this.m_stringVal = name;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }

    public static class BracketNode
    extends ExpressionNode
    implements Serializable {
        private static final long serialVersionUID = 8732159083173001115L;
        protected List<ExpressionNode> m_children = new ArrayList<ExpressionNode>();

        @Override
        public void init(Instances structure, Environment env) {
            super.init(structure, env);
            for (ExpressionNode n : this.m_children) {
                n.init(structure, env);
            }
        }

        @Override
        public boolean evaluate(Instance inst, boolean result) {
            boolean thisNode = true;
            if (this.m_children.size() > 0) {
                for (ExpressionNode n : this.m_children) {
                    thisNode = n.evaluate(inst, thisNode);
                }
                if (this.isNegated()) {
                    boolean bl = thisNode = !thisNode;
                }
            }
            return this.isOr() ? result || thisNode : result && thisNode;
        }

        public void addChild(ExpressionNode child) {
            this.m_children.add(child);
            if (this.m_children.size() > 0) {
                this.m_children.get(0).setShowAndOr(false);
            }
        }

        public void removeChild(ExpressionNode child) {
            this.m_children.remove(child);
            if (this.m_children.size() > 0) {
                this.m_children.get(0).setShowAndOr(false);
            }
        }

        public String toString() {
            String result = "( )";
            if (this.isNegated()) {
                result = "!" + result;
            }
            if (this.m_showAndOr) {
                result = this.m_isAnOr ? "|| " + result : "&& " + result;
            }
            return result;
        }

        @Override
        public DefaultMutableTreeNode toJTree(DefaultMutableTreeNode parent) {
            DefaultMutableTreeNode current = new DefaultMutableTreeNode(this);
            if (parent != null) {
                parent.add(current);
            }
            for (ExpressionNode child : this.m_children) {
                child.toJTree(current);
            }
            return current;
        }

        private void toString(StringBuffer buff, boolean internal) {
            if (this.m_children.size() >= 0) {
                if (internal || this.m_showAndOr) {
                    if (this.m_isAnOr) {
                        buff.append("|| ");
                    } else {
                        buff.append("&& ");
                    }
                }
                if (this.isNegated()) {
                    buff.append("!");
                }
                buff.append("(");
                int count = 0;
                for (ExpressionNode child : this.m_children) {
                    if (internal) {
                        child.toStringInternal(buff);
                    } else {
                        child.toStringDisplay(buff);
                    }
                    if (++count == this.m_children.size()) continue;
                    buff.append(" ");
                }
                buff.append(")");
            }
        }

        @Override
        public void toStringDisplay(StringBuffer buff) {
            this.toString(buff, false);
        }

        @Override
        public void toStringInternal(StringBuffer buff) {
            this.toString(buff, true);
        }

        @Override
        public String parseFromInternal(String expression) {
            if (expression.startsWith("|| ")) {
                this.m_isAnOr = true;
            }
            if (expression.startsWith("|| ") || expression.startsWith("&& ")) {
                expression = expression.substring(3, expression.length());
            }
            if (expression.charAt(0) == '!') {
                this.setNegated(true);
                expression = expression.substring(1, expression.length());
            }
            if (expression.charAt(0) != '(') {
                throw new IllegalArgumentException("Malformed expression! Was expecting a \"(\"");
            }
            expression = expression.substring(1, expression.length());
            while (expression.charAt(0) != ')') {
                ExpressionNode child;
                int offset = 3;
                if (expression.charAt(offset) == '(') {
                    child = new BracketNode();
                    expression = child.parseFromInternal(expression);
                    this.m_children.add(child);
                    continue;
                }
                child = new ExpressionClause();
                expression = child.parseFromInternal(expression);
                this.m_children.add(child);
            }
            if (this.m_children.size() > 0) {
                this.m_children.get(0).setShowAndOr(false);
            }
            return expression;
        }
    }

    public static abstract class ExpressionNode
    implements Serializable {
        private static final long serialVersionUID = -8427857202322768762L;
        protected boolean m_isAnOr;
        protected boolean m_isNegated;
        protected transient Environment m_env;
        protected boolean m_showAndOr = true;

        public void setIsOr(boolean isOr) {
            this.m_isAnOr = isOr;
        }

        public boolean isOr() {
            return this.m_isAnOr;
        }

        public boolean isNegated() {
            return this.m_isNegated;
        }

        public void setNegated(boolean negated) {
            this.m_isNegated = negated;
        }

        public void setShowAndOr(boolean show) {
            this.m_showAndOr = show;
        }

        public void init(Instances structure, Environment env) {
            this.m_env = env;
        }

        public abstract boolean evaluate(Instance var1, boolean var2);

        public abstract void toStringInternal(StringBuffer var1);

        public abstract void toStringDisplay(StringBuffer var1);

        protected abstract String parseFromInternal(String var1);

        public abstract DefaultMutableTreeNode toJTree(DefaultMutableTreeNode var1);
    }
}

