/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.PluginManager;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.OffscreenChartRenderer;
import weka.gui.beans.WekaOffscreenChartRenderer;
import weka.gui.visualize.PlotData2D;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.DataCollector;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="DataVisualizer", category="Visualization", toolTipText="Visualize training/test sets in a 2D scatter plot.", iconPath="weka/gui/knowledgeflow/icons/DefaultDataVisualizer.gif")
public class DataVisualizer
extends BaseStep
implements DataCollector {
    private static final long serialVersionUID = -8013077913672918384L;
    protected List<PlotData2D> m_plots = new ArrayList<PlotData2D>();
    protected transient OffscreenChartRenderer m_offscreenRenderer;
    protected String m_offscreenRendererName = "Weka Chart Renderer";
    protected String m_xAxis = "";
    protected String m_yAxis = "";
    protected String m_additionalOptions = "";
    protected String m_width = "500";
    protected String m_height = "400";

    @OptionMetadata(displayName="X-axis attribute", description="Attribute name or /first, /last or /<index>", displayOrder=1)
    public void setOffscreenXAxis(String xAxis) {
        this.m_xAxis = xAxis;
    }

    public String getOffscreenXAxis() {
        return this.m_xAxis;
    }

    @OptionMetadata(displayName="Y-axis attribute", description="Attribute name or /first, /last or /<index>", displayOrder=2)
    public void setOffscreenYAxis(String yAxis) {
        this.m_yAxis = yAxis;
    }

    public String getOffscreenYAxis() {
        return this.m_yAxis;
    }

    @OptionMetadata(displayName="Chart width (pixels)", description="Width of the rendered chart", displayOrder=3)
    public void setOffscreenWidth(String width) {
        this.m_width = width;
    }

    public String getOffscreenWidth() {
        return this.m_width;
    }

    @OptionMetadata(displayName="Chart height (pixels)", description="Height of the rendered chart", displayOrder=4)
    public void setOffscreenHeight(String height) {
        this.m_height = height;
    }

    public String getOffscreenHeight() {
        return this.m_height;
    }

    @ProgrammaticProperty
    public void setOffscreenRendererName(String rendererName) {
        this.m_offscreenRendererName = rendererName;
        this.m_offscreenRenderer = null;
    }

    public String getOffscreenRendererName() {
        return this.m_offscreenRendererName;
    }

    @ProgrammaticProperty
    public void setOffscreenAdditionalOpts(String additional) {
        this.m_additionalOptions = additional;
    }

    public String getOffscreenAdditionalOpts() {
        return this.m_additionalOptions;
    }

    protected void setupOffscreenRenderer() {
        this.getStepManager().logDetailed("Initializing offscreen renderer: " + this.getOffscreenRendererName());
        if (this.m_offscreenRenderer == null) {
            if (this.m_offscreenRendererName == null || this.m_offscreenRendererName.length() == 0) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                return;
            }
            if (this.m_offscreenRendererName.equalsIgnoreCase("weka chart renderer")) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
            } else {
                try {
                    Object r = PluginManager.getPluginInstance("weka.gui.beans.OffscreenChartRenderer", this.m_offscreenRendererName);
                    if (r != null && r instanceof OffscreenChartRenderer) {
                        this.m_offscreenRenderer = (OffscreenChartRenderer)r;
                    } else {
                        this.getStepManager().logWarning("Offscreen renderer '" + this.getOffscreenRendererName() + "' is not available, using default weka chart renderer instead");
                        this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.getStepManager().logWarning("Offscreen renderer '" + this.getOffscreenRendererName() + "' is not available, using default weka chart renderer instead");
                    this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                }
            }
        }
    }

    @Override
    public void stepInit() throws WekaException {
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        Instances toPlot = (Instances)data.getPrimaryPayload();
        String name = new SimpleDateFormat("HH:mm:ss.SSS - ").format(new Date());
        String relationName = toPlot.relationName();
        boolean connectIt = relationName.startsWith("__");
        if (connectIt) {
            toPlot = new Instances(toPlot);
            toPlot.setRelationName(relationName.substring(2));
        }
        PlotData2D pd = new PlotData2D(toPlot);
        if (connectIt) {
            boolean[] connect = new boolean[toPlot.numInstances()];
            for (int i = 1; i < toPlot.numInstances(); ++i) {
                if (!(toPlot.instance(i - 1).weight() >= 0.0) || !(toPlot.instance(i).weight() >= 0.0)) continue;
                connect[i] = true;
            }
            try {
                pd.setConnectPoints(connect);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
            relationName = relationName.substring(2);
        }
        String title = name + relationName;
        this.getStepManager().logDetailed("Processing " + title);
        pd.setPlotName(title);
        this.m_plots.add(pd);
        if (this.getStepManager().numOutgoingConnectionsOfType("image") > 0) {
            this.setupOffscreenRenderer();
            BufferedImage osi = this.createOffscreenPlot(pd);
            Data imageData = new Data("image", osi);
            if (relationName.length() > 10) {
                relationName = relationName.substring(0, 10);
            }
            imageData.setPayloadElement("aux_textTitle", relationName + ":" + this.m_xAxis + "," + this.m_yAxis);
            this.getStepManager().outputData(imageData);
        }
        this.getStepManager().finished();
    }

    protected BufferedImage createOffscreenPlot(PlotData2D pd) throws WekaException {
        String[] optionsParts;
        this.setupOffscreenRenderer();
        ArrayList<Instances> offscreenPlotInstances = new ArrayList<Instances>();
        Instances predictedI = pd.getPlotInstances();
        if (predictedI.classIndex() >= 0 && predictedI.classAttribute().isNominal()) {
            int i;
            Instances[] classes = new Instances[predictedI.numClasses()];
            for (i = 0; i < predictedI.numClasses(); ++i) {
                classes[i] = new Instances(predictedI, 0);
                classes[i].setRelationName(predictedI.classAttribute().value(i));
            }
            for (i = 0; i < predictedI.numInstances(); ++i) {
                Instance current = predictedI.instance(i);
                classes[(int)current.classValue()].add((Instance)current.copy());
            }
            for (Instances classe : classes) {
                offscreenPlotInstances.add(classe);
            }
        } else {
            offscreenPlotInstances.add(new Instances(predictedI));
        }
        ArrayList<String> options = new ArrayList<String>();
        String additional = this.m_additionalOptions;
        if (this.m_additionalOptions != null && this.m_additionalOptions.length() > 0) {
            additional = this.environmentSubstitute(additional);
        }
        if (additional != null && !additional.contains("-color")) {
            if (additional.length() > 0) {
                additional = additional + ",";
            }
            additional = predictedI.classIndex() >= 0 ? additional + "-color=" + predictedI.classAttribute().name() : additional + "-color=/last";
        }
        for (String p : optionsParts = additional.split(",")) {
            options.add(p.trim());
        }
        String xAxis = this.m_xAxis;
        xAxis = this.environmentSubstitute(xAxis);
        String yAxis = this.m_yAxis;
        yAxis = this.environmentSubstitute(yAxis);
        String width = this.m_width;
        String height = this.m_height;
        int defWidth = 500;
        int defHeight = 400;
        width = this.environmentSubstitute(width);
        height = this.environmentSubstitute(height);
        defWidth = Integer.parseInt(width);
        defHeight = Integer.parseInt(height);
        this.getStepManager().logDetailed("Creating image");
        try {
            return predictedI.relationName().startsWith("__") ? this.m_offscreenRenderer.renderXYLineChart(defWidth, defHeight, offscreenPlotInstances, xAxis, yAxis, options) : this.m_offscreenRenderer.renderXYScatterPlot(defWidth, defHeight, offscreenPlotInstances, xAxis, yAxis, options);
        }
        catch (Exception e2) {
            throw new WekaException(e2);
        }
    }

    public List<PlotData2D> getPlots() {
        return this.m_plots;
    }

    public void clearPlotData() {
        this.m_plots.clear();
    }

    @Override
    public Object retrieveData() {
        return this.getPlots();
    }

    @Override
    public void restoreData(Object data) throws WekaException {
        if (!(data instanceof List)) {
            throw new WekaException("Argument must be a List<PlotData2D>");
        }
        this.m_plots = (List)data;
        for (PlotData2D pd : this.m_plots) {
            this.createOffscreenPlot(pd);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("dataSet", "trainingSet", "testSet");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return this.getStepManager().numIncomingConnections() > 0 ? Arrays.asList("image") : new ArrayList<String>();
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.DataVisualizerStepEditorDialog";
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_plots.size() > 0) {
            views.put("Show charts", "weka.gui.knowledgeflow.steps.DataVisualizerInteractiveView");
        }
        return views;
    }
}

