/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.List;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="ClustererPerformanceEvaluator", category="Evaluation", toolTipText="Evaluates batch clusterers", iconPath="weka/gui/knowledgeflow/icons/ClustererPerformanceEvaluator.gif")
public class ClustererPerformanceEvaluator
extends BaseStep {
    private static final long serialVersionUID = -6337375482954345717L;

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("batchClusterer") == 0) {
            result.add("batchClusterer");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() > 0) {
            result.add("text");
        }
        return result;
    }

    @Override
    public void stepInit() {
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        Data text;
        String resultT;
        Clusterer clusterer = (Clusterer)data.getPayloadElement("batchClusterer");
        Instances trainData = (Instances)data.getPayloadElement("aux_trainingSet");
        Instances testData = (Instances)data.getPayloadElement("aux_testsSet");
        Integer setNum = (Integer)data.getPayloadElement("aux_set_num");
        Integer maxSetNum = (Integer)data.getPayloadElement("aux_max_set_num");
        if (setNum == 1) {
            this.getStepManager().processing();
        }
        ClusterEvaluation eval2 = new ClusterEvaluation();
        eval2.setClusterer(clusterer);
        String clusterSpec = this.makeClustererSpec(clusterer);
        String clusterClass = clusterer.getClass().getCanonicalName();
        clusterClass = clusterClass.substring(clusterClass.lastIndexOf(46) + 1, clusterClass.length());
        if (trainData != null && !this.isStopRequested()) {
            this.getStepManager().statusMessage("Evaluating (training set " + setNum + " of " + maxSetNum + ") " + clusterSpec);
            try {
                eval2.evaluateClusterer(trainData);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
            if (!this.isStopRequested()) {
                resultT = "=== Evaluation result for training instances ===\n\nScheme: " + clusterSpec + "\nRelation: " + trainData.relationName() + "\n\n" + eval2.clusterResultsToString();
                if (trainData.classIndex() >= 0 && trainData.classAttribute().isNumeric()) {
                    resultT = resultT + "\n\nNo class-based evaluation possible. Class attribute has to be nominal.";
                }
                text = new Data("text", resultT);
                text.setPayloadElement("aux_textTitle", clusterClass + " train (" + setNum + " of " + maxSetNum + ")");
                this.getStepManager().outputData(text);
            }
        }
        if (testData != null && !this.isStopRequested()) {
            this.getStepManager().statusMessage("Evaluating (test set " + setNum + " of " + maxSetNum + ") " + clusterSpec);
            eval2 = new ClusterEvaluation();
            eval2.setClusterer(clusterer);
            try {
                eval2.evaluateClusterer(testData);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
            if (!this.isStopRequested()) {
                resultT = "=== Evaluation result for test instances ===\n\nScheme: " + clusterSpec + "\nRelation: " + testData.relationName() + "\n\n" + eval2.clusterResultsToString();
                if (testData.classIndex() >= 0 && testData.classAttribute().isNumeric()) {
                    resultT = resultT + "\n\nNo class-based evaluation possible. Class attribute has to be nominal.";
                }
                text = new Data("text", resultT);
                text.setPayloadElement("aux_textTitle", clusterClass + " test (" + setNum + " of " + maxSetNum + ")");
                this.getStepManager().outputData(text);
            }
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
        } else if (setNum.intValue() == maxSetNum.intValue()) {
            this.getStepManager().finished();
        }
    }

    protected String makeClustererSpec(Clusterer clusterer) {
        String clusterSpec = clusterer.getClass().getCanonicalName();
        clusterSpec = clusterSpec.substring(clusterSpec.lastIndexOf(46) + 1, clusterSpec.length());
        String opts = " ";
        if (clusterer instanceof OptionHandler) {
            opts = Utils.joinOptions(((OptionHandler)((Object)clusterer)).getOptions());
        }
        return clusterSpec + opts;
    }
}

