/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="Block", category="Flow", toolTipText="Block until a specific step has finished procesing", iconPath="weka/gui/knowledgeflow/icons/DiamondPlain.gif")
public class Block
extends BaseStep {
    private static final long serialVersionUID = 3204082191908877620L;
    protected String m_stepToWaitFor = "";
    protected transient StepManager m_smForStep;

    @OptionMetadata(displayName="Wait until this step has completed", description="This step will prevent data from passing downstream until the specified step has finished processing")
    public void setStepToWaitFor(String stepToWaitFor) {
        this.m_stepToWaitFor = stepToWaitFor;
    }

    public String getStepToWaitFor() {
        return this.m_stepToWaitFor;
    }

    @Override
    public void stepInit() throws WekaException {
        if (this.m_stepToWaitFor == null || this.m_stepToWaitFor.length() == 0) {
            this.getStepManager().logWarning("No step to wait for specified - will not block");
        }
        this.m_smForStep = this.getStepManager().findStepInFlow(this.environmentSubstitute(this.m_stepToWaitFor));
        if (this.m_smForStep == this.getStepManager()) {
            throw new WekaException("Blocking on oneself will cause deadlock!");
        }
        if (this.m_smForStep == null) {
            throw new WekaException("Step '" + this.environmentSubstitute(this.m_stepToWaitFor) + "' does not seem to exist in the flow!");
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_smForStep == null) {
            this.getStepManager().outputData(data);
        } else {
            this.getStepManager().processing();
            this.getStepManager().logBasic("Waiting for step '" + this.environmentSubstitute(this.m_stepToWaitFor) + "'");
            this.getStepManager().statusMessage("Waiting for step '" + this.environmentSubstitute(this.m_stepToWaitFor) + "'");
            while (!this.m_smForStep.isStepFinished() && !this.isStopRequested()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    this.getStepManager().interrupted();
                    return;
                }
            }
            this.getStepManager().logBasic("Releasing data");
            this.getStepManager().statusMessage("Releasing data");
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
        } else {
            this.getStepManager().outputData(data);
            this.getStepManager().finished();
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("dataSet", "trainingSet", "instance", "testSet", "batchClassifier", "batchClusterer", "batchAssociator", "text");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        Set<String> inConnTypes = this.getStepManager().getIncomingConnections().keySet();
        return new ArrayList<String>(inConnTypes);
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.BlockStepEditorDialog";
    }
}

