/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.Serializable;
import java.util.concurrent.Callable;
import weka.knowledgeflow.CallbackNotifierDelegate;
import weka.knowledgeflow.DefaultCallbackNotifierDelegate;
import weka.knowledgeflow.ExecutionResult;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.StepTaskCallback;
import weka.knowledgeflow.steps.Step;

public abstract class StepTask<T>
implements Callable<ExecutionResult<T>>,
Serializable {
    private static final long serialVersionUID = 2995081029283027784L;
    protected ExecutionResult<T> m_result = new ExecutionResult();
    protected transient StepTaskCallback<T> m_callback;
    protected LogManager m_log;
    protected boolean m_resourceIntensive = true;
    protected boolean m_mustRunSingleThreaded;
    protected CallbackNotifierDelegate m_callbackNotifier = new DefaultCallbackNotifierDelegate();

    public StepTask(Step source) {
        this(source, null, false);
    }

    public StepTask(Step source, boolean resourceIntensive) {
        this(source, null, resourceIntensive);
    }

    public StepTask(Step source, StepTaskCallback<T> callback) {
        this(source, callback, false);
    }

    public StepTask(Step source, StepTaskCallback<T> callback, boolean resourceIntensive) {
        this.m_log = new LogManager(source);
        this.m_callback = callback;
        this.m_resourceIntensive = resourceIntensive;
    }

    public void setResourceIntensive(boolean resourceIntensive) {
        this.m_resourceIntensive = resourceIntensive;
    }

    public boolean isResourceIntensive() {
        return this.m_resourceIntensive;
    }

    public void setMustRunSingleThreaded(boolean singleThreaded) {
        this.m_mustRunSingleThreaded = singleThreaded;
    }

    public boolean getMustRunSingleThreaded() {
        return this.m_mustRunSingleThreaded;
    }

    protected final CallbackNotifierDelegate getCallbackNotifierDelegate() {
        return this.m_callbackNotifier;
    }

    protected final void setCallbackNotifierDelegate(CallbackNotifierDelegate delegate) {
        this.m_callbackNotifier = delegate;
    }

    protected final LogManager getLogHandler() {
        return this.m_log;
    }

    protected final void setLogHandler(LogManager log2) {
        this.m_log = log2;
    }

    protected final void notifyCallback() throws Exception {
        if (this.m_callback != null) {
            this.m_callbackNotifier.notifyCallback(this.m_callback, this, this.m_result);
        }
    }

    protected final ExecutionResult<T> getExecutionResult() {
        return this.m_result;
    }

    protected final void setExecutionResult(ExecutionResult<T> execResult) {
        this.m_result = execResult;
    }

    @Override
    public ExecutionResult<T> call() throws Exception {
        try {
            this.process();
        }
        catch (Exception ex) {
            this.getExecutionResult().setError(ex);
        }
        this.notifyCallback();
        return this.m_result;
    }

    public abstract void process() throws Exception;
}

