/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.Vector;
import weka.core.PluginManager;
import weka.core.WekaException;
import weka.core.WekaPackageClassLoaderManager;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.WekaWrapper;
import weka.gui.beans.xml.XMLBeans;
import weka.knowledgeflow.Flow;
import weka.knowledgeflow.FlowLoader;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.ClassAssigner;
import weka.knowledgeflow.steps.ClassValuePicker;
import weka.knowledgeflow.steps.Classifier;
import weka.knowledgeflow.steps.ClassifierPerformanceEvaluator;
import weka.knowledgeflow.steps.CrossValidationFoldMaker;
import weka.knowledgeflow.steps.DataVisualizer;
import weka.knowledgeflow.steps.FlowByExpression;
import weka.knowledgeflow.steps.ImageSaver;
import weka.knowledgeflow.steps.IncrementalClassifierEvaluator;
import weka.knowledgeflow.steps.Join;
import weka.knowledgeflow.steps.ModelPerformanceChart;
import weka.knowledgeflow.steps.Note;
import weka.knowledgeflow.steps.PredictionAppender;
import weka.knowledgeflow.steps.Saver;
import weka.knowledgeflow.steps.SerializedModelSaver;
import weka.knowledgeflow.steps.Sorter;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.StripChart;
import weka.knowledgeflow.steps.SubstringLabeler;
import weka.knowledgeflow.steps.SubstringReplacer;
import weka.knowledgeflow.steps.TextSaver;
import weka.knowledgeflow.steps.TrainTestSplitMaker;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

public class LegacyFlowLoader
implements FlowLoader {
    public static final String EXTENSION = "kfml";
    protected static final String STEP_LIST_PROPS = "weka/knowledgeflow/steps/steps.props";
    protected Vector<Object> m_beans;
    protected Vector<BeanConnection> m_connections;
    protected LogManager m_log;

    @Override
    public void setLog(Logger log2) {
        this.m_log = new LogManager(log2, false);
    }

    @Override
    public String getFlowFileExtension() {
        return EXTENSION;
    }

    @Override
    public String getFlowFileExtensionDescription() {
        return "Legacy XML-based Knowledge Flow configuration files";
    }

    @Override
    public Flow readFlow(File flowFile) throws WekaException {
        try {
            this.loadLegacy(new BufferedReader(new FileReader(flowFile)));
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        String name = flowFile.getName();
        name = name.substring(0, name.lastIndexOf(46));
        return this.makeFlow(name);
    }

    @Override
    public Flow readFlow(InputStream is) throws WekaException {
        this.loadLegacy(new InputStreamReader(is));
        return this.makeFlow("Untitled");
    }

    @Override
    public Flow readFlow(Reader r) throws WekaException {
        this.loadLegacy(r);
        return this.makeFlow("Untitled");
    }

    protected Flow makeFlow(String name) throws WekaException {
        Flow flow = new Flow();
        flow.setFlowName(name != null ? name : "Untitled");
        for (Object o : this.m_beans) {
            BeanInstance bean = (BeanInstance)o;
            StepManagerImpl newManager = this.handleStep(bean);
            if (newManager == null) continue;
            flow.addStep(newManager);
        }
        for (BeanConnection conn : this.m_connections) {
            this.handleConnection(flow, conn);
        }
        return flow;
    }

    protected void handleConnection(Flow flow, BeanConnection conn) {
        BeanInstance source = conn.getSource();
        BeanInstance target = conn.getTarget();
        if (!(source.getBean() instanceof BeanCommon) && !(target.getBean() instanceof BeanCommon)) {
            return;
        }
        BeanCommon sourceC = (BeanCommon)source.getBean();
        BeanCommon targetC = (BeanCommon)target.getBean();
        StepManagerImpl sourceNew = flow.findStep(sourceC.getCustomName());
        StepManagerImpl targetNew = flow.findStep(targetC.getCustomName());
        if (sourceNew == null || targetNew == null) {
            if (this.m_log != null) {
                this.m_log.logWarning("Unable to make connection in new flow between legacy steps " + sourceC.getCustomName() + " and " + targetC.getCustomName() + " for connection '" + conn.getEventName());
            }
            return;
        }
        String evntName = conn.getEventName();
        flow.connectSteps(sourceNew, targetNew, evntName, true);
    }

    protected StepManagerImpl handleStep(BeanInstance bean) throws WekaException {
        Object comp = bean.getBean();
        String name = "";
        if (comp instanceof BeanCommon) {
            BeanCommon beanCommon = (BeanCommon)comp;
            name = beanCommon.getCustomName();
        }
        int x = bean.getX();
        int y = bean.getY();
        Step match = this.findStepMatch(comp.getClass().getCanonicalName());
        if (match != null) {
            StepManagerImpl manager = new StepManagerImpl(match);
            manager.m_x = x;
            manager.m_y = y;
            if (!(comp instanceof WekaWrapper)) {
                this.copySettingsNonWrapper(comp, match);
            } else {
                this.copySettingsWrapper((WekaWrapper)comp, (WekaAlgorithmWrapper)match);
            }
            if (!(match instanceof Note)) {
                match.setName(name);
            }
            return manager;
        }
        if (this.m_log != null) {
            this.m_log.logWarning("Unable to find an equivalent for legacy step: " + comp.getClass().getCanonicalName());
        }
        return null;
    }

    protected void copySettingsWrapper(WekaWrapper legacy, WekaAlgorithmWrapper current) throws WekaException {
        Object wrappedAlgo = legacy.getWrappedAlgorithm();
        current.setWrappedAlgorithm(wrappedAlgo);
        if (legacy instanceof weka.gui.beans.Classifier && current instanceof Classifier) {
            ((Classifier)current).setLoadClassifierFileName(new File(((weka.gui.beans.Classifier)legacy).getLoadClassifierFileName()));
            ((Classifier)current).setUpdateIncrementalClassifier(((weka.gui.beans.Classifier)legacy).getUpdateIncrementalClassifier());
            ((Classifier)current).setResetIncrementalClassifier(((weka.gui.beans.Classifier)legacy).getResetIncrementalClassifier());
        } else if (legacy instanceof weka.gui.beans.Saver && current instanceof Saver) {
            ((Saver)current).setRelationNameForFilename(((weka.gui.beans.Saver)legacy).getRelationNameForFilename());
        }
    }

    protected void copySettingsNonWrapper(Object legacy, Step current) throws WekaException {
        if (current instanceof Note && legacy instanceof weka.gui.beans.Note) {
            ((Note)current).setNoteText(((weka.gui.beans.Note)legacy).getNoteText());
        } else if (current instanceof TrainTestSplitMaker && legacy instanceof weka.gui.beans.TrainTestSplitMaker) {
            ((TrainTestSplitMaker)current).setSeed("" + ((weka.gui.beans.TrainTestSplitMaker)legacy).getSeed());
            ((TrainTestSplitMaker)current).setTrainPercent("" + ((weka.gui.beans.TrainTestSplitMaker)legacy).getTrainPercent());
        } else if (current instanceof CrossValidationFoldMaker && legacy instanceof weka.gui.beans.CrossValidationFoldMaker) {
            ((CrossValidationFoldMaker)current).setSeed("" + ((weka.gui.beans.CrossValidationFoldMaker)legacy).getSeed());
            ((CrossValidationFoldMaker)current).setNumFolds("" + ((weka.gui.beans.CrossValidationFoldMaker)legacy).getFolds());
            ((CrossValidationFoldMaker)current).setPreserveOrder(((weka.gui.beans.CrossValidationFoldMaker)legacy).getPreserveOrder());
        } else if (current instanceof ClassAssigner && legacy instanceof weka.gui.beans.ClassAssigner) {
            ((ClassAssigner)current).setClassColumn(((weka.gui.beans.ClassAssigner)legacy).getClassColumn());
        } else if (current instanceof ClassValuePicker && legacy instanceof weka.gui.beans.ClassValuePicker) {
            ((ClassValuePicker)current).setClassValue(((weka.gui.beans.ClassValuePicker)legacy).getClassValue());
        } else if (current instanceof ClassifierPerformanceEvaluator && legacy instanceof weka.gui.beans.ClassifierPerformanceEvaluator) {
            ((ClassifierPerformanceEvaluator)current).setEvaluationMetricsToOutput(((weka.gui.beans.ClassifierPerformanceEvaluator)legacy).getEvaluationMetricsToOutput());
            ((ClassifierPerformanceEvaluator)current).setErrorPlotPointSizeProportionalToMargin(((weka.gui.beans.ClassifierPerformanceEvaluator)legacy).getErrorPlotPointSizeProportionalToMargin());
        } else if (current instanceof IncrementalClassifierEvaluator && legacy instanceof weka.gui.beans.IncrementalClassifierEvaluator) {
            ((IncrementalClassifierEvaluator)current).setChartingEvalWindowSize(((weka.gui.beans.IncrementalClassifierEvaluator)legacy).getChartingEvalWindowSize());
            ((IncrementalClassifierEvaluator)current).setOutputPerClassInfoRetrievalStats(((weka.gui.beans.IncrementalClassifierEvaluator)legacy).getOutputPerClassInfoRetrievalStats());
            ((IncrementalClassifierEvaluator)current).setStatusFrequency(((weka.gui.beans.IncrementalClassifierEvaluator)legacy).getStatusFrequency());
        } else if (current instanceof PredictionAppender && legacy instanceof weka.gui.beans.PredictionAppender) {
            ((PredictionAppender)current).setAppendProbabilities(((weka.gui.beans.PredictionAppender)legacy).getAppendPredictedProbabilities());
        } else if (current instanceof SerializedModelSaver && legacy instanceof weka.gui.beans.SerializedModelSaver) {
            ((SerializedModelSaver)current).setFilenamePrefix(((weka.gui.beans.SerializedModelSaver)legacy).getPrefix());
            ((SerializedModelSaver)current).setIncludeRelationNameInFilename(((weka.gui.beans.SerializedModelSaver)legacy).getIncludeRelationName());
            ((SerializedModelSaver)current).setOutputDirectory(((weka.gui.beans.SerializedModelSaver)legacy).getDirectory());
            ((SerializedModelSaver)current).setIncrementalSaveSchedule(((weka.gui.beans.SerializedModelSaver)legacy).getIncrementalSaveSchedule());
        } else if (current instanceof ImageSaver && legacy instanceof weka.gui.beans.ImageSaver) {
            ((ImageSaver)current).setFile(new File(((weka.gui.beans.ImageSaver)legacy).getFilename()));
        } else if (current instanceof TextSaver && legacy instanceof weka.gui.beans.TextSaver) {
            ((TextSaver)current).setFile(new File(((weka.gui.beans.TextSaver)legacy).getFilename()));
            ((TextSaver)current).setAppend(((weka.gui.beans.TextSaver)legacy).getAppend());
        } else if (current instanceof StripChart && legacy instanceof weka.gui.beans.StripChart) {
            ((StripChart)current).setRefreshFreq(((weka.gui.beans.StripChart)legacy).getRefreshFreq());
            ((StripChart)current).setRefreshWidth(((weka.gui.beans.StripChart)legacy).getRefreshWidth());
            ((StripChart)current).setXLabelFreq(((weka.gui.beans.StripChart)legacy).getXLabelFreq());
        } else if (current instanceof ModelPerformanceChart && legacy instanceof weka.gui.beans.ModelPerformanceChart) {
            ((ModelPerformanceChart)current).setOffscreenAdditionalOpts(((weka.gui.beans.ModelPerformanceChart)legacy).getOffscreenAdditionalOpts());
            ((ModelPerformanceChart)current).setOffscreenRendererName(((weka.gui.beans.ModelPerformanceChart)legacy).getOffscreenRendererName());
            ((ModelPerformanceChart)current).setOffscreenHeight(((weka.gui.beans.ModelPerformanceChart)legacy).getOffscreenHeight());
            ((ModelPerformanceChart)current).setOffscreenWidth(((weka.gui.beans.ModelPerformanceChart)legacy).getOffscreenWidth());
            ((ModelPerformanceChart)current).setOffscreenXAxis(((weka.gui.beans.ModelPerformanceChart)legacy).getOffscreenXAxis());
            ((ModelPerformanceChart)current).setOffscreenYAxis(((weka.gui.beans.ModelPerformanceChart)legacy).getOffscreenYAxis());
        } else if (current instanceof DataVisualizer && legacy instanceof weka.gui.beans.DataVisualizer) {
            ((DataVisualizer)current).setOffscreenHeight(((weka.gui.beans.DataVisualizer)legacy).getOffscreenHeight());
            ((DataVisualizer)current).setOffscreenWidth(((weka.gui.beans.DataVisualizer)legacy).getOffscreenWidth());
            ((DataVisualizer)current).setOffscreenXAxis(((weka.gui.beans.DataVisualizer)legacy).getOffscreenXAxis());
            ((DataVisualizer)current).setOffscreenRendererName(((weka.gui.beans.DataVisualizer)legacy).getOffscreenRendererName());
            ((DataVisualizer)current).setOffscreenAdditionalOpts(((weka.gui.beans.DataVisualizer)legacy).getOffscreenAdditionalOpts());
        } else if (current instanceof FlowByExpression && legacy instanceof weka.gui.beans.FlowByExpression) {
            ((FlowByExpression)current).setExpressionString(((weka.gui.beans.FlowByExpression)legacy).getExpressionString());
            ((FlowByExpression)current).setTrueStepName(((weka.gui.beans.FlowByExpression)legacy).getTrueStepName());
            ((FlowByExpression)current).setFalseStepName(((weka.gui.beans.FlowByExpression)legacy).getFalseStepName());
        } else if (current instanceof Join && legacy instanceof weka.gui.beans.Join) {
            ((Join)current).setKeySpec(((weka.gui.beans.Join)legacy).getKeySpec());
        } else if (current instanceof Sorter && legacy instanceof weka.gui.beans.Sorter) {
            ((Sorter)current).setSortDetails(((weka.gui.beans.Sorter)legacy).getSortDetails());
            ((Sorter)current).setBufferSize(((weka.gui.beans.Sorter)legacy).getBufferSize());
            ((Sorter)current).setTempDirectory(new File(((weka.gui.beans.Sorter)legacy).getTempDirectory()));
        } else if (current instanceof SubstringReplacer && legacy instanceof weka.gui.beans.SubstringReplacer) {
            ((SubstringReplacer)current).setMatchReplaceDetails(((weka.gui.beans.SubstringReplacer)legacy).getMatchReplaceDetails());
        } else if (current instanceof SubstringLabeler && legacy instanceof weka.gui.beans.SubstringLabeler) {
            ((SubstringLabeler)current).setMatchDetails(((weka.gui.beans.SubstringLabeler)legacy).getMatchDetails());
            ((SubstringLabeler)current).setConsumeNonMatching(((weka.gui.beans.SubstringLabeler)legacy).getConsumeNonMatching());
            ((SubstringLabeler)current).setMatchAttributeName(((weka.gui.beans.SubstringLabeler)legacy).getMatchAttributeName());
            ((SubstringLabeler)current).setNominalBinary(((weka.gui.beans.SubstringLabeler)legacy).getNominalBinary());
        } else {
            this.configurePluginStep(legacy, current);
        }
    }

    protected void transferSetting(Object legacy, Step current, String propName, Class propType) throws WekaException {
        try {
            Method getM = legacy.getClass().getMethod("get" + propName, new Class[0]);
            Object value = getM.invoke(legacy, new Object[0]);
            Method setM = current.getClass().getMethod("set" + propName, propType);
            setM.invoke((Object)current, value);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected void configurePluginStep(Object legacy, Step current) throws WekaException {
        if (legacy.getClass().toString().endsWith("PythonScriptExecutor") && current.getClass().toString().endsWith("PythonScriptExecutor")) {
            try {
                this.transferSetting(legacy, current, "Debug", Boolean.TYPE);
                this.transferSetting(legacy, current, "PythonScript", String.class);
                Method getM = legacy.getClass().getDeclaredMethod("getScriptFile", new Class[0]);
                Object value = getM.invoke(legacy, new Object[0]);
                Method setM = current.getClass().getDeclaredMethod("setScriptFile", File.class);
                setM.invoke((Object)current, new File(value.toString()));
                this.transferSetting(legacy, current, "VariablesToGetFromPython", String.class);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        } else if (legacy.getClass().toString().endsWith("RScriptExecutor") && current.getClass().toString().endsWith("RScriptExecutor")) {
            try {
                this.transferSetting(legacy, current, "RScript", String.class);
                Method getM = legacy.getClass().getDeclaredMethod("getScriptFile", new Class[0]);
                Object value = getM.invoke(legacy, new Object[0]);
                Method setM = current.getClass().getDeclaredMethod("setScriptFile", File.class);
                setM.invoke((Object)current, new File(value.toString()));
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        } else if (legacy.getClass().toString().endsWith("JsonFieldExtractor") && current.getClass().toString().endsWith("JsonFieldExtractor")) {
            try {
                this.transferSetting(legacy, current, "PathDetails", String.class);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        } else if (legacy.getClass().toString().endsWith("TimeSeriesForecasting") && current.getClass().toString().endsWith("TimeSeriesForecasting")) {
            try {
                this.transferSetting(legacy, current, "EncodedForecaster", String.class);
                this.transferSetting(legacy, current, "NumStepsToForecast", String.class);
                this.transferSetting(legacy, current, "ArtificialTimeStartOffset", String.class);
                this.transferSetting(legacy, current, "RebuildForecaster", Boolean.TYPE);
                Method getM = legacy.getClass().getDeclaredMethod("getFilename", new Class[0]);
                Object value = getM.invoke(legacy, new Object[0]);
                Method setM = current.getClass().getDeclaredMethod("setFilename", File.class);
                setM.invoke((Object)current, new File(value.toString()));
                getM = legacy.getClass().getDeclaredMethod("getSaveFilename", new Class[0]);
                value = getM.invoke(legacy, new Object[0]);
                setM = current.getClass().getDeclaredMethod("setSaveFilename", File.class);
                setM.invoke((Object)current, new File(value.toString()));
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        } else if (legacy.getClass().toString().endsWith("GroovyComponent") && current.getClass().toString().endsWith("GroovyStep")) {
            this.transferSetting(legacy, current, "Script", String.class);
        } else if (legacy.getClass().getSuperclass().toString().endsWith("AbstractSparkJob") && current.getClass().getSuperclass().toString().endsWith("AbstractSparkJob")) {
            this.transferSetting(legacy, current, "JobOptions", String.class);
        } else if (legacy.getClass().getSuperclass().toString().endsWith("AbstractHadoopJob")) {
            this.transferSetting(legacy, current, "JobOptions", String.class);
        }
    }

    protected Step findStepMatch(String legacyFullyQualified) throws WekaException {
        String clazzNameOnly = legacyFullyQualified.substring(legacyFullyQualified.lastIndexOf(46) + 1, legacyFullyQualified.length());
        if (clazzNameOnly.equals("Note")) {
            return new Note();
        }
        Set<String> steps = PluginManager.getPluginNamesOfType(Step.class.getCanonicalName());
        Step result = null;
        if (steps != null) {
            for (String s : steps) {
                String sClazzNameOnly = s.substring(s.lastIndexOf(".") + 1);
                if (!sClazzNameOnly.equals(clazzNameOnly)) continue;
                try {
                    result = (Step)PluginManager.getPluginInstance(Step.class.getCanonicalName(), s);
                    break;
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
        }
        if (result == null) {
            String lastDitch = "weka.knowledgeflow.steps." + clazzNameOnly;
            try {
                result = (Step)WekaPackageClassLoaderManager.objectForName(lastDitch);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected void loadLegacy(Reader r) throws WekaException {
        BeanConnection.init();
        BeanInstance.init();
        try {
            XMLBeans xml = new XMLBeans(null, null, 0);
            Vector v = (Vector)xml.read(r);
            this.m_beans = (Vector)v.get(0);
            this.m_connections = (Vector)v.get(1);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    static {
        try {
            PluginManager.addFromProperties(LegacyFlowLoader.class.getClassLoader().getResourceAsStream(STEP_LIST_PROPS), true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

