/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weka.core.Environment;
import weka.knowledgeflow.Data;

public class JobEnvironment
extends Environment {
    protected Map<String, LinkedHashSet<Data>> m_resultData = new ConcurrentHashMap<String, LinkedHashSet<Data>>();
    protected Map<String, Map<String, String>> m_stepProperties = new ConcurrentHashMap<String, Map<String, String>>();

    public JobEnvironment() {
    }

    public JobEnvironment(Environment env) {
        super(env);
        if (env instanceof JobEnvironment) {
            this.m_stepProperties.putAll(((JobEnvironment)env).m_stepProperties);
        }
    }

    public void addToResult(Data data) {
        if (!data.isIncremental()) {
            LinkedHashSet<Data> dataList = this.m_resultData.get(data.getConnectionName());
            if (dataList == null) {
                dataList = new LinkedHashSet();
                this.m_resultData.put(data.getConnectionName(), dataList);
            }
            dataList.add(data);
        }
    }

    public void addAllResults(Map<String, LinkedHashSet<Data>> otherResults) {
        for (Map.Entry<String, LinkedHashSet<Data>> e2 : otherResults.entrySet()) {
            if (!this.m_resultData.containsKey(e2.getKey())) {
                this.m_resultData.put(e2.getKey(), e2.getValue());
                continue;
            }
            LinkedHashSet<Data> toAddTo = this.m_resultData.get(e2.getKey());
            toAddTo.addAll((Collection<Data>)e2.getValue());
        }
    }

    public LinkedHashSet<Data> getResultDataOfType(String connName) {
        LinkedHashSet<Data> results = this.m_resultData.remove(connName);
        return results;
    }

    public boolean hasResultDataOfType(String connName) {
        return this.m_resultData.containsKey(connName);
    }

    public Map<String, LinkedHashSet<Data>> getResultData() {
        return this.m_resultData;
    }

    public void clearResultData() {
        this.m_resultData.clear();
    }

    public Map<String, String> getStepProperties(String stepName) {
        return this.m_stepProperties.get(stepName);
    }

    public void clearStepProperties() {
        this.m_stepProperties.clear();
    }

    public void addToStepProperties(Map<String, Map<String, String>> propsToAdd) {
        this.m_stepProperties.putAll(propsToAdd);
    }
}

