/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.PluginManager;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.Logger;
import weka.gui.knowledgeflow.GraphicalEnvironmentCommandHandler;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.ExecutionEnvironment;
import weka.knowledgeflow.ExecutionResult;
import weka.knowledgeflow.FlowExecutor;
import weka.knowledgeflow.FlowRunner;
import weka.knowledgeflow.KFDefaults;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.StepTask;

public class BaseExecutionEnvironment
implements ExecutionEnvironment {
    public static final String DESCRIPTION = "Default execution environment";
    protected FlowExecutor m_flowExecutor;
    protected boolean m_headless;
    protected GraphicalEnvironmentCommandHandler m_graphicalEnvCommandHandler;
    protected transient Environment m_envVars = Environment.getSystemWide();
    protected transient Settings m_settings;
    protected transient ExecutorService m_executorService;
    protected transient ExecutorService m_clientExecutorService;
    protected transient ExecutorService m_singleThreadService;
    protected transient Logger m_log;
    protected transient LogManager m_logHandler;
    protected LoggingLevel m_loggingLevel = LoggingLevel.BASIC;

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean isHeadless() {
        return this.m_headless;
    }

    @Override
    public void setHeadless(boolean headless) {
        this.m_headless = headless;
    }

    @Override
    public GraphicalEnvironmentCommandHandler getGraphicalEnvironmentCommandHandler() {
        return this.m_graphicalEnvCommandHandler;
    }

    @Override
    public void setGraphicalEnvironmentCommandHandler(GraphicalEnvironmentCommandHandler handler) {
        this.m_graphicalEnvCommandHandler = handler;
    }

    @Override
    public Environment getEnvironmentVariables() {
        return this.m_envVars;
    }

    @Override
    public void setEnvironmentVariables(Environment env) {
        this.m_envVars = env;
    }

    @Override
    public void setSettings(Settings settings) {
        this.m_settings = settings;
        this.m_logHandler.setLoggingLevel(this.m_settings.getSetting("knowledgeflow.main", KFDefaults.LOGGING_LEVEL_KEY, KFDefaults.LOGGING_LEVEL));
    }

    @Override
    public Settings getSettings() {
        if (this.m_settings == null) {
            this.m_settings = new Settings("weka", "knowledgeflow");
        }
        return this.m_settings;
    }

    @Override
    public Logger getLog() {
        return this.m_log;
    }

    @Override
    public void setLog(Logger log2) {
        this.m_log = log2;
        if (this.m_logHandler == null) {
            this.m_logHandler = new LogManager(this.m_log);
            this.m_logHandler.m_statusMessagePrefix = "BaseExecutionEnvironment$" + this.hashCode() + "|";
        }
        this.m_logHandler.setLog(this.m_log);
    }

    @Override
    public LoggingLevel getLoggingLevel() {
        return this.m_loggingLevel;
    }

    @Override
    public void setLoggingLevel(LoggingLevel level) {
        this.m_loggingLevel = level;
    }

    @Override
    public <T> Future<ExecutionResult<T>> submitTask(StepTask<T> stepTask) throws WekaException {
        String taskType = "";
        if (stepTask.getMustRunSingleThreaded()) {
            taskType = " (single threaded)";
        } else if (stepTask.isResourceIntensive()) {
            taskType = " (resource intensive)";
        }
        this.m_logHandler.logDebug("Submitting " + stepTask.toString() + taskType);
        if (stepTask.getMustRunSingleThreaded()) {
            return this.m_singleThreadService.submit(stepTask);
        }
        if (stepTask.isResourceIntensive()) {
            return this.m_clientExecutorService.submit(stepTask);
        }
        return this.m_executorService.submit(stepTask);
    }

    @Override
    public void stopProcessing() {
        if (this.getFlowExecutor() != null) {
            this.getFlowExecutor().stopProcessing();
        }
        if (this.m_executorService != null) {
            this.m_executorService.shutdownNow();
            this.m_executorService = null;
        }
    }

    public FlowExecutor getDefaultFlowExecutor() {
        return new FlowRunner();
    }

    public FlowExecutor getFlowExecutor() {
        return this.m_flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor executor) {
        this.m_flowExecutor = executor;
    }

    protected void startClientExecutionService(int numThreadsMain, int numThreadsHighLoad) {
        if (this.m_executorService != null) {
            this.m_executorService.shutdownNow();
        }
        this.m_logHandler.logDebug("Requested number of threads for main step executor: " + numThreadsMain);
        this.m_logHandler.logDebug("Requested number of threads for high load executor: " + (numThreadsHighLoad > 0 ? numThreadsHighLoad : Runtime.getRuntime().availableProcessors()));
        this.m_executorService = numThreadsMain > 0 ? Executors.newFixedThreadPool(numThreadsMain) : Executors.newCachedThreadPool();
        this.m_clientExecutorService = numThreadsHighLoad > 0 ? Executors.newFixedThreadPool(numThreadsHighLoad) : Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.m_singleThreadService = Executors.newSingleThreadExecutor();
    }

    protected void stopClientExecutionService() {
        if (this.m_executorService != null) {
            this.m_executorService.shutdown();
            try {
                this.m_executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        if (this.m_clientExecutorService != null) {
            this.m_clientExecutorService.shutdown();
        }
        if (this.m_singleThreadService != null) {
            this.m_singleThreadService.shutdown();
        }
    }

    protected void launchStartPoint(final StepManagerImpl startPoint) throws WekaException {
        String taskType = startPoint.getStepMustRunSingleThreaded() ? " (single-threaded)" : (startPoint.stepIsResourceIntensive() ? " (resource intensive)" : "");
        this.m_logHandler.logDebug("Submitting " + startPoint.getName() + taskType);
        if (startPoint.getStepMustRunSingleThreaded()) {
            StepTask<Void> singleThreaded = new StepTask<Void>(null){
                private static final long serialVersionUID = -4008646793585608806L;

                @Override
                public void process() throws Exception {
                    startPoint.startStep();
                }
            };
            singleThreaded.setMustRunSingleThreaded(true);
            this.submitTask(singleThreaded);
        } else if (startPoint.stepIsResourceIntensive()) {
            this.submitTask(new StepTask<Void>(null){
                private static final long serialVersionUID = -5466021103296024455L;

                @Override
                public void process() throws Exception {
                    startPoint.startStep();
                }
            });
        } else {
            this.m_executorService.submit(new Runnable(){

                @Override
                public void run() {
                    startPoint.startStep();
                }
            });
        }
    }

    protected void sendDataToStep(final StepManagerImpl step, final Data ... data) throws WekaException {
        if (data != null) {
            if (data.length == 1 && StepManagerImpl.connectionIsIncremental(data[0])) {
                step.processIncoming(data[0]);
            } else {
                String taskType = step.getStepMustRunSingleThreaded() ? " (single-threaded)" : (step.stepIsResourceIntensive() ? " (resource intensive)" : "");
                this.m_logHandler.logDebug("Submitting " + step.getName() + taskType);
                if (step.getStepMustRunSingleThreaded()) {
                    this.m_singleThreadService.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (Data d : data) {
                                step.processIncoming(d);
                            }
                        }
                    });
                } else if (step.stepIsResourceIntensive()) {
                    this.m_clientExecutorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (Data d : data) {
                                step.processIncoming(d);
                            }
                        }
                    });
                } else {
                    this.m_executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (Data d : data) {
                                step.processIncoming(d);
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public Defaults getDefaultSettings() {
        return new BaseExecutionEnvironmentDefaults();
    }

    static {
        PluginManager.addPlugin(BaseExecutionEnvironment.class.getCanonicalName(), DESCRIPTION, BaseExecutionEnvironment.class.getCanonicalName());
    }

    public static class BaseExecutionEnvironmentDefaults
    extends Defaults {
        public static final Settings.SettingKey STEP_EXECUTOR_SERVICE_NUM_THREADS_KEY = new Settings.SettingKey("knowledgeflow.stepExecutorNumThreads", "Number of threads to use in the main step executor service", "");
        public static final int STEP_EXECUTOR_SERVICE_NUM_THREADS = 50;
        public static final Settings.SettingKey RESOURCE_INTENSIVE_EXECUTOR_SERVICE_NUM_THREADS_KEY = new Settings.SettingKey("knowledgeflow.highResourceExecutorNumThreads", "Number of threads to use in the resource intensive executor service", "<html>This executor service is used for executing StepTasks and<br>Steps that are marked as resource intensive. 0 = use as many<br>threads as there are cpu processors.</html>");
        public static final int RESOURCE_INTENSIVE_EXECUTOR_SERVICE_NUM_THREADS = 0;
        private static final long serialVersionUID = -3386792058002464330L;

        public BaseExecutionEnvironmentDefaults() {
            super("knowledgeflow");
            this.m_defaults.put(STEP_EXECUTOR_SERVICE_NUM_THREADS_KEY, 50);
            this.m_defaults.put(RESOURCE_INTENSIVE_EXECUTOR_SERVICE_NUM_THREADS_KEY, 0);
        }
    }
}

