/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Settings;
import weka.core.Utils;
import weka.gui.visualize.InstanceInfo;
import weka.gui.visualize.InstanceInfoFrame;
import weka.gui.visualize.Plot2DCompanion;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizeUtils;

public class Plot2D
extends JPanel {
    private static final long serialVersionUID = -1673162410856660442L;
    public static final int MAX_SHAPES = 5;
    public static final int ERROR_SHAPE = 1000;
    public static final int MISSING_SHAPE = 2000;
    public static final int CONST_AUTOMATIC_SHAPE = -1;
    public static final int X_SHAPE = 0;
    public static final int PLUS_SHAPE = 1;
    public static final int DIAMOND_SHAPE = 2;
    public static final int TRIANGLEUP_SHAPE = 3;
    public static final int TRIANGLEDOWN_SHAPE = 4;
    public static final int DEFAULT_SHAPE_SIZE = 2;
    protected Color m_axisColour = Color.green;
    protected Color m_backgroundColour = Color.black;
    protected ArrayList<PlotData2D> m_plots = new ArrayList();
    protected PlotData2D m_masterPlot = null;
    protected String m_masterName = "master plot";
    protected Instances m_plotInstances = null;
    protected Plot2DCompanion m_plotCompanion = null;
    protected Class<?> m_InstanceInfoFrameClass = null;
    protected JFrame m_InstanceInfo = null;
    protected ArrayList<Color> m_colorList;
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected int m_xIndex = 0;
    protected int m_yIndex = 0;
    protected int m_cIndex = 0;
    protected int m_sIndex = 0;
    protected double m_maxX;
    protected double m_minX;
    protected double m_maxY;
    protected double m_minY;
    protected double m_maxC;
    protected double m_minC;
    protected final int m_axisPad = 5;
    protected final int m_tickSize = 5;
    protected int m_XaxisStart = 0;
    protected int m_YaxisStart = 0;
    protected int m_XaxisEnd = 0;
    protected int m_YaxisEnd = 0;
    protected boolean m_plotResize = true;
    protected boolean m_axisChanged = false;
    protected int[][] m_drawnPoints;
    protected Font m_labelFont;
    protected FontMetrics m_labelMetrics = null;
    protected int m_JitterVal = 0;
    protected Random m_JRand = new Random(0L);

    public Plot2D() {
        this.setProperties();
        this.setBackground(this.m_backgroundColour);
        this.m_drawnPoints = new int[this.getWidth()][this.getHeight()];
        this.m_colorList = new ArrayList(10);
        for (int noa = this.m_colorList.size(); noa < 10; ++noa) {
            Color pc = this.m_DefaultColors[noa % 10];
            int ija = noa / 10;
            ija *= 2;
            for (int j = 0; j < ija; ++j) {
                pc = pc.darker();
            }
            this.m_colorList.add(pc);
        }
    }

    private void setProperties() {
        if (VisualizeUtils.VISUALIZE_PROPERTIES != null) {
            String thisClass = this.getClass().getName();
            String axisKey = thisClass + ".axisColour";
            String backgroundKey = thisClass + ".backgroundColour";
            String axisColour = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(axisKey);
            if (axisColour != null) {
                this.m_axisColour = VisualizeUtils.processColour(axisColour, this.m_axisColour);
            }
            String backgroundColour = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(backgroundKey);
            if (backgroundColour != null) {
                this.m_backgroundColour = VisualizeUtils.processColour(backgroundColour, this.m_backgroundColour);
            }
            try {
                this.m_InstanceInfoFrameClass = Class.forName(VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(thisClass + ".instanceInfoFrame", "weka.gui.visualize.InstanceInfoFrame"));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.m_InstanceInfoFrameClass = InstanceInfoFrame.class;
            }
        }
    }

    public void applySettings(Settings settings, String ownerID) {
        this.m_axisColour = settings.getSetting(ownerID, VisualizeUtils.VisualizeDefaults.AXIS_COLOUR_KEY, VisualizeUtils.VisualizeDefaults.AXIS_COLOR, Environment.getSystemWide());
        this.m_backgroundColour = settings.getSetting(ownerID, VisualizeUtils.VisualizeDefaults.BACKGROUND_COLOUR_KEY, VisualizeUtils.VisualizeDefaults.BACKGROUND_COLOR, Environment.getSystemWide());
        this.setBackground(this.m_backgroundColour);
        this.repaint();
    }

    public void setPlotCompanion(Plot2DCompanion p) {
        this.m_plotCompanion = p;
    }

    public void setJitter(int j) {
        if (this.m_plotInstances.numAttributes() > 0 && this.m_plotInstances.numInstances() > 0 && j >= 0) {
            this.m_JitterVal = j;
            this.m_JRand = new Random(this.m_JitterVal);
            this.m_drawnPoints = new int[this.m_XaxisEnd - this.m_XaxisStart + 1][this.m_YaxisEnd - this.m_YaxisStart + 1];
            this.updatePturb();
            this.repaint();
        }
    }

    public void setColours(ArrayList<Color> cols) {
        this.m_colorList = cols;
    }

    public void setXindex(int x) {
        this.m_xIndex = x;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            this.m_plots.get(i).setXindex(this.m_xIndex);
        }
        this.determineBounds();
        if (this.m_JitterVal != 0) {
            this.updatePturb();
        }
        this.m_axisChanged = true;
        this.repaint();
    }

    public void setYindex(int y) {
        this.m_yIndex = y;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            this.m_plots.get(i).setYindex(this.m_yIndex);
        }
        this.determineBounds();
        if (this.m_JitterVal != 0) {
            this.updatePturb();
        }
        this.m_axisChanged = true;
        this.repaint();
    }

    public void setCindex(int c) {
        this.m_cIndex = c;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            this.m_plots.get(i).setCindex(this.m_cIndex);
        }
        this.determineBounds();
        this.m_axisChanged = true;
        this.repaint();
    }

    public ArrayList<PlotData2D> getPlots() {
        return this.m_plots;
    }

    public PlotData2D getMasterPlot() {
        return this.m_masterPlot;
    }

    public double getMaxX() {
        return this.m_maxX;
    }

    public double getMaxY() {
        return this.m_maxY;
    }

    public double getMinX() {
        return this.m_minX;
    }

    public double getMinY() {
        return this.m_minY;
    }

    public double getMaxC() {
        return this.m_maxC;
    }

    public double getMinC() {
        return this.m_minC;
    }

    public void setInstances(Instances inst) throws Exception {
        PlotData2D tempPlot = new PlotData2D(inst);
        tempPlot.setPlotName("master plot");
        this.setMasterPlot(tempPlot);
    }

    public void setMasterPlot(PlotData2D master) throws Exception {
        if (master.m_plotInstances == null) {
            throw new Exception("No instances in plot data!");
        }
        this.removeAllPlots();
        this.m_masterPlot = master;
        this.m_plots.add(this.m_masterPlot);
        this.m_plotInstances = this.m_masterPlot.m_plotInstances;
        this.m_xIndex = 0;
        this.m_yIndex = 0;
        this.m_cIndex = 0;
        this.determineBounds();
    }

    public void removeAllPlots() {
        this.m_masterPlot = null;
        this.m_plotInstances = null;
        this.m_plots = new ArrayList();
        this.m_xIndex = 0;
        this.m_yIndex = 0;
        this.m_cIndex = 0;
    }

    public void addPlot(PlotData2D newPlot) throws Exception {
        if (newPlot.m_plotInstances == null) {
            throw new Exception("No instances in plot data!");
        }
        if (this.m_masterPlot != null) {
            if (!this.m_masterPlot.m_plotInstances.equalHeaders(newPlot.m_plotInstances)) {
                throw new Exception("Plot2D :Plot data's instances are incompatable  with master plot");
            }
        } else {
            this.m_masterPlot = newPlot;
            this.m_plotInstances = this.m_masterPlot.m_plotInstances;
        }
        this.m_plots.add(newPlot);
        this.setXindex(this.m_xIndex);
        this.setYindex(this.m_yIndex);
        this.setCindex(this.m_cIndex);
    }

    private void setFonts(Graphics gx) {
        if (this.m_labelMetrics == null) {
            this.m_labelFont = new Font("Monospaced", 0, 12);
            this.m_labelMetrics = gx.getFontMetrics(this.m_labelFont);
        }
        gx.setFont(this.m_labelFont);
    }

    public void searchPoints(int x, int y, final boolean newFrame) {
        if (this.m_masterPlot.m_plotInstances != null) {
            int longest = 0;
            for (int j = 0; j < this.m_masterPlot.m_plotInstances.numAttributes(); ++j) {
                if (this.m_masterPlot.m_plotInstances.attribute(j).name().length() <= longest) continue;
                longest = this.m_masterPlot.m_plotInstances.attribute(j).name().length();
            }
            StringBuffer insts = new StringBuffer();
            Vector<Instances> data = new Vector<Instances>();
            for (int jj = 0; jj < this.m_plots.size(); ++jj) {
                PlotData2D temp_plot = this.m_plots.get(jj);
                data.add(new Instances(temp_plot.m_plotInstances, 0));
                for (int i = 0; i < temp_plot.m_plotInstances.numInstances(); ++i) {
                    if (temp_plot.m_pointLookup[i][0] == Double.NEGATIVE_INFINITY) continue;
                    double px = temp_plot.m_pointLookup[i][0] + temp_plot.m_pointLookup[i][2];
                    double py = temp_plot.m_pointLookup[i][1] + temp_plot.m_pointLookup[i][3];
                    double size = temp_plot.m_shapeSize[i];
                    if (!((double)x >= px - size) || !((double)x <= px + size) || !((double)y >= py - size) || !((double)y <= py + size)) continue;
                    data.get(jj).add((Instance)temp_plot.m_plotInstances.instance(i).copy());
                    insts.append("\nPlot : " + temp_plot.m_plotName + "\nInstance: " + (i + 1) + "\n");
                    if (temp_plot.m_plotInstances.instance(i).weight() != 1.0) {
                        insts.append("Weight : " + temp_plot.m_plotInstances.instance(i).weight() + "\n");
                    }
                    for (int j = 0; j < temp_plot.m_plotInstances.numAttributes(); ++j) {
                        for (int k = 0; k < longest - temp_plot.m_plotInstances.attribute(j).name().length(); ++k) {
                            insts.append(" ");
                        }
                        insts.append(temp_plot.m_plotInstances.attribute(j).name());
                        insts.append(" : ");
                        if (temp_plot.m_plotInstances.instance(i).isMissing(j)) {
                            insts.append("Missing");
                        } else if (temp_plot.m_plotInstances.attribute(j).isNominal() || temp_plot.m_plotInstances.attribute(j).isString()) {
                            insts.append(temp_plot.m_plotInstances.attribute(j).value((int)temp_plot.m_plotInstances.instance(i).value(j)));
                        } else {
                            insts.append(temp_plot.m_plotInstances.instance(i).value(j));
                        }
                        insts.append("\n");
                    }
                }
            }
            int i = 0;
            while (data.size() > i) {
                if (((Instances)data.get(i)).numInstances() == 0) {
                    data.remove(i);
                    continue;
                }
                ++i;
            }
            if (insts.length() > 0) {
                if (newFrame || this.m_InstanceInfo == null) {
                    try {
                        final JFrame jf = (JFrame)this.m_InstanceInfoFrameClass.newInstance();
                        ((InstanceInfo)((Object)jf)).setInfoText(insts.toString());
                        ((InstanceInfo)((Object)jf)).setInfoData(data);
                        final JFrame testf = this.m_InstanceInfo;
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e2) {
                                if (!newFrame || testf == null) {
                                    Plot2D.this.m_InstanceInfo = null;
                                }
                                jf.dispose();
                            }
                        });
                        jf.setVisible(true);
                        if (this.m_InstanceInfo == null) {
                            this.m_InstanceInfo = jf;
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                } else {
                    ((InstanceInfo)((Object)this.m_InstanceInfo)).setInfoText(insts.toString());
                    ((InstanceInfo)((Object)this.m_InstanceInfo)).setInfoData(data);
                }
            }
        }
    }

    public void determineBounds() {
        this.m_minX = this.m_plots.get((int)0).m_minX;
        this.m_maxX = this.m_plots.get((int)0).m_maxX;
        this.m_minY = this.m_plots.get((int)0).m_minY;
        this.m_maxY = this.m_plots.get((int)0).m_maxY;
        this.m_minC = this.m_plots.get((int)0).m_minC;
        this.m_maxC = this.m_plots.get((int)0).m_maxC;
        for (int i = 1; i < this.m_plots.size(); ++i) {
            double value = this.m_plots.get((int)i).m_minX;
            if (value < this.m_minX) {
                this.m_minX = value;
            }
            if ((value = this.m_plots.get((int)i).m_maxX) > this.m_maxX) {
                this.m_maxX = value;
            }
            if ((value = this.m_plots.get((int)i).m_minY) < this.m_minY) {
                this.m_minY = value;
            }
            if ((value = this.m_plots.get((int)i).m_maxY) > this.m_maxY) {
                this.m_maxY = value;
            }
            if ((value = this.m_plots.get((int)i).m_minC) < this.m_minC) {
                this.m_minC = value;
            }
            if (!((value = this.m_plots.get((int)i).m_maxC) > this.m_maxC)) continue;
            this.m_maxC = value;
        }
        this.fillLookup();
        this.repaint();
    }

    public double convertToAttribX(double scx) {
        double temp = this.m_XaxisEnd - this.m_XaxisStart;
        double temp2 = (scx - (double)this.m_XaxisStart) * (this.m_maxX - this.m_minX) / temp;
        return temp2 += this.m_minX;
    }

    public double convertToAttribY(double scy) {
        double temp = this.m_YaxisEnd - this.m_YaxisStart;
        double temp2 = (scy - (double)this.m_YaxisEnd) * (this.m_maxY - this.m_minY) / temp;
        temp2 = -(temp2 - this.m_minY);
        return temp2;
    }

    int pturbX(double xvalP, double xj) {
        int xpturb = 0;
        if (this.m_JitterVal > 0 && (xvalP + (double)(xpturb = (int)((double)this.m_JitterVal * (xj / 2.0))) < (double)this.m_XaxisStart || xvalP + (double)xpturb > (double)this.m_XaxisEnd)) {
            xpturb *= -1;
        }
        return xpturb;
    }

    public double convertToPanelX(double xval) {
        double temp = (xval - this.m_minX) / (this.m_maxX - this.m_minX);
        double temp2 = temp * (double)(this.m_XaxisEnd - this.m_XaxisStart);
        return temp2 += (double)this.m_XaxisStart;
    }

    int pturbY(double yvalP, double yj) {
        int ypturb = 0;
        if (this.m_JitterVal > 0 && (yvalP + (double)(ypturb = (int)((double)this.m_JitterVal * (yj / 2.0))) < (double)this.m_YaxisStart || yvalP + (double)ypturb > (double)this.m_YaxisEnd)) {
            ypturb *= -1;
        }
        return ypturb;
    }

    public double convertToPanelY(double yval) {
        double temp = (yval - this.m_minY) / (this.m_maxY - this.m_minY);
        double temp2 = temp * (double)(this.m_YaxisEnd - this.m_YaxisStart);
        temp2 = (double)this.m_YaxisEnd - temp2;
        return temp2;
    }

    private static void drawX(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)(x - (double)size), (int)(y - (double)size), (int)(x + (double)size), (int)(y + (double)size));
        gx.drawLine((int)(x + (double)size), (int)(y - (double)size), (int)(x - (double)size), (int)(y + (double)size));
    }

    private static void drawPlus(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)(x - (double)size), (int)y, (int)(x + (double)size), (int)y);
        gx.drawLine((int)x, (int)(y - (double)size), (int)x, (int)(y + (double)size));
    }

    private static void drawDiamond(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)(x - (double)size), (int)y, (int)x, (int)(y - (double)size));
        gx.drawLine((int)x, (int)(y - (double)size), (int)(x + (double)size), (int)y);
        gx.drawLine((int)(x + (double)size), (int)y, (int)x, (int)(y + (double)size));
        gx.drawLine((int)x, (int)(y + (double)size), (int)(x - (double)size), (int)y);
    }

    private static void drawTriangleUp(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)x, (int)(y - (double)size), (int)(x - (double)size), (int)(y + (double)size));
        gx.drawLine((int)(x - (double)size), (int)(y + (double)size), (int)(x + (double)size), (int)(y + (double)size));
        gx.drawLine((int)(x + (double)size), (int)(y + (double)size), (int)x, (int)(y - (double)size));
    }

    private static void drawTriangleDown(Graphics gx, double x, double y, int size) {
        gx.drawLine((int)x, (int)(y + (double)size), (int)(x - (double)size), (int)(y - (double)size));
        gx.drawLine((int)(x - (double)size), (int)(y - (double)size), (int)(x + (double)size), (int)(y - (double)size));
        gx.drawLine((int)(x + (double)size), (int)(y - (double)size), (int)x, (int)(y + (double)size));
    }

    protected static void drawDataPoint(double x, double y, double xprev, double yprev, int size, int shape, Graphics gx) {
        Plot2D.drawDataPoint(x, y, size, shape, gx);
        gx.drawLine((int)x, (int)y, (int)xprev, (int)yprev);
    }

    protected static void drawDataPoint(double x, double y, int size, int shape, Graphics gx) {
        Font lf = new Font("Monospaced", 0, 12);
        FontMetrics fm = gx.getFontMetrics(lf);
        if (size == 0) {
            size = 1;
        }
        if (shape != 1000 && shape != 2000) {
            shape %= 5;
        }
        switch (shape) {
            case 0: {
                Plot2D.drawX(gx, x, y, size);
                break;
            }
            case 1: {
                Plot2D.drawPlus(gx, x, y, size);
                break;
            }
            case 2: {
                Plot2D.drawDiamond(gx, x, y, size);
                break;
            }
            case 3: {
                Plot2D.drawTriangleUp(gx, x, y, size);
                break;
            }
            case 4: {
                Plot2D.drawTriangleDown(gx, x, y, size);
                break;
            }
            case 1000: {
                gx.drawRect((int)(x - (double)size), (int)(y - (double)size), size * 2, size * 2);
                break;
            }
            case 2000: {
                int hf = fm.getAscent();
                int width = fm.stringWidth("M");
                gx.drawString("M", (int)(x - (double)(width / 2)), (int)(y + (double)(hf / 2)));
            }
        }
    }

    private void updatePturb() {
        double xj = 0.0;
        double yj = 0.0;
        for (int j = 0; j < this.m_plots.size(); ++j) {
            PlotData2D temp_plot = this.m_plots.get(j);
            for (int i = 0; i < temp_plot.m_plotInstances.numInstances(); ++i) {
                if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_xIndex) || temp_plot.m_plotInstances.instance(i).isMissing(this.m_yIndex)) continue;
                if (this.m_JitterVal > 0) {
                    xj = this.m_JRand.nextGaussian();
                    yj = this.m_JRand.nextGaussian();
                }
                temp_plot.m_pointLookup[i][2] = this.pturbX(temp_plot.m_pointLookup[i][0], xj);
                temp_plot.m_pointLookup[i][3] = this.pturbY(temp_plot.m_pointLookup[i][1], yj);
            }
        }
    }

    private void fillLookup() {
        for (int j = 0; j < this.m_plots.size(); ++j) {
            PlotData2D temp_plot = this.m_plots.get(j);
            if (temp_plot.m_plotInstances.numInstances() <= 0 || temp_plot.m_plotInstances.numAttributes() <= 0) continue;
            for (int i = 0; i < temp_plot.m_plotInstances.numInstances(); ++i) {
                if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_xIndex) || temp_plot.m_plotInstances.instance(i).isMissing(this.m_yIndex)) {
                    temp_plot.m_pointLookup[i][0] = Double.NEGATIVE_INFINITY;
                    temp_plot.m_pointLookup[i][1] = Double.NEGATIVE_INFINITY;
                    continue;
                }
                double x = this.convertToPanelX(temp_plot.m_plotInstances.instance(i).value(this.m_xIndex));
                double y = this.convertToPanelY(temp_plot.m_plotInstances.instance(i).value(this.m_yIndex));
                temp_plot.m_pointLookup[i][0] = x;
                temp_plot.m_pointLookup[i][1] = y;
            }
        }
    }

    private void paintData(Graphics gx) {
        for (int j = 0; j < this.m_plots.size(); ++j) {
            PlotData2D temp_plot = this.m_plots.get(j);
            for (int i = 0; i < temp_plot.m_plotInstances.numInstances(); ++i) {
                if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_xIndex) || temp_plot.m_plotInstances.instance(i).isMissing(this.m_yIndex)) continue;
                double x = temp_plot.m_pointLookup[i][0] + temp_plot.m_pointLookup[i][2];
                double y = temp_plot.m_pointLookup[i][1] + temp_plot.m_pointLookup[i][3];
                double prevx = 0.0;
                double prevy = 0.0;
                if (i > 0) {
                    prevx = temp_plot.m_pointLookup[i - 1][0] + temp_plot.m_pointLookup[i - 1][2];
                    prevy = temp_plot.m_pointLookup[i - 1][1] + temp_plot.m_pointLookup[i - 1][3];
                }
                int x_range = (int)x - this.m_XaxisStart;
                int y_range = (int)y - this.m_YaxisStart;
                if (x_range < 0 || y_range < 0 || this.m_drawnPoints[x_range][y_range] != i && this.m_drawnPoints[x_range][y_range] != 0 && temp_plot.m_shapeSize[i] != temp_plot.m_alwaysDisplayPointsOfThisSize && !temp_plot.m_displayAllPoints) continue;
                this.m_drawnPoints[x_range][y_range] = i;
                if (temp_plot.m_plotInstances.attribute(this.m_cIndex).isNominal()) {
                    Color ci;
                    if (temp_plot.m_plotInstances.attribute(this.m_cIndex).numValues() > this.m_colorList.size() && !temp_plot.m_useCustomColour) {
                        this.extendColourMap(temp_plot.m_plotInstances.attribute(this.m_cIndex).numValues());
                    }
                    if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                        ci = Color.gray;
                    } else {
                        int ind = (int)temp_plot.m_plotInstances.instance(i).value(this.m_cIndex);
                        ci = this.m_colorList.get(ind);
                    }
                    if (!temp_plot.m_useCustomColour) {
                        gx.setColor(ci);
                    } else {
                        gx.setColor(temp_plot.m_customColour);
                    }
                    if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                        if (temp_plot.m_connectPoints[i]) {
                            Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], 2000, gx);
                            continue;
                        }
                        Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], 2000, gx);
                        continue;
                    }
                    if (temp_plot.m_shapeType[i] == -1) {
                        if (temp_plot.m_connectPoints[i]) {
                            Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], j, gx);
                            continue;
                        }
                        Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], j, gx);
                        continue;
                    }
                    if (temp_plot.m_connectPoints[i]) {
                        Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
                        continue;
                    }
                    Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
                    continue;
                }
                Color ci = null;
                if (!temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                    double r = (temp_plot.m_plotInstances.instance(i).value(this.m_cIndex) - this.m_minC) / (this.m_maxC - this.m_minC);
                    r = r * 240.0 + 15.0;
                    ci = new Color((int)r, 150, (int)(255.0 - r));
                } else {
                    ci = Color.gray;
                }
                if (!temp_plot.m_useCustomColour) {
                    gx.setColor(ci);
                } else {
                    gx.setColor(temp_plot.m_customColour);
                }
                if (temp_plot.m_plotInstances.instance(i).isMissing(this.m_cIndex)) {
                    if (temp_plot.m_connectPoints[i]) {
                        Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], 2000, gx);
                        continue;
                    }
                    Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], 2000, gx);
                    continue;
                }
                if (temp_plot.m_shapeType[i] == -1) {
                    if (temp_plot.m_connectPoints[i]) {
                        Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], j, gx);
                        continue;
                    }
                    Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], j, gx);
                    continue;
                }
                if (temp_plot.m_connectPoints[i]) {
                    Plot2D.drawDataPoint(x, y, prevx, prevy, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
                    continue;
                }
                Plot2D.drawDataPoint(x, y, temp_plot.m_shapeSize[i], temp_plot.m_shapeType[i], gx);
            }
        }
    }

    private void paintAxis(Graphics gx) {
        int mye;
        int mys;
        int mxe;
        int mxs;
        block31: {
            int sw;
            int hf;
            block30: {
                double mx;
                String maxString;
                double mid;
                String minStringY;
                String maxStringY;
                int precisionYmid;
                int nondecimal;
                double decimal;
                int whole;
                int mswy;
                int w;
                int h;
                block29: {
                    block28: {
                        this.setFonts(gx);
                        mxs = this.m_XaxisStart;
                        mxe = this.m_XaxisEnd;
                        mys = this.m_YaxisStart;
                        mye = this.m_YaxisEnd;
                        this.m_plotResize = false;
                        h = this.getHeight();
                        w = this.getWidth();
                        hf = this.m_labelMetrics.getAscent();
                        int mswx = 0;
                        mswy = 0;
                        int precisionXmax = 1;
                        int precisionXmin = 1;
                        int precisionXmid = 1;
                        whole = (int)Math.abs(this.m_maxX);
                        decimal = Math.abs(this.m_maxX) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n = precisionXmax = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxX)) / Math.log(10.0)) + 2 : 1;
                        if (precisionXmax > VisualizeUtils.MAX_PRECISION) {
                            precisionXmax = 1;
                        }
                        String maxStringX = Utils.doubleToString(this.m_maxX, nondecimal + 1 + precisionXmax, precisionXmax);
                        whole = (int)Math.abs(this.m_minX);
                        decimal = Math.abs(this.m_minX) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n2 = precisionXmin = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minX)) / Math.log(10.0)) + 2 : 1;
                        if (precisionXmin > VisualizeUtils.MAX_PRECISION) {
                            precisionXmin = 1;
                        }
                        String minStringX = Utils.doubleToString(this.m_minX, nondecimal + 1 + precisionXmin, precisionXmin);
                        mswx = this.m_labelMetrics.stringWidth(maxStringX);
                        int precisionYmax = 1;
                        int precisionYmin = 1;
                        precisionYmid = 1;
                        whole = (int)Math.abs(this.m_maxY);
                        decimal = Math.abs(this.m_maxY) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n3 = precisionYmax = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxY)) / Math.log(10.0)) + 2 : 1;
                        if (precisionYmax > VisualizeUtils.MAX_PRECISION) {
                            precisionYmax = 1;
                        }
                        maxStringY = Utils.doubleToString(this.m_maxY, nondecimal + 1 + precisionYmax, precisionYmax);
                        whole = (int)Math.abs(this.m_minY);
                        decimal = Math.abs(this.m_minY) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n4 = precisionYmin = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minY)) / Math.log(10.0)) + 2 : 1;
                        if (precisionYmin > VisualizeUtils.MAX_PRECISION) {
                            precisionYmin = 1;
                        }
                        minStringY = Utils.doubleToString(this.m_minY, nondecimal + 1 + precisionYmin, precisionYmin);
                        if (this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) {
                            mswy = this.m_labelMetrics.stringWidth(maxStringY) > this.m_labelMetrics.stringWidth(minStringY) ? this.m_labelMetrics.stringWidth(maxStringY) : this.m_labelMetrics.stringWidth(minStringY);
                            mswy += this.m_labelMetrics.stringWidth("M");
                        } else {
                            mswy = this.m_labelMetrics.stringWidth("MM");
                        }
                        this.m_YaxisStart = 5;
                        this.m_XaxisStart = 10 + mswy;
                        this.m_XaxisEnd = w - 5 - mswx / 2;
                        this.m_YaxisEnd = h - 5 - 2 * hf - 5;
                        gx.setColor(this.m_axisColour);
                        if (!this.m_plotInstances.attribute(this.m_xIndex).isNumeric()) break block28;
                        if (w <= 2 * mswx) break block29;
                        gx.drawString(maxStringX, this.m_XaxisEnd - mswx / 2, this.m_YaxisEnd + hf + 5);
                        mswx = this.m_labelMetrics.stringWidth(minStringX);
                        gx.drawString(minStringX, this.m_XaxisStart - mswx / 2, this.m_YaxisEnd + hf + 5);
                        if (w <= 3 * mswx || !this.m_plotInstances.attribute(this.m_xIndex).isNumeric()) break block29;
                        mid = this.m_minX + (this.m_maxX - this.m_minX) / 2.0;
                        whole = (int)Math.abs(mid);
                        decimal = Math.abs(mid) - (double)whole;
                        nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                        int n5 = precisionXmid = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(mid)) / Math.log(10.0)) + 2 : 1;
                        if (precisionXmid > VisualizeUtils.MAX_PRECISION) {
                            precisionXmid = 1;
                        }
                        maxString = Utils.doubleToString(mid, nondecimal + 1 + precisionXmid, precisionXmid);
                        sw = this.m_labelMetrics.stringWidth(maxString);
                        mx = (double)this.m_XaxisStart + (double)(this.m_XaxisEnd - this.m_XaxisStart) / 2.0;
                        gx.drawString(maxString, (int)(mx - (double)sw / 2.0), this.m_YaxisEnd + hf + 5);
                        gx.drawLine((int)mx, this.m_YaxisEnd, (int)mx, this.m_YaxisEnd + 5);
                        break block29;
                    }
                    int numValues = this.m_plotInstances.attribute(this.m_xIndex).numValues();
                    int maxXStringWidth = (this.m_XaxisEnd - this.m_XaxisStart) / numValues;
                    for (int i = 0; i < numValues; ++i) {
                        String val = this.m_plotInstances.attribute(this.m_xIndex).value(i);
                        int sw2 = this.m_labelMetrics.stringWidth(val);
                        if (sw2 > maxXStringWidth) {
                            int incr = sw2 / val.length();
                            int rm = (sw2 - maxXStringWidth) / incr;
                            if (rm == 0) {
                                rm = 1;
                            }
                            val = val.substring(0, val.length() - rm);
                            sw2 = this.m_labelMetrics.stringWidth(val);
                        }
                        if (i == 0) {
                            gx.drawString(val, (int)this.convertToPanelX(i), this.m_YaxisEnd + hf + 5);
                        } else if (i == numValues - 1) {
                            if (i % 2 == 0) {
                                gx.drawString(val, this.m_XaxisEnd - sw2, this.m_YaxisEnd + hf + 5);
                            } else {
                                gx.drawString(val, this.m_XaxisEnd - sw2, this.m_YaxisEnd + 2 * hf + 5);
                            }
                        } else if (i % 2 == 0) {
                            gx.drawString(val, (int)this.convertToPanelX(i) - sw2 / 2, this.m_YaxisEnd + hf + 5);
                        } else {
                            gx.drawString(val, (int)this.convertToPanelX(i) - sw2 / 2, this.m_YaxisEnd + 2 * hf + 5);
                        }
                        gx.drawLine((int)this.convertToPanelX(i), this.m_YaxisEnd, (int)this.convertToPanelX(i), this.m_YaxisEnd + 5);
                    }
                }
                if (!this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) break block30;
                if (h <= 2 * hf) break block31;
                gx.drawString(maxStringY, this.m_XaxisStart - mswy - 5, this.m_YaxisStart + hf);
                gx.drawString(minStringY, this.m_XaxisStart - mswy - 5, this.m_YaxisEnd);
                if (w <= 3 * hf || !this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) break block31;
                mid = this.m_minY + (this.m_maxY - this.m_minY) / 2.0;
                whole = (int)Math.abs(mid);
                decimal = Math.abs(mid) - (double)whole;
                nondecimal = whole > 0 ? (int)(Math.log(whole) / Math.log(10.0)) : 1;
                int n = precisionYmid = decimal > 0.0 ? (int)Math.abs(Math.log(Math.abs(mid)) / Math.log(10.0)) + 2 : 1;
                if (precisionYmid > VisualizeUtils.MAX_PRECISION) {
                    precisionYmid = 1;
                }
                maxString = Utils.doubleToString(mid, nondecimal + 1 + precisionYmid, precisionYmid);
                sw = this.m_labelMetrics.stringWidth(maxString);
                mx = (double)this.m_YaxisStart + (double)(this.m_YaxisEnd - this.m_YaxisStart) / 2.0;
                gx.drawString(maxString, this.m_XaxisStart - sw - 5 - 1, (int)(mx + (double)hf / 2.0));
                gx.drawLine(this.m_XaxisStart - 5, (int)mx, this.m_XaxisStart, (int)mx);
                break block31;
            }
            int numValues = this.m_plotInstances.attribute(this.m_yIndex).numValues();
            int div = numValues % 2 == 0 ? numValues / 2 : numValues / 2 + 1;
            int maxYStringHeight = (this.m_YaxisEnd - this.m_XaxisStart) / div;
            sw = this.m_labelMetrics.stringWidth("M");
            for (int i = 0; i < numValues; ++i) {
                if (maxYStringHeight >= 2 * hf) {
                    String val = this.m_plotInstances.attribute(this.m_yIndex).value(i);
                    int numPrint = maxYStringHeight / hf > val.length() ? val.length() : maxYStringHeight / hf;
                    for (int j = 0; j < numPrint; ++j) {
                        String ll = val.substring(j, j + 1);
                        if (val.charAt(j) == '_' || val.charAt(j) == '-') {
                            ll = "|";
                        }
                        if (i == 0) {
                            gx.drawString(ll, this.m_XaxisStart - sw - 5 - 1, (int)this.convertToPanelY(i) - (numPrint - 1) * hf + j * hf + hf / 2);
                            continue;
                        }
                        if (i == numValues - 1) {
                            if (i % 2 == 0) {
                                gx.drawString(ll, this.m_XaxisStart - sw - 5 - 1, (int)this.convertToPanelY(i) + j * hf + hf / 2);
                                continue;
                            }
                            gx.drawString(ll, this.m_XaxisStart - 2 * sw - 5 - 1, (int)this.convertToPanelY(i) + j * hf + hf / 2);
                            continue;
                        }
                        if (i % 2 == 0) {
                            gx.drawString(ll, this.m_XaxisStart - sw - 5 - 1, (int)this.convertToPanelY(i) - (numPrint - 1) * hf / 2 + j * hf + hf / 2);
                            continue;
                        }
                        gx.drawString(ll, this.m_XaxisStart - 2 * sw - 5 - 1, (int)this.convertToPanelY(i) - (numPrint - 1) * hf / 2 + j * hf + hf / 2);
                    }
                }
                gx.drawLine(this.m_XaxisStart - 5, (int)this.convertToPanelY(i), this.m_XaxisStart, (int)this.convertToPanelY(i));
            }
        }
        gx.drawLine(this.m_XaxisStart, this.m_YaxisStart, this.m_XaxisStart, this.m_YaxisEnd);
        gx.drawLine(this.m_XaxisStart, this.m_YaxisEnd, this.m_XaxisEnd, this.m_YaxisEnd);
        if (this.m_XaxisStart != mxs || this.m_XaxisEnd != mxe || this.m_YaxisStart != mys || this.m_YaxisEnd != mye) {
            this.m_plotResize = true;
        }
    }

    private void extendColourMap(int highest) {
        for (int i = this.m_colorList.size(); i < highest; ++i) {
            Color pc = this.m_DefaultColors[i % 10];
            int ija = i / 10;
            ija *= 2;
            for (int j = 0; j < ija; ++j) {
                pc = pc.brighter();
            }
            this.m_colorList.add(pc);
        }
    }

    @Override
    public void paintComponent(Graphics gx) {
        super.paintComponent(gx);
        if (this.m_plotInstances != null && this.m_plotInstances.numInstances() > 0 && this.m_plotInstances.numAttributes() > 0) {
            if (this.m_plotCompanion != null) {
                this.m_plotCompanion.prePlot(gx);
            }
            this.m_JRand = new Random(this.m_JitterVal);
            this.paintAxis(gx);
            if (this.m_axisChanged || this.m_plotResize) {
                int x_range = this.m_XaxisEnd - this.m_XaxisStart;
                int y_range = this.m_YaxisEnd - this.m_YaxisStart;
                if (x_range < 10) {
                    x_range = 10;
                }
                if (y_range < 10) {
                    y_range = 10;
                }
                this.m_drawnPoints = new int[x_range + 1][y_range + 1];
                this.fillLookup();
                this.m_plotResize = false;
                this.m_axisChanged = false;
            }
            this.paintData(gx);
        }
    }

    protected static Color checkAgainstBackground(Color c, Color background) {
        if (background == null) {
            return c;
        }
        if (c.equals(background)) {
            int red = c.getRed();
            int blue = c.getBlue();
            int green = c.getGreen();
            c = new Color(red, green += green < 128 ? (255 - green) / 2 : -(green / 2), blue += blue < 128 ? (blue - (red += red < 128 ? (255 - red) / 2 : -(red / 2))) / 2 : -(blue / 2));
        }
        return c;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("Usage : weka.gui.visualize.Plot2D <dataset> [<dataset> <dataset>...]");
                System.exit(1);
            }
            final JFrame jf = new JFrame("Weka Explorer: Visualize");
            jf.setSize(500, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            final Plot2D p2 = new Plot2D();
            jf.getContentPane().add((Component)p2, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            p2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if ((e2.getModifiers() & 0x10) == 16) {
                        p2.searchPoints(e2.getX(), e2.getY(), false);
                    } else {
                        p2.searchPoints(e2.getX(), e2.getY(), true);
                    }
                }
            });
            jf.setVisible(true);
            if (args.length >= 1) {
                for (int j = 0; j < args.length; ++j) {
                    System.err.println("Loading instances from " + args[j]);
                    BufferedReader r = new BufferedReader(new FileReader(args[j]));
                    Instances i = new Instances(r);
                    i.setClassIndex(i.numAttributes() - 1);
                    PlotData2D pd1 = new PlotData2D(i);
                    if (j == 0) {
                        pd1.setPlotName("Master plot");
                        p2.setMasterPlot(pd1);
                        p2.setXindex(2);
                        p2.setYindex(3);
                        p2.setCindex(i.classIndex());
                        continue;
                    }
                    pd1.setPlotName("Plot " + (j + 1));
                    pd1.m_useCustomColour = true;
                    pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                    p2.addPlot(pd1);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

