/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;

public class InstanceLoader
extends JPanel
implements ActionListener,
InstanceProducer {
    private static final long serialVersionUID = -8725567310271862492L;
    private final Vector<InstanceListener> m_Listeners;
    private Thread m_LoaderThread;
    private Instance m_OutputInstance;
    private Instances m_OutputInstances;
    private boolean m_Debug;
    private final JButton m_StartBut;
    private final JTextField m_FileNameTex;

    public InstanceLoader() {
        this.setLayout(new BorderLayout());
        this.m_StartBut = new JButton("Start");
        this.m_StartBut.setBackground(Color.green);
        this.add("West", this.m_StartBut);
        this.m_StartBut.addActionListener(this);
        this.m_FileNameTex = new JTextField("/home/trigg/datasets/UCI/iris.arff");
        this.add("Center", this.m_FileNameTex);
        this.m_Listeners = new Vector();
    }

    public void setDebug(boolean debug2) {
        this.m_Debug = debug2;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setArffFile(String newArffFile) {
        this.m_FileNameTex.setText(newArffFile);
    }

    public String getArffFile() {
        return this.m_FileNameTex.getText();
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener ipl) {
        this.m_Listeners.addElement(ipl);
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener ipl) {
        this.m_Listeners.removeElement(ipl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceProduced(InstanceEvent e2) {
        Vector l;
        if (this.m_Debug) {
            System.err.println("InstanceLoader::notifyInstanceProduced()");
        }
        InstanceLoader instanceLoader = this;
        synchronized (instanceLoader) {
            l = (Vector)this.m_Listeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((InstanceListener)l.elementAt(i)).instanceProduced(e2);
            }
            if (e2.getID() == 2) {
                this.m_OutputInstance = null;
            }
        }
    }

    @Override
    public Instances outputFormat() throws Exception {
        if (this.m_OutputInstances == null) {
            throw new Exception("No output format defined.");
        }
        return new Instances(this.m_OutputInstances, 0);
    }

    @Override
    public Instance outputPeek() throws Exception {
        if (this.m_OutputInstances == null || this.m_OutputInstance == null) {
            return null;
        }
        return (Instance)this.m_OutputInstance.copy();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Object source = e2.getSource();
        if (source == this.m_StartBut) {
            if (this.m_LoaderThread == null) {
                this.m_LoaderThread = new LoadThread(this);
                this.m_LoaderThread.setPriority(1);
                this.m_LoaderThread.start();
            } else {
                this.m_LoaderThread = null;
            }
        }
    }

    private class LoadThread
    extends Thread {
        private final InstanceProducer m_IP;

        public LoadThread(InstanceProducer ip) {
            this.m_IP = ip;
        }

        @Override
        public void run() {
            try {
                InstanceLoader.this.m_StartBut.setText("Stop");
                InstanceLoader.this.m_StartBut.setBackground(Color.red);
                if (InstanceLoader.this.m_Debug) {
                    System.err.println("InstanceLoader::LoadThread::run()");
                }
                BufferedReader input = new BufferedReader(new FileReader(InstanceLoader.this.m_FileNameTex.getText()));
                InstanceLoader.this.m_OutputInstances = new Instances(input, 1);
                if (InstanceLoader.this.m_Debug) {
                    System.err.println("InstanceLoader::LoadThread::run() - Instances opened from: " + InstanceLoader.this.m_FileNameTex.getText());
                }
                InstanceEvent ie = new InstanceEvent(this.m_IP, 1);
                InstanceLoader.this.notifyInstanceProduced(ie);
                while (InstanceLoader.this.m_OutputInstances.readInstance(input)) {
                    if (InstanceLoader.this.m_LoaderThread != this) {
                        return;
                    }
                    if (InstanceLoader.this.m_Debug) {
                        System.err.println("InstanceLoader::LoadThread::run() - read instance");
                    }
                    InstanceLoader.this.m_OutputInstance = InstanceLoader.this.m_OutputInstances.instance(0);
                    InstanceLoader.this.m_OutputInstances.delete(0);
                    ie = new InstanceEvent(this.m_IP, 2);
                    InstanceLoader.this.notifyInstanceProduced(ie);
                }
                ie = new InstanceEvent(this.m_IP, 3);
                InstanceLoader.this.notifyInstanceProduced(ie);
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
            finally {
                InstanceLoader.this.m_LoaderThread = null;
                InstanceLoader.this.m_StartBut.setText("Start");
                InstanceLoader.this.m_StartBut.setBackground(Color.green);
            }
        }
    }
}

