/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.PluginManager;
import weka.gui.EnvironmentField;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.OffscreenChartRenderer;
import weka.gui.beans.WekaOffscreenChartRenderer;
import weka.gui.knowledgeflow.GOEStepEditorDialog;
import weka.knowledgeflow.steps.ModelPerformanceChart;
import weka.knowledgeflow.steps.Step;

public class ModelPerformanceChartStepEditorDialog
extends GOEStepEditorDialog {
    private static final long serialVersionUID = -3031265139980301695L;
    protected EnvironmentField m_rendererOptions = new EnvironmentField();
    protected JComboBox<String> m_offscreenSelector = new JComboBox();
    protected String m_currentRendererName;
    protected String m_currentRendererOptions;

    @Override
    protected void setStepToEdit(Step step) {
        this.copyOriginal(step);
        this.createAboutPanel(step);
        this.m_editor = new PropertySheetPanel(false);
        this.m_editor.setUseEnvironmentPropertyEditors(true);
        this.m_editor.setEnvironment(this.m_env);
        this.m_editor.setTarget(this.m_stepToEdit);
        this.m_primaryEditorHolder.setLayout(new BorderLayout());
        this.m_primaryEditorHolder.add((Component)this.m_editor, "Center");
        GridBagLayout gbLayout = new GridBagLayout();
        JPanel p = new JPanel(gbLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        JLabel renderLabel = new JLabel("Renderer", 4);
        gbLayout.setConstraints(renderLabel, gbc);
        p.add(renderLabel);
        JPanel newPanel = new JPanel(new BorderLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.weightx = 100.0;
        newPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
        newPanel.add(this.m_offscreenSelector, "Center");
        gbLayout.setConstraints(newPanel, gbc);
        p.add(newPanel);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        final JLabel rendererOptsLabel = new JLabel("Renderer options", 4);
        gbLayout.setConstraints(rendererOptsLabel, gbc);
        p.add(rendererOptsLabel);
        newPanel = new JPanel(new BorderLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridy = 1;
        gbc.gridx = 1;
        gbc.weightx = 100.0;
        newPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
        newPanel.add((Component)this.m_rendererOptions, "Center");
        gbLayout.setConstraints(newPanel, gbc);
        p.add(newPanel);
        this.m_primaryEditorHolder.add((Component)p, "North");
        this.m_editorHolder.add((Component)this.m_primaryEditorHolder, "North");
        this.add((Component)this.m_editorHolder, "Center");
        this.m_offscreenSelector.addItem("Weka Chart Renderer");
        Set<String> pluginRenderers = PluginManager.getPluginNamesOfType("weka.gui.beans.OffscreenChartRenderer");
        if (pluginRenderers != null) {
            for (String plugin : pluginRenderers) {
                this.m_offscreenSelector.addItem(plugin);
            }
        }
        this.m_offscreenSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ModelPerformanceChartStepEditorDialog.this.setupRendererOptsTipText(rendererOptsLabel);
            }
        });
        this.getCurrentSettings();
        this.m_offscreenSelector.setSelectedItem(this.m_currentRendererName);
        this.m_rendererOptions.setText(this.m_currentRendererOptions);
        this.setupRendererOptsTipText(rendererOptsLabel);
    }

    protected void getCurrentSettings() {
        this.m_currentRendererName = ((ModelPerformanceChart)this.getStepToEdit()).getOffscreenRendererName();
        this.m_currentRendererOptions = ((ModelPerformanceChart)this.getStepToEdit()).getOffscreenAdditionalOpts();
    }

    private void setupRendererOptsTipText(JLabel optsLab) {
        String renderer = this.m_offscreenSelector.getSelectedItem().toString();
        if (renderer.equalsIgnoreCase("weka chart renderer")) {
            WekaOffscreenChartRenderer rcr = new WekaOffscreenChartRenderer();
            String tipText = rcr.optionsTipTextHTML();
            tipText = tipText.replace("<html>", "<html>Comma separated list of options:<br>");
            optsLab.setToolTipText(tipText);
        } else {
            try {
                String tipText;
                Object rendererO = PluginManager.getPluginInstance("weka.gui.beans.OffscreenChartRenderer", renderer);
                if (rendererO != null && (tipText = ((OffscreenChartRenderer)rendererO).optionsTipTextHTML()) != null && tipText.length() > 0) {
                    optsLab.setToolTipText(tipText);
                }
            }
            catch (Exception ex) {
                this.showErrorDialog(ex);
            }
        }
    }

    @Override
    protected void okPressed() {
        ((ModelPerformanceChart)this.getStepToEdit()).setOffscreenRendererName(this.m_offscreenSelector.getSelectedItem().toString());
        ((ModelPerformanceChart)this.getStepToEdit()).setOffscreenAdditionalOpts(this.m_rendererOptions.getText());
    }
}

