/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import weka.core.Defaults;
import weka.core.converters.DatabaseLoader;
import weka.gui.AbstractPerspective;
import weka.gui.GUIApplication;
import weka.gui.PerspectiveInfo;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.gui.sql.SqlViewer;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.Loader;

@PerspectiveInfo(ID="sqlviewer", title="SQL Viewer", toolTipText="Explore database tables with SQL", iconPath="weka/gui/knowledgeflow/icons/database.png")
public class SQLViewerPerspective
extends AbstractPerspective {
    private static final long serialVersionUID = -4771310190331379801L;
    protected SqlViewer m_viewer;
    protected JButton m_newFlowBut;
    protected MainKFPerspective m_mainKFPerspective;
    protected JPanel m_buttonHolder;

    public SQLViewerPerspective() {
        this.setLayout(new BorderLayout());
        this.m_viewer = new SqlViewer(null);
        this.add((Component)this.m_viewer, "Center");
        this.m_newFlowBut = new JButton("New Flow");
        this.m_newFlowBut.setToolTipText("Set up a new Knowledge Flow with the current connection and query");
        this.m_buttonHolder = new JPanel();
        this.m_buttonHolder.add(this.m_newFlowBut);
        this.add((Component)this.m_buttonHolder, "South");
        this.m_newFlowBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (SQLViewerPerspective.this.m_mainKFPerspective != null) {
                    SQLViewerPerspective.this.newFlow();
                }
            }
        });
        this.m_newFlowBut.setEnabled(false);
        this.m_viewer.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionChange(ConnectionEvent evt) {
                if (evt.getType() == 1) {
                    SQLViewerPerspective.this.m_newFlowBut.setEnabled(false);
                } else {
                    SQLViewerPerspective.this.m_newFlowBut.setEnabled(true);
                }
            }
        });
    }

    @Override
    public void setMainApplication(GUIApplication application) {
        super.setMainApplication(application);
        this.m_mainKFPerspective = (MainKFPerspective)this.m_mainApplication.getPerspectiveManager().getPerspective("knowledgeflow");
        if (this.m_mainKFPerspective == null) {
            this.remove(this.m_buttonHolder);
        }
    }

    protected void newFlow() {
        this.m_newFlowBut.setEnabled(false);
        String user = this.m_viewer.getUser();
        String password = this.m_viewer.getPassword();
        String uRL = this.m_viewer.getURL();
        String query = this.m_viewer.getQuery();
        if (query == null) {
            query = "";
        }
        try {
            DatabaseLoader dbl = new DatabaseLoader();
            dbl.setUser(user);
            dbl.setPassword(password);
            dbl.setUrl(uRL);
            dbl.setQuery(query);
            Loader loaderStep = new Loader();
            loaderStep.setLoader(dbl);
            StepManagerImpl manager = new StepManagerImpl(loaderStep);
            this.m_mainKFPerspective.addTab("DBSource");
            this.m_mainKFPerspective.getCurrentLayout().addStep(manager, 50, 50);
            this.m_mainApplication.getPerspectiveManager().setActivePerspective("knowledgeflow");
            this.m_newFlowBut.setEnabled(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_mainApplication.showErrorDialog(ex);
        }
    }

    protected static class SQLDefaults
    extends Defaults {
        public static final String ID = "sqlviewer";
        private static final long serialVersionUID = 5907476861935295960L;

        public SQLDefaults() {
            super(ID);
        }
    }
}

