/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.core.Attribute;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.Settings;
import weka.gui.AbstractPerspective;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.PerspectiveInfo;

@PerspectiveInfo(ID="attributesummary", title="Attribute summary", toolTipText="Histogram summary charts", iconPath="weka/gui/knowledgeflow/icons/chart_bar.png")
public class AttributeSummaryPerspective
extends AbstractPerspective {
    private static final long serialVersionUID = 6697308901346612850L;
    protected Instances m_visualizeDataSet;
    protected transient List<AttributeVisualizationPanel> m_plots;
    protected int m_coloringIndex = -1;

    public AttributeSummaryPerspective() {
        this.setLayout(new BorderLayout());
    }

    protected void setup(Settings settings) {
        this.removeAll();
        if (this.m_visualizeDataSet == null) {
            return;
        }
        JScrollPane hp = this.makePanel(settings == null ? this.m_mainApplication.getApplicationSettings() : settings);
        this.add((Component)hp, "Center");
        Vector<String> atts = new Vector<String>();
        for (int i = 0; i < this.m_visualizeDataSet.numAttributes(); ++i) {
            atts.add("(" + Attribute.typeToStringShort(this.m_visualizeDataSet.attribute(i)) + ") " + this.m_visualizeDataSet.attribute(i).name());
        }
        final JComboBox classCombo = new JComboBox();
        classCombo.setModel(new DefaultComboBoxModel(atts));
        if (atts.size() > 0) {
            if (this.m_visualizeDataSet.classIndex() < 0) {
                classCombo.setSelectedIndex(atts.size() - 1);
            } else {
                classCombo.setSelectedIndex(this.m_visualizeDataSet.classIndex());
            }
            classCombo.setEnabled(true);
            for (int i = 0; i < this.m_plots.size(); ++i) {
                this.m_plots.get(i).setColoringIndex(classCombo.getSelectedIndex());
            }
        }
        JPanel comboHolder = new JPanel();
        comboHolder.setLayout(new BorderLayout());
        JPanel tempHolder = new JPanel();
        tempHolder.setLayout(new BorderLayout());
        tempHolder.add((Component)new JLabel("Class: "), "West");
        tempHolder.add(classCombo, "East");
        comboHolder.add((Component)tempHolder, "West");
        this.add((Component)comboHolder, "North");
        classCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selected = classCombo.getSelectedIndex();
                if (selected >= 0) {
                    for (int i = 0; i < AttributeSummaryPerspective.this.m_plots.size(); ++i) {
                        AttributeSummaryPerspective.this.m_plots.get(i).setColoringIndex(selected);
                    }
                }
            }
        });
    }

    private JScrollPane makePanel(Settings settings) {
        String fontFamily = this.getFont().getFamily();
        Font newFont = new Font(fontFamily, 0, 10);
        JPanel hp = new JPanel();
        hp.setFont(newFont);
        int gridWidth = settings.getSetting("attributesummary", AttDefaults.GRID_WIDTH_KEY, Integer.valueOf(4), Environment.getSystemWide());
        int maxPlots = settings.getSetting("attributesummary", AttDefaults.MAX_PLOTS_KEY, Integer.valueOf(100), Environment.getSystemWide());
        int numPlots = Math.min(this.m_visualizeDataSet.numAttributes(), maxPlots);
        int gridHeight = numPlots / gridWidth;
        if (numPlots % gridWidth != 0) {
            ++gridHeight;
        }
        hp.setLayout(new GridLayout(gridHeight, 4));
        this.m_plots = new ArrayList<AttributeVisualizationPanel>();
        for (int i = 0; i < numPlots; ++i) {
            JPanel temp = new JPanel();
            temp.setLayout(new BorderLayout());
            temp.setBorder(BorderFactory.createTitledBorder(this.m_visualizeDataSet.attribute(i).name()));
            AttributeVisualizationPanel ap = new AttributeVisualizationPanel();
            this.m_plots.add(ap);
            ap.setInstances(this.m_visualizeDataSet);
            if (this.m_coloringIndex < 0 && this.m_visualizeDataSet.classIndex() >= 0) {
                ap.setColoringIndex(this.m_visualizeDataSet.classIndex());
            } else {
                ap.setColoringIndex(this.m_coloringIndex);
            }
            temp.add((Component)ap, "Center");
            ap.setAttribute(i);
            hp.add(temp);
        }
        Dimension d = new Dimension(830, gridHeight * 100);
        hp.setMinimumSize(d);
        hp.setMaximumSize(d);
        hp.setPreferredSize(d);
        JScrollPane scroller = new JScrollPane(hp);
        return scroller;
    }

    @Override
    public Defaults getDefaultSettings() {
        return new AttDefaults();
    }

    @Override
    public void setInstances(Instances instances) {
        this.m_visualizeDataSet = instances;
        this.setup(null);
    }

    public void setInstances(Instances instances, Settings settings) {
        this.m_visualizeDataSet = instances;
        this.setup(settings);
    }

    @Override
    public boolean okToBeActive() {
        return this.m_visualizeDataSet != null;
    }

    @Override
    public boolean acceptsInstances() {
        return true;
    }

    public static class AttDefaults
    extends Defaults {
        public static final String ID = "attributesummary";
        protected static final Settings.SettingKey GRID_WIDTH_KEY = new Settings.SettingKey("weka.knowledgeflow.attributesummary.gridWidth", "Number of plots to display horizontally", "");
        protected static final int GRID_WIDTH = 4;
        protected static final Settings.SettingKey MAX_PLOTS_KEY = new Settings.SettingKey("weka.knowledgeflow.attributesummary.maxPlots", "Maximum number of plots to render", "");
        protected static final int MAX_PLOTS = 100;
        private static final long serialVersionUID = -32801466385262321L;

        public AttDefaults() {
            super(ID);
            this.m_defaults.put(GRID_WIDTH_KEY, 4);
            this.m_defaults.put(MAX_PLOTS_KEY, 100);
        }
    }
}

