/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import weka.core.Defaults;
import weka.core.Instances;
import weka.core.Settings;
import weka.gui.AbstractPerspective;
import weka.gui.PerspectiveInfo;
import weka.gui.explorer.Explorer;
import weka.gui.visualize.MatrixPanel;
import weka.gui.visualize.VisualizeUtils;

@PerspectiveInfo(ID="weka.gui.workbench.visualizepanel", title="Visualize", toolTipText="Explore the data", iconPath="weka/gui/weka_icon_new_small.png")
public class VisualizePanel
extends AbstractPerspective
implements Explorer.ExplorerPanel {
    private static final long serialVersionUID = 6084015036853918846L;
    protected Explorer m_Explorer = null;
    protected MatrixPanel m_matrixPanel = new MatrixPanel();
    protected boolean m_hasInstancesSet;

    public VisualizePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_matrixPanel, "Center");
    }

    @Override
    public void setInstances(Instances instances) {
        this.m_matrixPanel.setInstances(instances);
        this.m_hasInstancesSet = true;
    }

    @Override
    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    @Override
    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    @Override
    public String getTabTitle() {
        return "Visualize";
    }

    @Override
    public String getTabTitleToolTip() {
        return "Explore the data";
    }

    @Override
    public boolean acceptsInstances() {
        return true;
    }

    @Override
    public Defaults getDefaultSettings() {
        ScatterDefaults d = new ScatterDefaults();
        d.add(new VisualizeUtils.VisualizeDefaults());
        return d;
    }

    @Override
    public boolean okToBeActive() {
        return this.m_hasInstancesSet;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.m_isActive) {
            this.settingsChanged();
        }
    }

    @Override
    public void settingsChanged() {
        if (this.getMainApplication() != null) {
            this.m_matrixPanel.applySettings(this.m_mainApplication.getApplicationSettings(), "weka.gui.workbench.visualizepanel");
            if (this.m_isActive) {
                this.m_matrixPanel.updatePanel();
            }
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Visualize");
            jf.getContentPane().setLayout(new BorderLayout());
            VisualizePanel sp = new VisualizePanel();
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static class ScatterDefaults
    extends Defaults {
        public static final String ID = "weka.gui.workbench.visualizepanel";
        public static final Settings.SettingKey POINT_SIZE_KEY = new Settings.SettingKey("weka.gui.workbench.visualizepanel.pointSize", "Point size for scatter plots", "");
        public static final int POINT_SIZE = 1;
        public static final Settings.SettingKey PLOT_SIZE_KEY = new Settings.SettingKey("weka.gui.workbench.visualizepanel.plotSize", "Size (in pixels) of the cells in the matrix", "");
        public static final int PLOT_SIZE = 100;
        public static final long serialVersionUID = -6890761195767034507L;

        public ScatterDefaults() {
            super(ID);
            this.m_defaults.put(POINT_SIZE_KEY, 1);
            this.m_defaults.put(PLOT_SIZE_KEY, 100);
        }
    }
}

