/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import weka.core.Capabilities;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.PluginManager;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.logging.Logger;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.LookAndFeel;
import weka.gui.WekaTaskMonitor;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.PreprocessPanel;

public class Explorer
extends JPanel {
    private static final long serialVersionUID = -7674003708867909578L;
    protected PreprocessPanel m_PreprocessPanel = new PreprocessPanel();
    protected Vector<ExplorerPanel> m_Panels = new Vector();
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected LogPanel m_LogPanel = new LogPanel(new WekaTaskMonitor());
    protected HashSet<CapabilitiesFilterChangeListener> m_CapabilitiesFilterChangeListeners = new HashSet();
    private static Explorer m_explorer;
    protected static Memory m_Memory;

    public Explorer() {
        int i;
        String date2 = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        this.m_LogPanel.logMessage("Weka Explorer");
        this.m_LogPanel.logMessage("(c) " + Copyright.getFromYear() + "-" + Copyright.getToYear() + " " + Copyright.getOwner() + ", " + Copyright.getAddress());
        this.m_LogPanel.logMessage("web: " + Copyright.getURL());
        this.m_LogPanel.logMessage("Started on " + date2);
        this.m_LogPanel.statusMessage("Welcome to the Weka Explorer");
        this.m_PreprocessPanel.setLog(this.m_LogPanel);
        this.m_TabbedPane.addTab(this.m_PreprocessPanel.getTabTitle(), null, this.m_PreprocessPanel, this.m_PreprocessPanel.getTabTitleToolTip());
        String[] tabs = ExplorerDefaults.getTabs();
        Hashtable tabOptions = new Hashtable();
        for (String tab : tabs) {
            try {
                String[] optionsStr = tab.split(":");
                String classname = optionsStr[0];
                if (PluginManager.isInDisabledList(classname)) continue;
                HashSet<String> options = new HashSet<String>();
                tabOptions.put(classname, options);
                for (int n = 1; n < optionsStr.length; ++n) {
                    options.add(optionsStr[n]);
                }
                ExplorerPanel panel = (ExplorerPanel)WekaPackageClassLoaderManager.forName(classname).newInstance();
                panel.setExplorer(this);
                this.m_Panels.add(panel);
                if (panel instanceof LogHandler) {
                    ((LogHandler)((Object)panel)).setLog(this.m_LogPanel);
                }
                this.m_TabbedPane.addTab(panel.getTabTitle(), null, (JPanel)((Object)panel), panel.getTabTitleToolTip());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.m_TabbedPane.setSelectedIndex(0);
        for (i = 0; i < this.m_Panels.size(); ++i) {
            HashSet options = (HashSet)tabOptions.get(this.m_Panels.get(i).getClass().getName());
            this.m_TabbedPane.setEnabledAt(i + 1, options.contains("standalone"));
        }
        this.m_PreprocessPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                for (int i = 0; i < Explorer.this.m_Panels.size(); ++i) {
                    Explorer.this.m_Panels.get(i).setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                    Explorer.this.m_TabbedPane.setEnabledAt(i + 1, true);
                }
            }
        });
        this.m_PreprocessPanel.setExplorer(this);
        this.addCapabilitiesFilterListener(this.m_PreprocessPanel);
        for (i = 0; i < this.m_Panels.size(); ++i) {
            if (!(this.m_Panels.get(i) instanceof CapabilitiesFilterChangeListener)) continue;
            this.addCapabilitiesFilterListener((CapabilitiesFilterChangeListener)((Object)this.m_Panels.get(i)));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
        this.add((Component)this.m_LogPanel, "South");
    }

    public void terminate() {
        this.m_LogPanel.terminate();
    }

    public Vector<ExplorerPanel> getPanels() {
        return this.m_Panels;
    }

    public PreprocessPanel getPreprocessPanel() {
        return this.m_PreprocessPanel;
    }

    public JTabbedPane getTabbedPane() {
        return this.m_TabbedPane;
    }

    public void addCapabilitiesFilterListener(CapabilitiesFilterChangeListener l) {
        this.m_CapabilitiesFilterChangeListeners.add(l);
    }

    public boolean removeCapabilitiesFilterListener(CapabilitiesFilterChangeListener l) {
        return this.m_CapabilitiesFilterChangeListeners.remove(l);
    }

    public void notifyCapabilitiesFilterListener(Capabilities filter) {
        for (CapabilitiesFilterChangeListener l : this.m_CapabilitiesFilterChangeListeners) {
            if (l == this) continue;
            l.capabilitiesFilterChanged(new CapabilitiesFilterChangeEvent(this, filter));
        }
    }

    public static void main(String[] args) {
        weka.core.logging.Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        GenericObjectEditor.determineClasses();
        try {
            m_explorer = new Explorer();
            final JFrame jf = new JFrame("Weka Explorer");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)m_explorer, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            Image icon = Toolkit.getDefaultToolkit().getImage(m_explorer.getClass().getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
            jf.setIconImage(icon);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                AbstractFileLoader loader = ConverterUtils.getLoaderForFile(args[0]);
                loader.setFile(new File(args[0]));
                Explorer.m_explorer.m_PreprocessPanel.setInstancesFromFile(loader);
            }
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        jf.dispose();
                        m_explorer = null;
                        System.gc();
                        System.err.println("\ndisplayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting");
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }

    public static interface LogHandler {
        public void setLog(Logger var1);
    }

    public static interface ExplorerPanel {
        public void setExplorer(Explorer var1);

        public Explorer getExplorer();

        public void setInstances(Instances var1);

        public String getTabTitle();

        public String getTabTitleToolTip();
    }

    public static class CapabilitiesFilterChangeEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1194260517270385559L;
        protected Capabilities m_Filter;

        public CapabilitiesFilterChangeEvent(Object source, Capabilities filter) {
            super(source);
            this.m_Filter = filter;
        }

        public Capabilities getFilter() {
            return this.m_Filter;
        }
    }

    public static interface CapabilitiesFilterChangeListener
    extends EventListener {
        public void capabilitiesFilterChanged(CapabilitiesFilterChangeEvent var1);
    }
}

