/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.FileEnvironmentField;
import weka.gui.beans.TextSaver;

public class TextSaverCustomizer
extends JPanel
implements BeanCustomizer,
EnvironmentHandler,
CustomizerClosingListener,
CustomizerCloseRequester {
    private static final long serialVersionUID = -1012433373647714743L;
    private TextSaver m_textSaver;
    private FileEnvironmentField m_fileEditor;
    private final JCheckBox m_append = new JCheckBox("Append to file");
    private Environment m_env = Environment.getSystemWide();
    private BeanCustomizer.ModifyListener m_modifyListener;
    private Window m_parent;
    private String m_fileBackup;

    public TextSaverCustomizer() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setObject(Object object) {
        this.m_textSaver = (TextSaver)object;
        this.m_fileBackup = this.m_textSaver.getFilename();
        this.m_append.setSelected(this.m_textSaver.getAppend());
        this.setup();
    }

    private void setup() {
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        this.m_fileEditor = new FileEnvironmentField("Filename", this.m_env, 1);
        this.m_fileEditor.resetFileFilters();
        JPanel temp = new JPanel();
        temp.setLayout(new GridLayout(2, 0));
        temp.add(this.m_fileEditor);
        temp.add(this.m_append);
        holder.add((Component)temp, "South");
        String globalInfo = this.m_textSaver.globalInfo();
        JTextArea jt = new JTextArea();
        jt.setColumns(30);
        jt.setFont(new Font("SansSerif", 0, 12));
        jt.setEditable(false);
        jt.setLineWrap(true);
        jt.setWrapStyleWord(true);
        jt.setText(globalInfo);
        jt.setBackground(this.getBackground());
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("About"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jp.setLayout(new BorderLayout());
        jp.add((Component)jt, "Center");
        holder.add((Component)jp, "North");
        this.add((Component)holder, "Center");
        this.addButtons();
        this.m_fileEditor.setText(this.m_textSaver.getFilename());
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TextSaverCustomizer.this.m_textSaver.setFilename(TextSaverCustomizer.this.m_fileEditor.getText());
                TextSaverCustomizer.this.m_textSaver.setAppend(TextSaverCustomizer.this.m_append.isSelected());
                if (TextSaverCustomizer.this.m_modifyListener != null) {
                    TextSaverCustomizer.this.m_modifyListener.setModifiedStatus(TextSaverCustomizer.this, true);
                }
                if (TextSaverCustomizer.this.m_parent != null) {
                    TextSaverCustomizer.this.m_parent.dispose();
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TextSaverCustomizer.this.customizerClosing();
                if (TextSaverCustomizer.this.m_parent != null) {
                    TextSaverCustomizer.this.m_parent.dispose();
                }
            }
        });
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    @Override
    public void customizerClosing() {
        this.m_textSaver.setFilename(this.m_fileBackup);
    }
}

