/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import weka.gui.Logger;

public class StreamThroughput
implements Serializable {
    private static final long serialVersionUID = 2820675210555581676L;
    protected transient int m_avInstsPerSec = 0;
    protected transient double m_startTime = System.currentTimeMillis();
    protected transient int m_instanceCount = 0;
    protected transient int m_sampleCount = 0;
    protected transient String m_statusMessagePrefix = "";
    protected transient int m_sampleTime = 2000;
    protected transient double m_cumulativeTime = 0.0;
    protected transient int m_numSamples = 0;
    protected transient double m_updateStart;

    public StreamThroughput(String statusMessagePrefix) {
        this.m_statusMessagePrefix = statusMessagePrefix;
    }

    public StreamThroughput(String statusMessagePrefix, String initialMessage, Logger log2) {
        this(statusMessagePrefix);
        if (log2 != null) {
            log2.statusMessage(this.m_statusMessagePrefix + initialMessage);
        }
    }

    public void setSamplePeriod(int period) {
        this.m_sampleTime = period;
    }

    public void updateStart() {
        this.m_updateStart = System.currentTimeMillis();
    }

    public void updateEnd(Logger log2) {
        ++this.m_instanceCount;
        ++this.m_sampleCount;
        double end = System.currentTimeMillis();
        double temp = end - this.m_updateStart;
        this.m_cumulativeTime += temp;
        boolean toFastToMeasure = false;
        if (end - this.m_startTime >= (double)this.m_sampleTime) {
            this.computeUpdate(end);
            if (log2 != null) {
                log2.statusMessage(this.m_statusMessagePrefix + "Processed " + this.m_instanceCount + " insts @ " + this.m_avInstsPerSec / this.m_numSamples + " insts/sec" + (toFastToMeasure ? "*" : ""));
            }
            this.m_sampleCount = 0;
            this.m_cumulativeTime = 0.0;
            this.m_startTime = System.currentTimeMillis();
        }
    }

    protected boolean computeUpdate(double end) {
        boolean toFastToMeasure = false;
        int instsPerSec = 0;
        if (this.m_cumulativeTime == 0.0) {
            double sampleTime = end - this.m_startTime;
            instsPerSec = (int)((double)this.m_sampleCount / (sampleTime / 1000.0));
            toFastToMeasure = true;
        } else {
            instsPerSec = (int)((double)this.m_sampleCount / (this.m_cumulativeTime / 1000.0));
        }
        ++this.m_numSamples;
        this.m_avInstsPerSec += instsPerSec;
        return toFastToMeasure;
    }

    public int getAverageInstancesPerSecond() {
        int nS = this.m_numSamples > 0 ? this.m_numSamples : 1;
        return this.m_avInstsPerSec / nS;
    }

    public String finished(Logger log2) {
        if (this.m_avInstsPerSec == 0) {
            this.computeUpdate(System.currentTimeMillis());
        }
        int nS = this.m_numSamples > 0 ? this.m_numSamples : 1;
        String msg = "Finished - " + this.m_instanceCount + " insts @ " + this.m_avInstsPerSec / nS + " insts/sec";
        if (log2 != null) {
            log2.statusMessage(this.m_statusMessagePrefix + msg);
        }
        return msg;
    }

    public String finished() {
        if (this.m_avInstsPerSec == 0) {
            this.computeUpdate(System.currentTimeMillis());
        }
        int nS = this.m_numSamples > 0 ? this.m_numSamples : 1;
        String msg = "Finished - " + this.m_instanceCount + " insts @ " + this.m_avInstsPerSec / nS + " insts/sec";
        return msg;
    }
}

