/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.Note;

public class NoteCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerCloseRequester,
CustomizerClosingListener {
    private static final long serialVersionUID = 995648616684953391L;
    protected Window m_parentWindow;
    protected Note m_note;
    protected JTextArea m_textArea = new JTextArea(5, 20);
    private BeanCustomizer.ModifyListener m_modifyListener;

    public NoteCustomizer() {
        this.setLayout(new BorderLayout());
        this.m_textArea.setLineWrap(true);
        JScrollPane sc = new JScrollPane(this.m_textArea);
        this.add((Component)sc, "Center");
        JButton okBut = new JButton("OK");
        this.add((Component)okBut, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                NoteCustomizer.this.customizerClosing();
                if (NoteCustomizer.this.m_parentWindow != null) {
                    NoteCustomizer.this.m_parentWindow.dispose();
                }
            }
        });
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
    }

    @Override
    public void setObject(Object ob) {
        this.m_note = (Note)ob;
        this.m_textArea.setText(this.m_note.getNoteText());
        this.m_textArea.selectAll();
    }

    @Override
    public void customizerClosing() {
        if (this.m_note != null) {
            this.m_note.setNoteText(this.m_textArea.getText());
            if (this.m_modifyListener != null) {
                this.m_modifyListener.setModifiedStatus(this, true);
            }
        }
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }
}

