/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import weka.associations.Apriori;
import weka.associations.AssociationRules;
import weka.associations.AssociationRulesProducer;
import weka.core.Attribute;
import weka.core.Drawable;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.BatchAssociationRulesEvent;
import weka.gui.beans.BatchAssociationRulesListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ConfigurationListener;
import weka.gui.beans.ConfigurationProducer;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Associator
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
Serializable,
UserRequestAcceptor,
DataSourceListener,
TrainingSetListener,
ConfigurationProducer,
StructureProducer,
EnvironmentHandler {
    private static final long serialVersionUID = -7843500322130210057L;
    protected BeanVisual m_visual = new BeanVisual("Associator", "weka/gui/beans/icons/DefaultAssociator.gif", "weka/gui/beans/icons/DefaultAssociator_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private int m_state = IDLE;
    private Thread m_buildThread = null;
    protected String m_globalInfo;
    private final Hashtable<String, Object> m_listenees = new Hashtable();
    private final Vector<EventListener> m_textListeners = new Vector();
    private final Vector<EventListener> m_graphListeners = new Vector();
    private final Vector<BatchAssociationRulesListener> m_rulesListeners = new Vector();
    private weka.associations.Associator m_Associator = new Apriori();
    private transient Logger m_log = null;
    private transient Environment m_env = null;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Associator() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setAssociator(this.m_Associator);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setAssociator(weka.associations.Associator c) {
        boolean loadImages = true;
        if (c.getClass().getName().compareTo(this.m_Associator.getClass().getName()) == 0) {
            loadImages = false;
        }
        this.m_Associator = c;
        String associatorName = c.getClass().toString();
        associatorName = associatorName.substring(associatorName.lastIndexOf(46) + 1, associatorName.length());
        if (loadImages && !this.m_visual.loadIcons("weka/gui/beans/icons/" + associatorName + ".gif", "weka/gui/beans/icons/" + associatorName + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(associatorName);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Associator);
    }

    public weka.associations.Associator getAssociator() {
        return this.m_Associator;
    }

    @Override
    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.associations.Associator)) {
            throw new IllegalArgumentException(algorithm.getClass() + " : incorrect type of algorithm (Associator)");
        }
        this.setAssociator((weka.associations.Associator)algorithm);
    }

    @Override
    public Object getWrappedAlgorithm() {
        return this.getAssociator();
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e2) {
        Instances trainingSet = e2.getTrainingSet();
        DataSetEvent dse = new DataSetEvent(this, trainingSet);
        this.acceptDataSet(dse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptDataSet(final DataSetEvent e2) {
        block7: {
            if (e2.isStructureOnly()) {
                return;
            }
            if (this.m_buildThread == null) {
                try {
                    if (this.m_state != IDLE) break block7;
                    Associator associator = this;
                    synchronized (associator) {
                        this.m_state = BUILDING_MODEL;
                    }
                    final Instances trainingData = e2.getDataSet();
                    this.m_buildThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (trainingData != null) {
                                    Associator.this.m_visual.setAnimated();
                                    if (Associator.this.m_log != null) {
                                        Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "Building model...");
                                    }
                                    Associator.this.buildAssociations(trainingData);
                                    if (Associator.this.m_textListeners.size() > 0) {
                                        String modelString = Associator.this.m_Associator.toString();
                                        String titleString = Associator.this.m_Associator.getClass().getName();
                                        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
                                        modelString = "=== Associator model ===\n\nScheme:   " + titleString + "\nRelation: " + trainingData.relationName() + "\n\n" + modelString;
                                        titleString = "Model: " + titleString;
                                        TextEvent nt = new TextEvent(Associator.this, modelString, titleString);
                                        Associator.this.notifyTextListeners(nt);
                                    }
                                    if (Associator.this.m_Associator instanceof Drawable && Associator.this.m_graphListeners.size() > 0) {
                                        String grphString = ((Drawable)((Object)Associator.this.m_Associator)).graph();
                                        int grphType = ((Drawable)((Object)Associator.this.m_Associator)).graphType();
                                        String grphTitle = Associator.this.m_Associator.getClass().getName();
                                        grphTitle = grphTitle.substring(grphTitle.lastIndexOf(46) + 1, grphTitle.length());
                                        grphTitle = " (" + e2.getDataSet().relationName() + ") " + grphTitle;
                                        GraphEvent ge = new GraphEvent(Associator.this, grphString, grphTitle, grphType);
                                        Associator.this.notifyGraphListeners(ge);
                                    }
                                    if (Associator.this.m_Associator instanceof AssociationRulesProducer && Associator.this.m_rulesListeners.size() > 0) {
                                        AssociationRules rules = ((AssociationRulesProducer)((Object)Associator.this.m_Associator)).getAssociationRules();
                                        BatchAssociationRulesEvent bre = new BatchAssociationRulesEvent(Associator.this, rules);
                                        Associator.this.notifyRulesListeners(bre);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                Associator.this.stop();
                                if (Associator.this.m_log != null) {
                                    Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "ERROR (See log for details)");
                                    Associator.this.m_log.logMessage("[Associator] " + Associator.this.statusMessagePrefix() + " problem training associator. " + ex.getMessage());
                                }
                                ex.printStackTrace();
                            }
                            finally {
                                Associator.this.m_visual.setStatic();
                                Associator.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    if (Associator.this.m_log != null) {
                                        String titleString = Associator.this.m_Associator.getClass().getName();
                                        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
                                        Associator.this.m_log.logMessage("[Associator] " + Associator.this.statusMessagePrefix() + " Build associator interrupted!");
                                        Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "INTERRUPTED");
                                    }
                                } else if (Associator.this.m_log != null) {
                                    Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "Finished.");
                                }
                                Associator.this.block(false);
                            }
                        }
                    };
                    this.m_buildThread.setPriority(1);
                    this.m_buildThread.start();
                    this.block(true);
                    this.m_buildThread = null;
                    this.m_state = IDLE;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void buildAssociations(Instances data) throws Exception {
        String[] options;
        String opts;
        if (this.m_env != null && this.m_Associator instanceof OptionHandler && (opts = this.m_env.getVariableValue("weka.gui.beans.associator.schemeOptions")) != null && opts.length() > 0 && (options = Utils.splitOptions(opts)).length > 0) {
            try {
                ((OptionHandler)((Object)this.m_Associator)).setOptions(options);
            }
            catch (Exception ex) {
                String warningMessage = "[Associator] WARNING: unable to set options \"" + opts + "\"for " + this.m_Associator.getClass().getName();
                if (this.m_log != null) {
                    this.m_log.logMessage(warningMessage);
                }
                System.err.print(warningMessage);
            }
        }
        this.m_Associator.buildAssociations(data);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultAssociator.gif", "weka/gui/beans/icons/DefaultAssociator_animated.gif");
    }

    public synchronized void addBatchAssociationRulesListener(BatchAssociationRulesListener al) {
        this.m_rulesListeners.add(al);
    }

    public synchronized void removeBatchAssociationRulesListener(BatchAssociationRulesListener al) {
        this.m_rulesListeners.remove(al);
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    public synchronized void addGraphListener(GraphListener cl) {
        this.m_graphListeners.addElement(cl);
    }

    public synchronized void removeGraphListener(GraphListener cl) {
        this.m_graphListeners.remove(cl);
    }

    @Override
    public synchronized void addConfigurationListener(ConfigurationListener cl) {
    }

    @Override
    public synchronized void removeConfigurationListener(ConfigurationListener cl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent ge) {
        Vector l;
        Associator associator = this;
        synchronized (associator) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(ge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent ge) {
        Vector l;
        Associator associator = this;
        synchronized (associator) {
            l = (Vector)this.m_graphListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((GraphListener)l.elementAt(i)).acceptGraph(ge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRulesListeners(BatchAssociationRulesEvent are) {
        Associator associator = this;
        synchronized (associator) {
            Vector l = (Vector)this.m_rulesListeners.clone();
            for (int i = 0; i < l.size(); ++i) {
                ((BatchAssociationRulesListener)l.get(i)).acceptAssociationRules(are);
            }
        }
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return !this.m_listenees.containsKey(eventName);
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenees.put(eventName, source);
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        this.m_listenees.remove(eventName);
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_buildThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public boolean isBusy() {
        return this.m_buildThread != null;
    }

    @Override
    public void stop() {
        Enumeration<String> en = this.m_listenees.keys();
        while (en.hasMoreElements()) {
            Object tempO = this.m_listenees.get(en.nextElement());
            if (!(tempO instanceof BeanCommon)) continue;
            ((BeanCommon)tempO).stop();
        }
        if (this.m_buildThread != null) {
            this.m_buildThread.interrupt();
            this.m_buildThread.stop();
            this.m_buildThread = null;
            this.m_visual.setStatic();
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_buildThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(request + " not supported (Associator)");
        }
        this.stop();
    }

    public boolean eventGeneratable(EventSetDescriptor esd) {
        String eventName = esd.getName();
        return this.eventGeneratable(eventName);
    }

    @Override
    public Instances getStructure(String eventName) {
        Instances structure = null;
        if (eventName.equals("text")) {
            ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
            attInfo.add(new Attribute("Title", (List<String>)null));
            attInfo.add(new Attribute("Text", (List<String>)null));
            structure = new Instances("TextEvent", attInfo, 0);
        } else if (eventName.equals("batchAssociationRules") && this.m_Associator != null && this.m_Associator instanceof AssociationRulesProducer) {
            String[] metricNames = ((AssociationRulesProducer)((Object)this.m_Associator)).getRuleMetricNames();
            ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
            attInfo.add(new Attribute("LHS", (List<String>)null));
            attInfo.add(new Attribute("RHS", (List<String>)null));
            attInfo.add(new Attribute("Support"));
            for (String metricName : metricNames) {
                attInfo.add(new Attribute(metricName));
            }
            structure = new Instances("batchAssociationRulesEvent", attInfo, 0);
        }
        return structure;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (eventName.compareTo("text") == 0 || eventName.compareTo("graph") == 0 || eventName.equals("batchAssociationRules")) {
            if (!this.m_listenees.containsKey("dataSet") && !this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            Object source = this.m_listenees.get("trainingSet");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("dataSet");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("dataSet")) {
                return false;
            }
            if (eventName.compareTo("graph") == 0 && !(this.m_Associator instanceof Drawable)) {
                return false;
            }
            if (eventName.equals("batchAssociationRules")) {
                if (!(this.m_Associator instanceof AssociationRulesProducer)) {
                    return false;
                }
                if (!((AssociationRulesProducer)((Object)this.m_Associator)).canProduceRules()) {
                    return false;
                }
            }
        }
        return true;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Associator instanceof OptionHandler && Utils.joinOptions(((OptionHandler)((Object)this.m_Associator)).getOptions()).length() > 0 ? Utils.joinOptions(((OptionHandler)((Object)this.m_Associator)).getOptions()) + "|" : "");
    }
}

