/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.core.Environment;
import weka.core.Settings;
import weka.gui.ColorEditor;
import weka.gui.FileEnvironmentField;
import weka.gui.GUIApplication;
import weka.gui.GenericObjectEditor;
import weka.gui.Perspective;
import weka.gui.PerspectiveManager;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;

public class SettingsEditor
extends JPanel {
    private static final long serialVersionUID = 1453121012707399758L;
    protected GUIApplication m_ownerApp;
    protected Settings m_settings;
    protected JTabbedPane m_settingsTabs = new JTabbedPane();
    protected PerspectiveSelector m_perspectiveSelector;
    List<SingleSettingsEditor> m_perspectiveEditors = new ArrayList<SingleSettingsEditor>();

    public SettingsEditor(Settings settings, GUIApplication ownerApp) {
        this.setLayout(new BorderLayout());
        this.m_settings = settings;
        this.m_ownerApp = ownerApp;
        GenericObjectEditor.registerEditors();
        PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
        if (this.m_ownerApp.getPerspectiveManager().getLoadedPerspectives().size() > 0) {
            this.setupPerspectiveSelector();
        }
        this.setupPerspectiveSettings();
        this.add((Component)this.m_settingsTabs, "Center");
    }

    public void applyToSettings() {
        if (this.m_perspectiveSelector != null) {
            this.m_perspectiveSelector.applyToSettings();
        }
        for (SingleSettingsEditor editor : this.m_perspectiveEditors) {
            editor.applyToSettings();
        }
    }

    protected void setupPerspectiveSelector() {
        this.m_perspectiveSelector = new PerspectiveSelector();
        this.m_settingsTabs.addTab("Perspectives", this.m_perspectiveSelector);
    }

    protected void setupPerspectiveSettings() {
        if (this.m_settings.getSettings(this.m_ownerApp.getApplicationID()) != null && this.m_settings.getSettings(this.m_ownerApp.getApplicationID()).size() > 1) {
            Map<Settings.SettingKey, Object> appSettings = this.m_settings.getSettings(this.m_ownerApp.getApplicationID());
            SingleSettingsEditor appEditor = new SingleSettingsEditor(appSettings);
            this.m_settingsTabs.addTab("General", appEditor);
            this.m_perspectiveEditors.add(appEditor);
        }
        Perspective mainPers = this.m_ownerApp.getMainPerspective();
        String mainTitle = mainPers.getPerspectiveTitle();
        String mainID = mainPers.getPerspectiveID();
        SingleSettingsEditor mainEditor = new SingleSettingsEditor(this.m_settings.getSettings(mainID));
        this.m_settingsTabs.addTab(mainTitle, mainEditor);
        this.m_perspectiveEditors.add(mainEditor);
        List<Perspective> availablePerspectives = this.m_ownerApp.getPerspectiveManager().getLoadedPerspectives();
        ArrayList<String> availablePerspectivesIDs = new ArrayList<String>();
        ArrayList<String> availablePerspectiveTitles = new ArrayList<String>();
        for (int i = 0; i < availablePerspectives.size(); ++i) {
            Perspective p = availablePerspectives.get(i);
            availablePerspectivesIDs.add(p.getPerspectiveID());
            availablePerspectiveTitles.add(p.getPerspectiveTitle());
        }
        Set<String> settingsIDs = this.m_settings.getSettingsIDs();
        for (String settingID : settingsIDs) {
            if (!availablePerspectivesIDs.contains(settingID)) continue;
            int indexOfP = availablePerspectivesIDs.indexOf(settingID);
            Map<Settings.SettingKey, Object> settingsForID = this.m_settings.getSettings(settingID);
            if (settingsForID == null || settingsForID.size() <= 0) continue;
            SingleSettingsEditor perpEditor = new SingleSettingsEditor(settingsForID);
            this.m_settingsTabs.addTab((String)availablePerspectiveTitles.get(indexOfP), perpEditor);
            this.m_perspectiveEditors.add(perpEditor);
        }
    }

    public static SingleSettingsEditor createSingleSettingsEditor(Map<Settings.SettingKey, Object> settingsToEdit) {
        GenericObjectEditor.registerEditors();
        PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
        return new SingleSettingsEditor(settingsToEdit);
    }

    public static int showSingleSettingsEditor(Settings settings, String settingsID, String settingsName, JComponent parent) throws IOException {
        return SettingsEditor.showSingleSettingsEditor(settings, settingsID, settingsName, parent, 600, 300);
    }

    public static int showSingleSettingsEditor(Settings settings, String settingsID, String settingsName, JComponent parent, int width, int height) throws IOException {
        boolean nix;
        SingleSettingsEditor sse = SettingsEditor.createSingleSettingsEditor(settings.getSettings(settingsID));
        sse.setPreferredSize(new Dimension(width, height));
        final JOptionPane pane = new JOptionPane(sse, -1, 2);
        String os = System.getProperty("os.name").toLowerCase();
        String suppressSwingDropSupport = System.getProperty("suppressSwingDropSupport", "false");
        boolean bl = nix = os.contains("nix") || os.contains("nux") || os.contains("aix");
        if (!nix || suppressSwingDropSupport.equalsIgnoreCase("true")) {
            pane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e2) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(pane);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            });
        }
        JDialog dialog = pane.createDialog(parent, settingsName + " Settings");
        dialog.show();
        Object resultO = pane.getValue();
        int result = -1;
        if (resultO == null) {
            result = -1;
        } else if (resultO instanceof Integer) {
            result = (Integer)resultO;
        }
        if (result == 0) {
            sse.applyToSettings();
            settings.saveSettings();
        }
        if (result == 0) {
            sse.applyToSettings();
            settings.saveSettings();
        }
        return result;
    }

    public static int showApplicationSettingsEditor(Settings settings, GUIApplication application) throws IOException {
        boolean nix;
        SettingsEditor settingsEditor = new SettingsEditor(settings, application);
        settingsEditor.setPreferredSize(new Dimension(800, 350));
        final JOptionPane pane = new JOptionPane(settingsEditor, -1, 2);
        String os = System.getProperty("os.name").toLowerCase();
        String suppressSwingDropSupport = System.getProperty("suppressSwingDropSupport", "false");
        boolean bl = nix = os.contains("nix") || os.contains("nux") || os.contains("aix");
        if (!nix || suppressSwingDropSupport.equalsIgnoreCase("true")) {
            pane.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e2) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(pane);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            });
        }
        JDialog dialog = pane.createDialog((JComponent)((Object)application), application.getApplicationName() + " Settings");
        dialog.show();
        Object resultO = pane.getValue();
        int result = -1;
        if (resultO == null) {
            result = -1;
        } else if (resultO instanceof Integer) {
            result = (Integer)resultO;
        }
        if (result == 0) {
            settingsEditor.applyToSettings();
            settings.saveSettings();
        }
        return result;
    }

    protected static class PickList
    extends JPanel
    implements PropertyEditor {
        private static final long serialVersionUID = 3505647427533464230L;
        protected JComboBox<String> m_list = new JComboBox();

        public PickList(List<String> list) {
            for (String item : list) {
                this.m_list.addItem(item);
            }
            this.setLayout(new BorderLayout());
            this.add(this.m_list, "Center");
        }

        @Override
        public void setValue(Object value) {
            this.m_list.setSelectedItem(value.toString());
        }

        @Override
        public Object getValue() {
            return this.m_list.getSelectedItem();
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
        }

        @Override
        public String getJavaInitializationString() {
            return null;
        }

        @Override
        public String getAsText() {
            return null;
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
        }

        @Override
        public String[] getTags() {
            return null;
        }

        @Override
        public Component getCustomEditor() {
            return this;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    protected class PerspectiveSelector
    extends JPanel {
        private static final long serialVersionUID = -4765015948030757897L;
        protected List<JCheckBox> m_perspectiveChecks = new ArrayList<JCheckBox>();
        protected JCheckBox m_toolBarVisibleOnStartup = new JCheckBox("Perspective toolbar visible on start up");

        public PerspectiveSelector() {
            this.setLayout(new BorderLayout());
            List<Perspective> availablePerspectives = SettingsEditor.this.m_ownerApp.getPerspectiveManager().getLoadedPerspectives();
            if (availablePerspectives.size() > 0) {
                PerspectiveManager.SelectedPerspectivePreferences userSelected = new PerspectiveManager.SelectedPerspectivePreferences();
                userSelected = SettingsEditor.this.m_settings.getSetting(SettingsEditor.this.m_ownerApp.getApplicationID(), PerspectiveManager.VISIBLE_PERSPECTIVES_KEY, userSelected, Environment.getSystemWide());
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 1));
                if (!userSelected.getPerspectivesToolbarAlwaysHidden()) {
                    p.add(this.m_toolBarVisibleOnStartup);
                    this.m_toolBarVisibleOnStartup.setSelected(userSelected.getPerspectivesToolbarVisibleOnStartup());
                }
                for (Perspective perspective : availablePerspectives) {
                    String pName = perspective.getPerspectiveTitle();
                    JCheckBox jb = new JCheckBox(pName);
                    jb.setSelected(userSelected.getUserVisiblePerspectives().contains(pName));
                    this.m_perspectiveChecks.add(jb);
                    p.add(jb);
                }
                this.add((Component)p, "Center");
            }
        }

        public void applyToSettings() {
            LinkedList<String> selectedPerspectives = new LinkedList<String>();
            for (JCheckBox c : this.m_perspectiveChecks) {
                if (!c.isSelected()) continue;
                selectedPerspectives.add(c.getText());
            }
            PerspectiveManager.SelectedPerspectivePreferences newPrefs = new PerspectiveManager.SelectedPerspectivePreferences();
            newPrefs.setUserVisiblePerspectives(selectedPerspectives);
            newPrefs.setPerspectivesToolbarVisibleOnStartup(this.m_toolBarVisibleOnStartup.isSelected());
            SettingsEditor.this.m_settings.setSetting(SettingsEditor.this.m_ownerApp.getApplicationID(), PerspectiveManager.VISIBLE_PERSPECTIVES_KEY, newPrefs);
        }
    }

    public static class SingleSettingsEditor
    extends JPanel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 8896265984902770239L;
        protected Map<Settings.SettingKey, Object> m_perspSettings;
        protected Map<Settings.SettingKey, PropertyEditor> m_editorMap = new LinkedHashMap<Settings.SettingKey, PropertyEditor>();

        public SingleSettingsEditor(Map<Settings.SettingKey, Object> pSettings) {
            this.m_perspSettings = pSettings;
            this.setLayout(new BorderLayout());
            JPanel scrollablePanel = new JPanel();
            JScrollPane scrollPane = new JScrollPane(scrollablePanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)scrollPane, "Center");
            GridBagLayout gbLayout = new GridBagLayout();
            scrollablePanel.setLayout(gbLayout);
            this.setVisible(false);
            int i = 0;
            for (Map.Entry<Settings.SettingKey, Object> prop : pSettings.entrySet()) {
                Settings.SettingKey settingName = prop.getKey();
                if (settingName.getKey().equals(PerspectiveManager.VISIBLE_PERSPECTIVES_KEY.getKey())) continue;
                Object settingValue = prop.getValue();
                List<String> pickList = prop.getKey().getPickList();
                PropertyEditor editor = null;
                if (settingValue instanceof String && pickList != null && pickList.size() > 0) {
                    PickList pEditor = new PickList(pickList);
                    pEditor.setValue(prop.getValue());
                    editor = pEditor;
                }
                Class<Object> settingClass = settingValue.getClass();
                if (editor == null) {
                    editor = PropertyEditorManager.findEditor(settingClass);
                }
                if (settingValue instanceof File) {
                    String dialogType = settingName.getMetadataElement("java.io.File.dialogType", "0");
                    Class<?>[] fileType = settingName.getMetadataElement("java.io.File.fileSelectionMode", "2");
                    int dType = Integer.parseInt(dialogType);
                    int fType = Integer.parseInt((String)fileType);
                    editor = new FileEnvironmentField("", Environment.getSystemWide(), dType, fType == 1);
                }
                if (editor == null) {
                    if (settingValue instanceof Integer) {
                        settingClass = Integer.TYPE;
                    } else if (settingValue instanceof Float) {
                        settingClass = Float.TYPE;
                    } else if (settingValue instanceof Double) {
                        settingClass = Double.TYPE;
                    } else if (settingValue instanceof Boolean) {
                        settingClass = Boolean.TYPE;
                    } else if (settingValue instanceof Long) {
                        settingClass = Long.TYPE;
                    } else if (settingValue instanceof Short) {
                        settingClass = Short.TYPE;
                    } else if (settingValue instanceof Byte) {
                        settingClass = Byte.TYPE;
                    }
                    editor = PropertyEditorManager.findEditor(settingClass);
                }
                if (editor == null) {
                    if (settingValue instanceof Classifier) {
                        editor = PropertyEditorManager.findEditor(Classifier.class);
                        settingClass = Classifier.class;
                    } else if (settingValue instanceof Clusterer) {
                        editor = PropertyEditorManager.findEditor(Clusterer.class);
                        settingClass = Clusterer.class;
                    }
                }
                if (editor == null) {
                    while (settingClass != null && editor == null) {
                        Class<?>[] interfaces = settingClass.getInterfaces();
                        if (interfaces != null) {
                            for (Class<?> intf : interfaces) {
                                editor = PropertyEditorManager.findEditor(intf);
                                if (editor == null) continue;
                                settingClass = intf;
                                break;
                            }
                        }
                        if (editor != null || (settingClass = settingClass.getSuperclass()) == null) continue;
                        editor = PropertyEditorManager.findEditor(settingClass);
                    }
                }
                if (editor != null) {
                    if (editor instanceof GenericObjectEditor) {
                        ((GenericObjectEditor)editor).setClassType(settingClass);
                    }
                    editor.addPropertyChangeListener(this);
                    editor.setValue(settingValue);
                    JComponent view = null;
                    if (editor.isPaintable() && editor.supportsCustomEditor()) {
                        view = new PropertyPanel(editor);
                    } else if (editor.supportsCustomEditor() && editor.getCustomEditor() instanceof JComponent) {
                        view = (JComponent)editor.getCustomEditor();
                    } else if (editor.getTags() != null) {
                        view = new PropertyValueSelector(editor);
                    } else if (editor.getAsText() != null) {
                        view = new PropertyText(editor);
                    } else {
                        System.err.println("Warning: Property \"" + settingName + "\" has non-displayabale editor.  Skipping.");
                        continue;
                    }
                    this.m_editorMap.put(settingName, editor);
                    JLabel propLabel = new JLabel(settingName.getDescription(), 4);
                    if (prop.getKey().getToolTip().length() > 0) {
                        propLabel.setToolTipText(prop.getKey().getToolTip());
                        view.setToolTipText(prop.getKey().getToolTip());
                    }
                    propLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 5));
                    GridBagConstraints gbConstraints = new GridBagConstraints();
                    gbConstraints.anchor = 13;
                    gbConstraints.fill = 2;
                    gbConstraints.gridy = i;
                    gbConstraints.gridx = 0;
                    gbLayout.setConstraints(propLabel, gbConstraints);
                    scrollablePanel.add(propLabel);
                    JPanel newPanel = new JPanel();
                    newPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
                    newPanel.setLayout(new BorderLayout());
                    newPanel.add((Component)view, "Center");
                    gbConstraints = new GridBagConstraints();
                    gbConstraints.anchor = 17;
                    gbConstraints.fill = 1;
                    gbConstraints.gridy = i++;
                    gbConstraints.gridx = 1;
                    gbConstraints.weightx = 100.0;
                    gbLayout.setConstraints(newPanel, gbConstraints);
                    scrollablePanel.add(newPanel);
                    continue;
                }
                System.err.println("SettingsEditor can't find an editor for: " + settingClass.toString());
            }
            Dimension dim = scrollablePanel.getPreferredSize();
            dim.height += 20;
            dim.width += 20;
            scrollPane.setPreferredSize(dim);
            this.validate();
            this.setVisible(true);
        }

        public void applyToSettings() {
            for (Map.Entry<Settings.SettingKey, Object> e2 : this.m_perspSettings.entrySet()) {
                PropertyEditor editor;
                Settings.SettingKey settingKey = e2.getKey();
                if (settingKey.getKey().equals(PerspectiveManager.VISIBLE_PERSPECTIVES_KEY.getKey()) || (editor = this.m_editorMap.get(settingKey)) == null) continue;
                Object newSettingValue = editor.getValue();
                this.m_perspSettings.put(settingKey, newSettingValue);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.repaint();
            this.revalidate();
        }
    }
}

