/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import weka.gui.CustomPanelSupplier;

public class PasswordField
extends JPanel
implements PropertyEditor,
CustomPanelSupplier {
    private static final long serialVersionUID = 8180782063577036194L;
    protected JPasswordField m_password;
    protected JLabel m_label;
    protected PropertyChangeSupport m_support = new PropertyChangeSupport(this);

    public PasswordField() {
        this("");
    }

    public PasswordField(String label) {
        this.setLayout(new BorderLayout());
        this.m_label = new JLabel(label);
        if (label.length() > 0) {
            this.m_label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        this.add((Component)this.m_label, "West");
        this.m_password = new JPasswordField();
        this.m_password.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                super.keyReleased(e2);
                PasswordField.this.m_support.firePropertyChange("", null, null);
            }
        });
        this.m_password.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                super.focusLost(e2);
                PasswordField.this.m_support.firePropertyChange("", null, null);
            }
        });
        this.add((Component)this.m_password, "Center");
    }

    public void setLabel(String label) {
        this.m_label.setText(label);
    }

    public String getText() {
        return new String(this.m_password.getPassword());
    }

    public void setText(String text) {
        this.m_password.setText(text);
        this.m_support.firePropertyChange("", null, null);
    }

    @Override
    public JPanel getCustomPanel() {
        return this;
    }

    @Override
    public Object getValue() {
        return this.getAsText();
    }

    @Override
    public void setValue(Object value) {
        this.setAsText(value.toString());
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return this.getText();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setText(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (pcl != null && this.m_support != null) {
            this.m_support.addPropertyChangeListener(pcl);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (pcl != null && this.m_support != null) {
            this.m_support.removePropertyChangeListener(pcl);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_password.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.m_password.setEditable(editable);
    }
}

