/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import weka.core.SerializedObject;
import weka.core.Utils;

public class GenericObjectEditorHistory
implements Serializable {
    private static final long serialVersionUID = -1255734638729633595L;
    public static final int MAX_HISTORY_COUNT = 10;
    public static final int MAX_HISTORY_LENGTH = 200;
    public static final int MAX_LINE_LENGTH = 80;
    protected Vector<Object> m_History;

    public GenericObjectEditorHistory() {
        this.initialize();
    }

    protected void initialize() {
        this.m_History = new Vector();
    }

    public synchronized void clear() {
        this.m_History.clear();
    }

    public synchronized void add(Object obj) {
        if (this.m_History.contains(obj = this.copy(obj))) {
            this.m_History.remove(obj);
        }
        this.m_History.insertElementAt(obj, 0);
        while (this.m_History.size() > 10) {
            this.m_History.remove(this.m_History.size() - 1);
        }
    }

    public synchronized int size() {
        return this.m_History.size();
    }

    public synchronized Vector<Object> getHistory() {
        return this.m_History;
    }

    protected Object copy(Object obj) {
        Object result;
        try {
            SerializedObject so = new SerializedObject(obj);
            result = so.getObject();
        }
        catch (Exception e2) {
            result = null;
            e2.printStackTrace();
        }
        return result;
    }

    protected String generateMenuItemCaption(Object obj) {
        StringBuffer result = new StringBuffer();
        String cmd = Utils.toCommandLine(obj);
        if (cmd.length() > 200) {
            cmd = cmd.substring(0, 200) + "...";
        }
        String[] lines = Utils.breakUp(cmd, 80);
        result.append("<html>");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            result.append(lines[i].trim());
        }
        result.append("</html>");
        return result.toString();
    }

    public void customizePopupMenu(JPopupMenu menu, Object current, HistorySelectionListener listener) {
        if (this.m_History.size() == 0) {
            return;
        }
        JMenu submenu = new JMenu("History");
        menu.addSeparator();
        menu.add(submenu);
        JMenuItem item = new JMenuItem("Clear history");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenericObjectEditorHistory.this.m_History.clear();
            }
        });
        submenu.add(item);
        final HistorySelectionListener fListener = listener;
        for (int i = 0; i < this.m_History.size(); ++i) {
            if (i == 0) {
                submenu.addSeparator();
            }
            final Object history = this.m_History.get(i);
            item = new JMenuItem(this.generateMenuItemCaption(history));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    fListener.historySelected(new HistorySelectionEvent(fListener, history));
                }
            });
            submenu.add(item);
        }
    }

    public static interface HistorySelectionListener {
        public void historySelected(HistorySelectionEvent var1);
    }

    public static class HistorySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 45824542929908105L;
        protected Object m_HistoryItem;

        public HistorySelectionEvent(Object source, Object historyItem) {
            super(source);
            this.m_HistoryItem = historyItem;
        }

        public Object getHistoryItem() {
            return this.m_HistoryItem;
        }
    }
}

