/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import weka.core.Defaults;
import weka.core.Instances;
import weka.gui.GUIApplication;
import weka.gui.Logger;
import weka.gui.Perspective;
import weka.gui.PerspectiveInfo;
import weka.gui.knowledgeflow.StepVisual;

public abstract class AbstractPerspective
extends JPanel
implements Perspective {
    private static final long serialVersionUID = 1919714661641262879L;
    protected boolean m_isActive;
    protected boolean m_isLoaded;
    protected GUIApplication m_mainApplication;
    protected String m_perspectiveTitle = "";
    protected String m_perspectiveID = "";
    protected String m_perspectiveTipText = "";
    protected Icon m_perspectiveIcon;
    protected Logger m_log;

    public AbstractPerspective() {
    }

    public AbstractPerspective(String ID2, String title) {
        this.m_perspectiveTitle = title;
        this.m_perspectiveID = ID2;
    }

    public void terminate() {
        for (JMenu m : this.getMenus()) {
            m.removeAll();
        }
    }

    @Override
    public void instantiationComplete() {
    }

    @Override
    public boolean okToBeActive() {
        return true;
    }

    @Override
    public void setActive(boolean active) {
        this.m_isActive = active;
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.m_isLoaded = loaded;
    }

    @Override
    public void setMainApplication(GUIApplication main) {
        this.m_mainApplication = main;
    }

    @Override
    public GUIApplication getMainApplication() {
        return this.m_mainApplication;
    }

    @Override
    public String getPerspectiveID() {
        if (this.m_perspectiveID != null && this.m_perspectiveID.length() > 0) {
            return this.m_perspectiveID;
        }
        PerspectiveInfo perspectiveA = this.getClass().getAnnotation(PerspectiveInfo.class);
        if (perspectiveA != null) {
            this.m_perspectiveID = perspectiveA.ID();
        }
        return this.m_perspectiveID;
    }

    @Override
    public String getPerspectiveTitle() {
        if (this.m_perspectiveTitle != null && this.m_perspectiveTitle.length() > 0) {
            return this.m_perspectiveTitle;
        }
        PerspectiveInfo perspectiveA = this.getClass().getAnnotation(PerspectiveInfo.class);
        if (perspectiveA != null) {
            this.m_perspectiveTitle = perspectiveA.title();
        }
        return this.m_perspectiveTitle;
    }

    @Override
    public String getPerspectiveTipText() {
        if (this.m_perspectiveTipText != null && this.m_perspectiveTipText.length() > 0) {
            return this.m_perspectiveTipText;
        }
        PerspectiveInfo perspectiveA = this.getClass().getAnnotation(PerspectiveInfo.class);
        if (perspectiveA != null) {
            this.m_perspectiveTipText = perspectiveA.toolTipText();
        }
        return this.m_perspectiveTipText;
    }

    @Override
    public Icon getPerspectiveIcon() {
        if (this.m_perspectiveIcon != null) {
            return this.m_perspectiveIcon;
        }
        PerspectiveInfo perspectiveA = this.getClass().getAnnotation(PerspectiveInfo.class);
        if (perspectiveA != null && perspectiveA.iconPath() != null && perspectiveA.iconPath().length() > 0) {
            this.m_perspectiveIcon = StepVisual.loadIcon(this.getClass().getClassLoader(), perspectiveA.iconPath());
        }
        return this.m_perspectiveIcon;
    }

    @Override
    public List<JMenu> getMenus() {
        return new ArrayList<JMenu>();
    }

    @Override
    public void setInstances(Instances instances) {
    }

    @Override
    public boolean acceptsInstances() {
        return false;
    }

    @Override
    public boolean requiresLog() {
        return false;
    }

    @Override
    public Defaults getDefaultSettings() {
        return null;
    }

    @Override
    public void settingsChanged() {
    }

    @Override
    public void setLog(Logger log2) {
        this.m_log = log2;
    }

    @Override
    public String toString() {
        return this.getPerspectiveTitle();
    }
}

