/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionMetadata;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class OrdinalToNumeric
extends PotentialClassIgnorer
implements StreamableFilter,
UnsupervisedFilter,
EnvironmentHandler,
WeightedAttributesHandler,
WeightedInstancesHandler {
    private static final long serialVersionUID = -5199516576940135696L;
    protected transient Environment m_env = Environment.getSystemWide();
    protected Range m_selectedRange;
    protected String m_range = "first-last";
    protected String m_resolvedRange = "";

    public String globalInfo() {
        return "An attribute filter that converts ordinal nominal attributes into numeric ones";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration<Option> e2 = super.listOptions();
        while (e2.hasMoreElements()) {
            result.addElement(e2.nextElement());
        }
        result.addElement(new Option("\tAttributes to operate on. Can be a 1-based index range of indices, or a comma-separated list of names.\n\t(default: first-last)", "R", 1, "-R <range or list of names>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String atts = Utils.getOption('R', options);
        if (atts.length() > 0) {
            this.setAttributesToOperateOn(atts);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.addAll(Arrays.asList(super.getOptions()));
        result.add("-R");
        result.add(this.getAttributesToOperateOn());
        return result.toArray(new String[result.size()]);
    }

    @OptionMetadata(displayName="Attributes to operate on", description="Attributes to operate on. Can be a 1-based index range of indices or a comma-separated list of names", commandLineParamName="R", commandLineParamSynopsis="-R <range or list of names>", displayOrder=1)
    public void setAttributesToOperateOn(String atts) {
        this.m_range = atts;
    }

    public String getAttributesToOperateOn() {
        return this.m_range;
    }

    @Override
    public boolean setInputFormat(Instances instancesInfo) throws Exception {
        super.setInputFormat(instancesInfo);
        this.m_resolvedRange = this.m_range;
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        if (this.m_resolvedRange == null || this.m_resolvedRange.length() <= 0) {
            throw new Exception("No attributes to operate on defined");
        }
        this.m_resolvedRange = this.m_env.substitute(this.m_resolvedRange);
        this.m_selectedRange = Utils.configureRangeFromRangeStringOrAttributeNameList(instancesInfo, this.m_resolvedRange);
        int[] selectedIndexes = this.m_selectedRange.getSelection();
        Instances outputFormat = new Instances(instancesInfo, 0);
        if (selectedIndexes.length > 0) {
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (int i = 0; i < instancesInfo.numAttributes(); ++i) {
                if (this.m_selectedRange.isInRange(i) && instancesInfo.attribute(i).isNominal() && i != instancesInfo.classIndex()) {
                    Attribute att = new Attribute(instancesInfo.attribute(i).name());
                    att.setWeight(instancesInfo.attribute(i).weight());
                    atts.add(att);
                    continue;
                }
                atts.add(instancesInfo.attribute(i));
            }
            outputFormat = new Instances(instancesInfo.relationName(), atts, 0);
            outputFormat.setClassIndex(instancesInfo.classIndex());
        }
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    public boolean input(Instance inst) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.push(inst);
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: $");
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public static void main(String[] args) {
        OrdinalToNumeric.runFilter(new OrdinalToNumeric(), args);
    }
}

