/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.AbstractEvaluationMetric;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.experiment.SplitEvaluator;

public class ClassifierSplitEvaluator
implements SplitEvaluator,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    static final long serialVersionUID = -8511241602760467265L;
    protected Classifier m_Template = new ZeroR();
    protected Classifier m_Classifier;
    protected Evaluation m_Evaluation;
    protected String[] m_AdditionalMeasures = null;
    protected boolean[] m_doesProduce = null;
    protected int m_numberAdditionalMeasures = 0;
    protected String m_result = null;
    protected String m_ClassifierOptions = "";
    protected String m_ClassifierVersion = "";
    private static final int KEY_SIZE = 3;
    private static final int RESULT_SIZE = 32;
    private static final int NUM_IR_STATISTICS = 16;
    private static final int NUM_WEIGHTED_IR_STATISTICS = 10;
    private static final int NUM_UNWEIGHTED_IR_STATISTICS = 2;
    private int m_IRclass = 0;
    private boolean m_predTargetColumn = false;
    private int m_attID = -1;
    private boolean m_NoSizeDetermination;
    protected final List<AbstractEvaluationMetric> m_pluginMetrics = new ArrayList<AbstractEvaluationMetric>();
    protected int m_numPluginStatistics = 0;

    public ClassifierSplitEvaluator() {
        this.updateOptions();
        ArrayList<AbstractEvaluationMetric> pluginMetrics = AbstractEvaluationMetric.getPluginMetrics();
        if (pluginMetrics != null) {
            for (AbstractEvaluationMetric m : pluginMetrics) {
                System.err.println(m.getMetricName());
                if (!m.appliesToNominalClass()) continue;
                this.m_pluginMetrics.add(m);
                this.m_numPluginStatistics += m.getStatisticNames().size();
            }
        }
    }

    public String globalInfo() {
        return " A SplitEvaluator that produces results for a classification scheme on a nominal class attribute.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tThe full class name of the classifier.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W <class name>"));
        newVector.addElement(new Option("\tThe index of the class for which IR statistics\n\tare to be output. (default 1)", "C", 1, "-C <index>"));
        newVector.addElement(new Option("\tThe index of an attribute to output in the\n\tresults. This attribute should identify an\n\tinstance in order to know which instances are\n\tin the test set of a cross validation. if 0\n\tno output (default 0).", "I", 1, "-I <index>"));
        newVector.addElement(new Option("\tAdd target and prediction columns to the result\n\tfor each fold.", "P", 0, "-P"));
        newVector.addElement(new Option("\tSkips the determination of sizes (train/test/classifier)\n\t(default: sizes are determined)", "no-size", 0, "-no-size"));
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Template.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_Template)).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String indexName;
        String cName = Utils.getOption('W', options);
        if (cName.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(AbstractClassifier.forName(cName, null));
        if (this.getClassifier() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getClassifier())).setOptions(Utils.partitionOptions(options));
            this.updateOptions();
        }
        this.m_IRclass = (indexName = Utils.getOption('C', options)).length() != 0 ? new Integer(indexName) - 1 : 0;
        String attID = Utils.getOption('I', options);
        this.m_attID = attID.length() != 0 ? new Integer(attID) - 1 : -1;
        this.m_predTargetColumn = Utils.getFlag('P', options);
        this.m_NoSizeDetermination = Utils.getFlag("no-size", options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] classifierOptions = new String[]{};
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            classifierOptions = ((OptionHandler)((Object)this.m_Template)).getOptions();
        }
        if (this.getClassifier() != null) {
            result.add("-W");
            result.add(this.getClassifier().getClass().getName());
        }
        result.add("-I");
        result.add("" + (this.m_attID + 1));
        if (this.getPredTargetColumn()) {
            result.add("-P");
        }
        result.add("-C");
        result.add("" + (this.m_IRclass + 1));
        if (this.getNoSizeDetermination()) {
            result.add("-no-size");
        }
        result.add("--");
        result.addAll(Arrays.asList(classifierOptions));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_AdditionalMeasures = additionalMeasures;
        if (this.m_AdditionalMeasures != null && this.m_AdditionalMeasures.length > 0) {
            this.m_doesProduce = new boolean[this.m_AdditionalMeasures.length];
            if (this.m_Template instanceof AdditionalMeasureProducer) {
                Enumeration<String> en = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
                while (en.hasMoreElements()) {
                    String mname = en.nextElement();
                    for (int j = 0; j < this.m_AdditionalMeasures.length; ++j) {
                        if (mname.compareToIgnoreCase(this.m_AdditionalMeasures[j]) != 0) continue;
                        this.m_doesProduce[j] = true;
                    }
                }
            }
        } else {
            this.m_doesProduce = null;
        }
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            Enumeration<String> en = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = en.nextElement();
                newVector.add(mname);
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            if (this.m_Classifier == null) {
                throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return result for measure, classifier has not been built yet.");
            }
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return value for : " + additionalMeasureName + ". " + this.m_Template.getClass().getName() + " is not an AdditionalMeasureProducer");
    }

    @Override
    public Object[] getKeyTypes() {
        Object[] keyTypes = new Object[]{"", "", ""};
        return keyTypes;
    }

    @Override
    public String[] getKeyNames() {
        String[] keyNames = new String[]{"Scheme", "Scheme_options", "Scheme_version_ID"};
        return keyNames;
    }

    @Override
    public Object[] getKey() {
        Object[] key = new Object[]{this.m_Template.getClass().getName(), this.m_ClassifierOptions, this.m_ClassifierVersion};
        return key;
    }

    @Override
    public Object[] getResultTypes() {
        int i;
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int overall_length = 32 + addm;
        overall_length += 16;
        overall_length += 10;
        overall_length += 2;
        if (this.getAttributeID() >= 0) {
            ++overall_length;
        }
        if (this.getPredTargetColumn()) {
            overall_length += 2;
        }
        Object[] resultTypes = new Object[overall_length += this.m_numPluginStatistics];
        Double doub = new Double(0.0);
        int current = 0;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        if (this.getAttributeID() >= 0) {
            resultTypes[current++] = "";
        }
        if (this.getPredTargetColumn()) {
            resultTypes[current++] = "";
            resultTypes[current++] = "";
        }
        resultTypes[current++] = "";
        for (i = 0; i < addm; ++i) {
            resultTypes[current++] = doub;
        }
        for (i = 0; i < this.m_numPluginStatistics; ++i) {
            resultTypes[current++] = doub;
        }
        if (current != overall_length) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return resultTypes;
    }

    @Override
    public String[] getResultNames() {
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int overall_length = 32 + addm;
        overall_length += 16;
        overall_length += 10;
        overall_length += 2;
        if (this.getAttributeID() >= 0) {
            ++overall_length;
        }
        if (this.getPredTargetColumn()) {
            overall_length += 2;
        }
        String[] resultNames = new String[overall_length += this.m_numPluginStatistics];
        int current = 0;
        resultNames[current++] = "Number_of_training_instances";
        resultNames[current++] = "Number_of_testing_instances";
        resultNames[current++] = "Number_correct";
        resultNames[current++] = "Number_incorrect";
        resultNames[current++] = "Number_unclassified";
        resultNames[current++] = "Percent_correct";
        resultNames[current++] = "Percent_incorrect";
        resultNames[current++] = "Percent_unclassified";
        resultNames[current++] = "Kappa_statistic";
        resultNames[current++] = "Mean_absolute_error";
        resultNames[current++] = "Root_mean_squared_error";
        resultNames[current++] = "Relative_absolute_error";
        resultNames[current++] = "Root_relative_squared_error";
        resultNames[current++] = "SF_prior_entropy";
        resultNames[current++] = "SF_scheme_entropy";
        resultNames[current++] = "SF_entropy_gain";
        resultNames[current++] = "SF_mean_prior_entropy";
        resultNames[current++] = "SF_mean_scheme_entropy";
        resultNames[current++] = "SF_mean_entropy_gain";
        resultNames[current++] = "KB_information";
        resultNames[current++] = "KB_mean_information";
        resultNames[current++] = "KB_relative_information";
        resultNames[current++] = "True_positive_rate";
        resultNames[current++] = "Num_true_positives";
        resultNames[current++] = "False_positive_rate";
        resultNames[current++] = "Num_false_positives";
        resultNames[current++] = "True_negative_rate";
        resultNames[current++] = "Num_true_negatives";
        resultNames[current++] = "False_negative_rate";
        resultNames[current++] = "Num_false_negatives";
        resultNames[current++] = "IR_precision";
        resultNames[current++] = "IR_recall";
        resultNames[current++] = "F_measure";
        resultNames[current++] = "Matthews_correlation";
        resultNames[current++] = "Area_under_ROC";
        resultNames[current++] = "Area_under_PRC";
        resultNames[current++] = "Weighted_avg_true_positive_rate";
        resultNames[current++] = "Weighted_avg_false_positive_rate";
        resultNames[current++] = "Weighted_avg_true_negative_rate";
        resultNames[current++] = "Weighted_avg_false_negative_rate";
        resultNames[current++] = "Weighted_avg_IR_precision";
        resultNames[current++] = "Weighted_avg_IR_recall";
        resultNames[current++] = "Weighted_avg_F_measure";
        resultNames[current++] = "Weighted_avg_matthews_correlation";
        resultNames[current++] = "Weighted_avg_area_under_ROC";
        resultNames[current++] = "Weighted_avg_area_under_PRC";
        resultNames[current++] = "Unweighted_macro_avg_F_measure";
        resultNames[current++] = "Unweighted_micro_avg_F_measure";
        resultNames[current++] = "Elapsed_Time_training";
        resultNames[current++] = "Elapsed_Time_testing";
        resultNames[current++] = "UserCPU_Time_training";
        resultNames[current++] = "UserCPU_Time_testing";
        resultNames[current++] = "UserCPU_Time_millis_training";
        resultNames[current++] = "UserCPU_Time_millis_testing";
        resultNames[current++] = "Serialized_Model_Size";
        resultNames[current++] = "Serialized_Train_Set_Size";
        resultNames[current++] = "Serialized_Test_Set_Size";
        resultNames[current++] = "Coverage_of_Test_Cases_By_Regions";
        resultNames[current++] = "Size_of_Predicted_Regions";
        if (this.getAttributeID() >= 0) {
            resultNames[current++] = "Instance_ID";
        }
        if (this.getPredTargetColumn()) {
            resultNames[current++] = "Targets";
            resultNames[current++] = "Predictions";
        }
        resultNames[current++] = "Summary";
        for (int i = 0; i < addm; ++i) {
            resultNames[current++] = this.m_AdditionalMeasures[i];
        }
        for (AbstractEvaluationMetric m : this.m_pluginMetrics) {
            List<String> statNames = m.getStatisticNames();
            for (String s : statNames) {
                resultNames[current++] = s;
            }
        }
        if (current != overall_length) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return resultNames;
    }

    @Override
    public Object[] getResult(Instances train, Instances test) throws Exception {
        if (train.classAttribute().type() != 1) {
            throw new Exception("Class attribute is not nominal!");
        }
        if (this.m_Template == null) {
            throw new Exception("No classifier has been specified");
        }
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        int overall_length = 32 + addm;
        overall_length += 16;
        overall_length += 10;
        overall_length += 2;
        if (this.getAttributeID() >= 0) {
            ++overall_length;
        }
        if (this.getPredTargetColumn()) {
            overall_length += 2;
        }
        overall_length += this.m_numPluginStatistics;
        ThreadMXBean thMonitor = ManagementFactory.getThreadMXBean();
        boolean canMeasureCPUTime = thMonitor.isThreadCpuTimeSupported();
        if (canMeasureCPUTime && !thMonitor.isThreadCpuTimeEnabled()) {
            thMonitor.setThreadCpuTimeEnabled(true);
        }
        Object[] result = new Object[overall_length];
        Evaluation eval2 = new Evaluation(train);
        this.m_Classifier = AbstractClassifier.makeCopy(this.m_Template);
        long thID = Thread.currentThread().getId();
        long CPUStartTime = -1L;
        long trainCPUTimeElapsed = -1L;
        long testCPUTimeElapsed = -1L;
        long trainTimeStart = System.currentTimeMillis();
        if (canMeasureCPUTime) {
            CPUStartTime = thMonitor.getThreadUserTime(thID);
        }
        this.m_Classifier.buildClassifier(train);
        if (canMeasureCPUTime) {
            trainCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
        }
        long trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
        long testTimeStart = System.currentTimeMillis();
        if (canMeasureCPUTime) {
            CPUStartTime = thMonitor.getThreadUserTime(thID);
        }
        double[] predictions = eval2.evaluateModel(this.m_Classifier, test, new Object[0]);
        if (canMeasureCPUTime) {
            testCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
        }
        long testTimeElapsed = System.currentTimeMillis() - testTimeStart;
        thMonitor = null;
        this.m_result = eval2.toSummaryString();
        int current = 0;
        result[current++] = new Double(train.numInstances());
        result[current++] = new Double(eval2.numInstances());
        result[current++] = new Double(eval2.correct());
        result[current++] = new Double(eval2.incorrect());
        result[current++] = new Double(eval2.unclassified());
        result[current++] = new Double(eval2.pctCorrect());
        result[current++] = new Double(eval2.pctIncorrect());
        result[current++] = new Double(eval2.pctUnclassified());
        result[current++] = new Double(eval2.kappa());
        result[current++] = new Double(eval2.meanAbsoluteError());
        result[current++] = new Double(eval2.rootMeanSquaredError());
        result[current++] = new Double(eval2.relativeAbsoluteError());
        result[current++] = new Double(eval2.rootRelativeSquaredError());
        result[current++] = new Double(eval2.SFPriorEntropy());
        result[current++] = new Double(eval2.SFSchemeEntropy());
        result[current++] = new Double(eval2.SFEntropyGain());
        result[current++] = new Double(eval2.SFMeanPriorEntropy());
        result[current++] = new Double(eval2.SFMeanSchemeEntropy());
        result[current++] = new Double(eval2.SFMeanEntropyGain());
        result[current++] = new Double(eval2.KBInformation());
        result[current++] = new Double(eval2.KBMeanInformation());
        result[current++] = new Double(eval2.KBRelativeInformation());
        result[current++] = new Double(eval2.truePositiveRate(this.m_IRclass));
        result[current++] = new Double(eval2.numTruePositives(this.m_IRclass));
        result[current++] = new Double(eval2.falsePositiveRate(this.m_IRclass));
        result[current++] = new Double(eval2.numFalsePositives(this.m_IRclass));
        result[current++] = new Double(eval2.trueNegativeRate(this.m_IRclass));
        result[current++] = new Double(eval2.numTrueNegatives(this.m_IRclass));
        result[current++] = new Double(eval2.falseNegativeRate(this.m_IRclass));
        result[current++] = new Double(eval2.numFalseNegatives(this.m_IRclass));
        result[current++] = new Double(eval2.precision(this.m_IRclass));
        result[current++] = new Double(eval2.recall(this.m_IRclass));
        result[current++] = new Double(eval2.fMeasure(this.m_IRclass));
        result[current++] = new Double(eval2.matthewsCorrelationCoefficient(this.m_IRclass));
        result[current++] = new Double(eval2.areaUnderROC(this.m_IRclass));
        result[current++] = new Double(eval2.areaUnderPRC(this.m_IRclass));
        result[current++] = new Double(eval2.weightedTruePositiveRate());
        result[current++] = new Double(eval2.weightedFalsePositiveRate());
        result[current++] = new Double(eval2.weightedTrueNegativeRate());
        result[current++] = new Double(eval2.weightedFalseNegativeRate());
        result[current++] = new Double(eval2.weightedPrecision());
        result[current++] = new Double(eval2.weightedRecall());
        result[current++] = new Double(eval2.weightedFMeasure());
        result[current++] = new Double(eval2.weightedMatthewsCorrelation());
        result[current++] = new Double(eval2.weightedAreaUnderROC());
        result[current++] = new Double(eval2.weightedAreaUnderPRC());
        result[current++] = new Double(eval2.unweightedMacroFmeasure());
        result[current++] = new Double(eval2.unweightedMicroFmeasure());
        result[current++] = new Double((double)trainTimeElapsed / 1000.0);
        result[current++] = new Double((double)testTimeElapsed / 1000.0);
        if (canMeasureCPUTime) {
            result[current++] = new Double((double)trainCPUTimeElapsed / 1000000.0 / 1000.0);
            result[current++] = new Double((double)testCPUTimeElapsed / 1000000.0 / 1000.0);
            result[current++] = new Double((double)trainCPUTimeElapsed / 1000000.0);
            result[current++] = new Double((double)testCPUTimeElapsed / 1000000.0);
        } else {
            result[current++] = new Double(Utils.missingValue());
            result[current++] = new Double(Utils.missingValue());
            result[current++] = new Double(Utils.missingValue());
            result[current++] = new Double(Utils.missingValue());
        }
        if (this.m_NoSizeDetermination) {
            result[current++] = -1.0;
            result[current++] = -1.0;
            result[current++] = -1.0;
        } else {
            ByteArrayOutputStream bastream = new ByteArrayOutputStream();
            ObjectOutputStream oostream = new ObjectOutputStream(bastream);
            oostream.writeObject(this.m_Classifier);
            result[current++] = new Double(bastream.size());
            bastream = new ByteArrayOutputStream();
            oostream = new ObjectOutputStream(bastream);
            oostream.writeObject(train);
            result[current++] = new Double(bastream.size());
            bastream = new ByteArrayOutputStream();
            oostream = new ObjectOutputStream(bastream);
            oostream.writeObject(test);
            result[current++] = new Double(bastream.size());
        }
        result[current++] = new Double(eval2.coverageOfTestCasesByPredictedRegions());
        result[current++] = new Double(eval2.sizeOfPredictedRegions());
        if (this.getAttributeID() >= 0) {
            int i;
            String idsString = "";
            if (test.attribute(this.m_attID).isNumeric()) {
                if (test.numInstances() > 0) {
                    idsString = idsString + test.instance(0).value(this.m_attID);
                }
                for (i = 1; i < test.numInstances(); ++i) {
                    idsString = idsString + "|" + test.instance(i).value(this.m_attID);
                }
            } else {
                if (test.numInstances() > 0) {
                    idsString = idsString + test.instance(0).stringValue(this.m_attID);
                }
                for (i = 1; i < test.numInstances(); ++i) {
                    idsString = idsString + "|" + test.instance(i).stringValue(this.m_attID);
                }
            }
            result[current++] = idsString;
        }
        if (this.getPredTargetColumn()) {
            String predictionsString;
            String targetsString;
            if (test.classAttribute().isNumeric()) {
                if (test.numInstances() > 0) {
                    targetsString = "";
                    targetsString = targetsString + test.instance(0).value(test.classIndex());
                    for (int i = 1; i < test.numInstances(); ++i) {
                        targetsString = targetsString + "|" + test.instance(i).value(test.classIndex());
                    }
                    result[current++] = targetsString;
                }
                if (predictions.length > 0) {
                    predictionsString = "";
                    predictionsString = predictionsString + predictions[0];
                    for (int i = 1; i < predictions.length; ++i) {
                        predictionsString = predictionsString + "|" + predictions[i];
                    }
                    result[current++] = predictionsString;
                }
            } else {
                if (test.numInstances() > 0) {
                    targetsString = "";
                    targetsString = targetsString + test.instance(0).stringValue(test.classIndex());
                    for (int i = 1; i < test.numInstances(); ++i) {
                        targetsString = targetsString + "|" + test.instance(i).stringValue(test.classIndex());
                    }
                    result[current++] = targetsString;
                }
                if (predictions.length > 0) {
                    predictionsString = "";
                    predictionsString = predictionsString + test.classAttribute().value((int)predictions[0]);
                    for (int i = 1; i < predictions.length; ++i) {
                        predictionsString = predictionsString + "|" + test.classAttribute().value((int)predictions[i]);
                    }
                    result[current++] = predictionsString;
                }
            }
        }
        result[current++] = this.m_Classifier instanceof Summarizable ? ((Summarizable)((Object)this.m_Classifier)).toSummaryString() : null;
        for (int i = 0; i < addm; ++i) {
            if (this.m_doesProduce[i]) {
                try {
                    double dv = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                    if (!Utils.isMissingValue(dv)) {
                        Double value = new Double(dv);
                        result[current++] = value;
                        continue;
                    }
                    result[current++] = null;
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                continue;
            }
            result[current++] = null;
        }
        List<AbstractEvaluationMetric> metrics = eval2.getPluginMetrics();
        if (metrics != null) {
            for (AbstractEvaluationMetric m : metrics) {
                if (!m.appliesToNominalClass()) continue;
                List<String> statNames = m.getStatisticNames();
                for (String s : statNames) {
                    result[current++] = new Double(m.getStatistic(s));
                }
            }
        }
        if (current != overall_length) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        this.m_Evaluation = eval2;
        return result;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public Classifier getClassifier() {
        return this.m_Template;
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Template = newClassifier;
        this.updateOptions();
    }

    public int getClassForIRStatistics() {
        return this.m_IRclass;
    }

    public void setClassForIRStatistics(int v) {
        this.m_IRclass = v;
    }

    public int getAttributeID() {
        return this.m_attID;
    }

    public void setAttributeID(int v) {
        this.m_attID = v;
    }

    public boolean getPredTargetColumn() {
        return this.m_predTargetColumn;
    }

    public void setPredTargetColumn(boolean v) {
        this.m_predTargetColumn = v;
    }

    public boolean getNoSizeDetermination() {
        return this.m_NoSizeDetermination;
    }

    public void setNoSizeDetermination(boolean value) {
        this.m_NoSizeDetermination = value;
    }

    public String noSizeDeterminationTipText() {
        return "If enabled, the size determination for train/test/classifier is skipped.";
    }

    protected void updateOptions() {
        this.m_ClassifierOptions = this.m_Template instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_Template)).getOptions()) : "";
        if (this.m_Template instanceof Serializable) {
            ObjectStreamClass obs = ObjectStreamClass.lookup(this.m_Template.getClass());
            this.m_ClassifierVersion = "" + obs.getSerialVersionUID();
        } else {
            this.m_ClassifierVersion = "";
        }
    }

    public void setClassifierName(String newClassifierName) throws Exception {
        try {
            this.setClassifier((Classifier)Class.forName(newClassifierName).newInstance());
        }
        catch (Exception ex) {
            throw new Exception("Can't find Classifier with class name: " + newClassifierName);
        }
    }

    @Override
    public String getRawResultOutput() {
        StringBuffer result = new StringBuffer();
        if (this.m_Classifier == null) {
            return "<null> classifier";
        }
        result.append(this.toString());
        result.append("Classifier model: \n" + this.m_Classifier.toString() + '\n');
        if (this.m_result != null) {
            result.append(this.m_result);
            if (this.m_doesProduce != null) {
                for (int i = 0; i < this.m_doesProduce.length; ++i) {
                    if (!this.m_doesProduce[i]) continue;
                    try {
                        double dv = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                        if (!Utils.isMissingValue(dv)) {
                            Double value = new Double(dv);
                            result.append(this.m_AdditionalMeasures[i] + " : " + value + '\n');
                            continue;
                        }
                        result.append(this.m_AdditionalMeasures[i] + " : " + '?' + '\n');
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
            }
        }
        return result.toString();
    }

    public String toString() {
        String result = "ClassifierSplitEvaluator: ";
        if (this.m_Template == null) {
            return result + "<null> classifier";
        }
        return result + this.m_Template.getClass().getName() + " " + this.m_ClassifierOptions + "(version " + this.m_ClassifierVersion + ")";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11323 $");
    }
}

