/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.ContingencyTables;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateQuantileEstimator;

public class UnivariateMixtureEstimator
implements UnivariateDensityEstimator,
UnivariateIntervalEstimator,
UnivariateQuantileEstimator,
OptionHandler,
Serializable {
    private static double m_normConst = Math.log(Math.sqrt(Math.PI * 2));
    private static final long serialVersionUID = -2035274930137353656L;
    protected double[] m_Values = new double[1000];
    protected double[] m_Weights = new double[1000];
    protected int m_NumValues;
    protected MM m_MixtureModel;
    protected int m_NumComponents = -1;
    protected int m_MaxNumComponents = 5;
    protected int m_Seed = 1;
    protected int m_NumBootstrapRuns = 10;
    protected int m_NumIntervals = 1000;
    protected boolean m_UseNormalizedEntropy = false;
    protected boolean m_Debug = false;
    protected Random m_Random = new Random(this.m_Seed);

    public String globalInfo() {
        return "Estimates a univariate mixture model.";
    }

    public boolean getUseNormalizedEntropy() {
        return this.m_UseNormalizedEntropy;
    }

    public void setUseNormalizedEntropy(boolean useNormalizedEntropy) {
        this.m_UseNormalizedEntropy = useNormalizedEntropy;
    }

    public String numBootstrapRunsToolTipText() {
        return "The number of Bootstrap runs to choose the number of components.";
    }

    public int getNumBootstrapRuns() {
        return this.m_NumBootstrapRuns;
    }

    public void setNumBootstrapRuns(int numBootstrapRuns) {
        this.m_NumBootstrapRuns = numBootstrapRuns;
    }

    public String numComponentsToolTipText() {
        return "The number of mixture components to use.";
    }

    public int getNumComponents() {
        return this.m_NumComponents;
    }

    public void setNumComponents(int numComponents) {
        this.m_NumComponents = numComponents;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int seed) {
        this.m_Seed = seed;
        this.m_Random = new Random(seed);
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String maxNumComponentsToolTipText() {
        return "The maximum number of mixture components to use.";
    }

    public int getMaxNumComponents() {
        return this.m_MaxNumComponents;
    }

    public void setMaxNumComponents(int maxNumComponents) {
        this.m_MaxNumComponents = maxNumComponents;
    }

    @Override
    public void addValue(double value, double weight) {
        if (!Utils.eq(weight, 0.0)) {
            this.m_MixtureModel = null;
            if (this.m_NumValues == this.m_Values.length) {
                double[] newWeights = new double[2 * this.m_NumValues];
                double[] newValues = new double[2 * this.m_NumValues];
                System.arraycopy(this.m_Values, 0, newValues, 0, this.m_NumValues);
                System.arraycopy(this.m_Weights, 0, newWeights, 0, this.m_NumValues);
                this.m_Values = newValues;
                this.m_Weights = newWeights;
            }
            this.m_Values[this.m_NumValues] = value;
            this.m_Weights[this.m_NumValues] = weight;
            ++this.m_NumValues;
        }
    }

    public MM buildModel(int K, double[] values, double[] weights) {
        MM model = null;
        double bestMSE = Double.MAX_VALUE;
        for (int numAttempts = 0; numAttempts < 5; ++numAttempts) {
            MM tempModel = new UnivariateMixtureEstimator().new MM();
            tempModel.initializeModel(K, values, weights, this.m_Random);
            double oldMSE = Double.MAX_VALUE;
            double MSE = tempModel.MSE();
            if (this.m_Debug) {
                System.err.println("MSE: " + MSE);
            }
            double[][] probs = new double[tempModel.m_K][values.length];
            while (Utils.sm(MSE, oldMSE)) {
                for (int j = 0; j < probs.length; ++j) {
                    Arrays.fill(probs[j], 0.0);
                }
                for (int i = 0; i < values.length; ++i) {
                    probs[tempModel.nearestMean((double)values[i])][i] = 1.0;
                }
                tempModel.estimateParameters(values, weights, probs);
                oldMSE = MSE;
                MSE = tempModel.MSE();
                if (!this.m_Debug) continue;
                System.err.println("MSE: " + MSE);
            }
            if (MSE < bestMSE) {
                bestMSE = MSE;
                model = tempModel;
            }
            if (!this.m_Debug) continue;
            System.err.println("Best MSE: " + bestMSE);
        }
        double oldLogLikelihood = -1.7976931348623157E308;
        double loglikelihood = model.loglikelihood(values, weights);
        double[][] probs = new double[model.m_K][values.length];
        while (Utils.gr(loglikelihood, oldLogLikelihood)) {
            for (int i = 0; i < values.length; ++i) {
                double[] p = Utils.logs2probs(model.logJointDensities(values[i]));
                for (int j = 0; j < p.length; ++j) {
                    probs[j][i] = p[j];
                }
            }
            model.estimateParameters(values, weights, probs);
            oldLogLikelihood = loglikelihood;
            loglikelihood = model.loglikelihood(values, weights);
        }
        return model;
    }

    public double[][] resampleWithWeights(Random random, boolean[] sampled) {
        int I;
        double[] P = new double[this.m_Weights.length];
        System.arraycopy(this.m_Weights, 0, P, 0, this.m_Weights.length);
        Utils.normalize(P);
        double[] Q = new double[this.m_Weights.length];
        int[] A = new int[this.m_Weights.length];
        int[] W = new int[this.m_Weights.length];
        int M = this.m_Weights.length;
        int NN = -1;
        int NP = M;
        for (I = 0; I < M; ++I) {
            if (P[I] < 0.0) {
                throw new IllegalArgumentException("Weights have to be positive.");
            }
            Q[I] = (double)M * P[I];
            if (Q[I] < 1.0) {
                W[++NN] = I;
                continue;
            }
            W[--NP] = I;
        }
        if (NN > -1 && NP < M) {
            for (int S = 0; S < M - 1; ++S) {
                int J;
                int I2 = W[S];
                A[I2] = J = W[NP];
                int n = J;
                Q[n] = Q[n] + (Q[I2] - 1.0);
                if (Q[J] < 1.0) {
                    ++NP;
                }
                if (NP >= M) break;
            }
        }
        for (I = 0; I < M; ++I) {
            int n = I;
            Q[n] = Q[n] + (double)I;
        }
        int[] counts = new int[M];
        int count = 0;
        for (int i = 0; i < this.m_Weights.length; ++i) {
            int I3;
            double U = (double)M * random.nextDouble();
            int ALRV = U < Q[I3 = (int)U] ? I3 : A[I3];
            int n = ALRV;
            counts[n] = counts[n] + 1;
            if (sampled[ALRV]) continue;
            sampled[ALRV] = true;
            ++count;
        }
        double[][] output = new double[2][count];
        int index = 0;
        for (int i = 0; i < M; ++i) {
            if (counts[i] <= 0) continue;
            output[0][index] = this.m_Values[i];
            output[1][index] = counts[i];
            ++index;
        }
        return output;
    }

    protected int findNumComponentsUsingBootStrap() {
        if (this.m_NumComponents > 0) {
            return this.m_NumComponents;
        }
        if (this.m_MaxNumComponents <= 1) {
            return 1;
        }
        double bestLogLikelihood = -1.7976931348623157E308;
        int bestNumComponents = 1;
        for (int i = 1; i <= this.m_MaxNumComponents; ++i) {
            double logLikelihood = 0.0;
            for (int k = 0; k < this.m_NumBootstrapRuns; ++k) {
                boolean[] inBag = new boolean[this.m_NumValues];
                double[][] output = this.resampleWithWeights(this.m_Random, inBag);
                MM mixtureModel = this.buildModel(i, output[0], output[1]);
                double locLogLikelihood = 0.0;
                double totalWeight = 0.0;
                for (int j = 0; j < this.m_NumValues; ++j) {
                    if (inBag[j]) continue;
                    double weight = this.m_Weights[j];
                    locLogLikelihood += weight * mixtureModel.logDensity(this.m_Values[j]);
                    totalWeight += weight;
                }
                logLikelihood += (locLogLikelihood /= totalWeight);
            }
            logLikelihood /= (double)this.m_NumBootstrapRuns;
            if (this.m_Debug) {
                System.err.println("Loglikelihood: " + logLikelihood + "\tNumber of components: " + i);
            }
            if (!(logLikelihood > bestLogLikelihood)) continue;
            bestNumComponents = i;
            bestLogLikelihood = logLikelihood;
        }
        return bestNumComponents;
    }

    protected double entropy(MM mixtureModel) {
        double entropy = 0.0;
        for (int j = 0; j < this.m_NumValues; ++j) {
            entropy += this.m_Weights[j] * ContingencyTables.entropy(Utils.logs2probs(mixtureModel.logJointDensities(this.m_Values[j])));
        }
        return (entropy *= Utils.log2) / (double)this.m_NumValues;
    }

    protected MM findModelUsingNormalizedEntropy() {
        if (this.m_NumComponents > 0) {
            return this.buildModel(this.m_NumComponents, this.m_Values, this.m_Weights);
        }
        if (this.m_MaxNumComponents <= 1) {
            return this.buildModel(1, this.m_Values, this.m_Weights);
        }
        MM bestMixtureModel = this.buildModel(1, this.m_Values, this.m_Weights);
        double loglikelihoodForOneCluster = bestMixtureModel.loglikelihood(this.m_Values, this.m_Weights);
        double bestNormalizedEntropy = 1.0;
        for (int i = 2; i <= this.m_MaxNumComponents; ++i) {
            MM mixtureModel = this.buildModel(i, this.m_Values, this.m_Weights);
            double loglikelihood = mixtureModel.loglikelihood(this.m_Values, this.m_Weights);
            if (loglikelihood < loglikelihoodForOneCluster) {
                if (!this.m_Debug) continue;
                System.err.println("Likelihood for one cluster greater than for " + i + " clusters.");
                continue;
            }
            double entropy = this.entropy(mixtureModel);
            double normalizedEntropy = entropy / (loglikelihood - loglikelihoodForOneCluster);
            if (this.m_Debug) {
                System.err.println("Entropy: " + entropy + "\tLogLikelihood: " + loglikelihood + "\tLoglikelihood for one cluster: " + loglikelihoodForOneCluster + "\tNormalized entropy: " + normalizedEntropy + "\tNumber of components: " + i);
            }
            if (!(normalizedEntropy < bestNormalizedEntropy)) continue;
            bestMixtureModel = mixtureModel;
            bestNormalizedEntropy = normalizedEntropy;
        }
        return bestMixtureModel;
    }

    protected void updateModel() {
        if (this.m_MixtureModel != null) {
            return;
        }
        if (this.m_NumValues > 0) {
            if (this.m_Values.length > this.m_NumValues) {
                double[] values = new double[this.m_NumValues];
                double[] weights = new double[this.m_NumValues];
                System.arraycopy(this.m_Values, 0, values, 0, this.m_NumValues);
                System.arraycopy(this.m_Weights, 0, weights, 0, this.m_NumValues);
                this.m_Values = values;
                this.m_Weights = weights;
            }
            this.m_MixtureModel = this.m_UseNormalizedEntropy ? this.findModelUsingNormalizedEntropy() : this.buildModel(this.findNumComponentsUsingBootStrap(), this.m_Values, this.m_Weights);
        }
    }

    @Override
    public double[][] predictIntervals(double conf) {
        this.updateModel();
        return this.m_MixtureModel.predictIntervals(conf);
    }

    @Override
    public double predictQuantile(double percentage) {
        this.updateModel();
        return this.m_MixtureModel.predictQuantile(percentage);
    }

    @Override
    public double logDensity(double value) {
        this.updateModel();
        if (this.m_MixtureModel == null) {
            return Math.log(Double.MIN_VALUE);
        }
        return this.m_MixtureModel.logDensity(value);
    }

    public String toString() {
        this.updateModel();
        if (this.m_MixtureModel == null) {
            return "";
        }
        return this.m_MixtureModel.toString();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> options = new Vector<Option>();
        options.addElement(new Option("\tNumber of components to use (default: -1).", "N", 1, "-N"));
        options.addElement(new Option("\tMaximum number of components to use (default: 5).", "M", 1, "-M"));
        options.addElement(new Option("\tSeed for the random number generator (default: 1).", "S", 1, "-S"));
        options.addElement(new Option("\tThe number of bootstrap runs to use (default: 10).", "B", 1, "-B"));
        options.addElement(new Option("\tUse normalized entropy instead of bootstrap.", "E", 1, "-E"));
        return options.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption("N", options);
        if (optionString.length() > 0) {
            this.setNumComponents(Integer.parseInt(optionString));
        } else {
            this.setNumComponents(-1);
        }
        optionString = Utils.getOption("M", options);
        if (optionString.length() > 0) {
            this.setMaxNumComponents(Integer.parseInt(optionString));
        } else {
            this.setMaxNumComponents(5);
        }
        optionString = Utils.getOption("S", options);
        if (optionString.length() > 0) {
            this.setSeed(Integer.parseInt(optionString));
        } else {
            this.setSeed(1);
        }
        optionString = Utils.getOption("B", options);
        if (optionString.length() > 0) {
            this.setNumBootstrapRuns(Integer.parseInt(optionString));
        } else {
            this.setNumBootstrapRuns(10);
        }
        this.m_UseNormalizedEntropy = Utils.getFlag("E", options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-N");
        options.add("" + this.getNumComponents());
        options.add("-M");
        options.add("" + this.getMaxNumComponents());
        options.add("-S");
        options.add("" + this.getSeed());
        options.add("-B");
        options.add("" + this.getNumBootstrapRuns());
        if (this.m_UseNormalizedEntropy) {
            options.add("-E");
        }
        return options.toArray(new String[0]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10971 $");
    }

    public static void main(String[] args) throws Exception {
        double val;
        int i;
        int i2;
        Random r = new Random();
        UnivariateMixtureEstimator e2 = new UnivariateMixtureEstimator();
        e2.setOptions(Arrays.copyOf(args, args.length));
        System.out.println(e2);
        double sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e2.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        for (i2 = 0; i2 < 100000; ++i2) {
            e2.addValue(r.nextGaussian() * 0.5 - 1.0, 1.0);
            e2.addValue(r.nextGaussian() * 0.5 + 1.0, 3.0);
        }
        System.out.println(e2);
        sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e2.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        e2 = new UnivariateMixtureEstimator();
        e2.setOptions(Arrays.copyOf(args, args.length));
        for (i2 = 0; i2 < 100000; ++i2) {
            e2.addValue(r.nextGaussian() * 0.5 - 1.0, 1.0);
            e2.addValue(r.nextGaussian() * 0.5 + 1.0, 1.0);
            e2.addValue(r.nextGaussian() * 0.5 + 1.0, 1.0);
            e2.addValue(r.nextGaussian() * 0.5 + 1.0, 1.0);
        }
        System.out.println(e2);
        sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e2.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        e2 = new UnivariateMixtureEstimator();
        e2.setOptions(Arrays.copyOf(args, args.length));
        for (i2 = 0; i2 < 100000; ++i2) {
            e2.addValue(r.nextGaussian() * 5.0 + 3.0, 1.0);
        }
        System.out.println(e2);
        double[][] intervals = e2.predictIntervals(0.95);
        System.out.println("Lower: " + intervals[0][0] + " Upper: " + intervals[0][1]);
        double covered = 0.0;
        for (i = 0; i < 100000; ++i) {
            val = r.nextGaussian() * 5.0 + 3.0;
            if (!(val >= intervals[0][0]) || !(val <= intervals[0][1])) continue;
            covered += 1.0;
        }
        System.out.println("Coverage: " + covered / 100000.0);
        intervals = e2.predictIntervals(0.8);
        System.out.println("Lower: " + intervals[0][0] + " Upper: " + intervals[0][1]);
        covered = 0.0;
        for (i = 0; i < 100000; ++i) {
            val = r.nextGaussian() * 5.0 + 3.0;
            if (!(val >= intervals[0][0]) || !(val <= intervals[0][1])) continue;
            covered += 1.0;
        }
        System.out.println("Coverage: " + covered / 100000.0);
        System.out.println("95% quantile: " + e2.predictQuantile(0.95));
    }

    public class MM {
        protected double[] m_Means = null;
        protected double[] m_StdDevs = null;
        protected double[] m_LogPriors = null;
        protected int m_K;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Mixture model estimator\n\n");
            for (int i = 0; i < this.m_LogPriors.length; ++i) {
                sb.append("Mean: " + this.m_Means[i] + "\tStd. dev.: " + this.m_StdDevs[i] + "\tPrior prob.: " + Math.exp(this.m_LogPriors[i]) + "\n");
            }
            return sb.toString();
        }

        protected double smallestDistance(double val) {
            double min2 = Math.abs(val - this.m_Means[0]);
            for (int i = 1; i < this.m_K; ++i) {
                if (!(Math.abs(val - this.m_Means[i]) < min2)) continue;
                min2 = Math.abs(val - this.m_Means[i]);
            }
            return min2;
        }

        protected int nearestMean(double val) {
            double min2 = Math.abs(val - this.m_Means[0]);
            int index = 0;
            for (int i = 1; i < this.m_K; ++i) {
                if (!(Math.abs(val - this.m_Means[i]) < min2)) continue;
                min2 = Math.abs(val - this.m_Means[i]);
                index = i;
            }
            return index;
        }

        public void initializeModel(int K, double[] values, double[] weights, Random r) {
            double maxMinDist;
            this.m_Means = new double[K];
            double furthestVal = values[r.nextInt(values.length)];
            this.m_K = 0;
            do {
                this.m_Means[this.m_K] = furthestVal;
                ++this.m_K;
                if (this.m_K >= K) break;
                maxMinDist = this.smallestDistance(values[0]);
                furthestVal = values[0];
                for (int i = 1; i < values.length; ++i) {
                    double minDist = this.smallestDistance(values[i]);
                    if (!(minDist > maxMinDist)) continue;
                    maxMinDist = minDist;
                    furthestVal = values[i];
                }
            } while (!(maxMinDist <= 0.0));
            if (this.m_K < K) {
                double[] tempMeans = new double[this.m_K];
                System.arraycopy(this.m_Means, 0, tempMeans, 0, this.m_K);
                this.m_Means = tempMeans;
            }
            double[][] probs = new double[this.m_K][values.length];
            for (int i = 0; i < values.length; ++i) {
                probs[this.nearestMean((double)values[i])][i] = 1.0;
            }
            this.m_StdDevs = new double[this.m_K];
            this.m_LogPriors = new double[this.m_K];
            this.estimateParameters(values, weights, probs);
        }

        protected void estimateParameters(double[] values, double[] weights, double[][] probs) {
            double weight;
            int i;
            double sumWeights;
            double sum;
            int j;
            double totalSumOfWeights = 0.0;
            for (j = 0; j < this.m_K; ++j) {
                sum = 0.0;
                sumWeights = 0.0;
                for (i = 0; i < values.length; ++i) {
                    weight = probs[j][i] * weights[i];
                    sum += weight * values[i];
                    sumWeights += weight;
                }
                this.m_Means[j] = sumWeights <= 0.0 ? 0.0 : sum / sumWeights;
                totalSumOfWeights += sumWeights;
            }
            for (j = 0; j < this.m_K; ++j) {
                sum = 0.0;
                sumWeights = 0.0;
                for (i = 0; i < values.length; ++i) {
                    weight = probs[j][i] * weights[i];
                    double diff = values[i] - this.m_Means[j];
                    sum += weight * diff * diff;
                    sumWeights += weight;
                }
                if (sum <= 0.0 || sumWeights <= 0.0) {
                    this.m_StdDevs[j] = 1.0E-6;
                } else {
                    this.m_StdDevs[j] = Math.sqrt(sum / sumWeights);
                    if (this.m_StdDevs[j] < 1.0E-6) {
                        this.m_StdDevs[j] = 1.0E-6;
                    }
                }
                this.m_LogPriors[j] = sumWeights <= 0.0 ? -1.7976931348623157E308 : Math.log(sumWeights / totalSumOfWeights);
            }
        }

        public double loglikelihood(double[] values, double[] weights) {
            double sum = 0.0;
            double sumOfWeights = 0.0;
            for (int i = 0; i < values.length; ++i) {
                sum += weights[i] * this.logDensity(values[i]);
                sumOfWeights += weights[i];
            }
            return sum / sumOfWeights;
        }

        public double MSE() {
            double mse = 0.0;
            for (int i = 0; i < this.m_K; ++i) {
                mse += this.m_StdDevs[i] * this.m_StdDevs[i] * Math.exp(this.m_LogPriors[i]);
            }
            return mse;
        }

        protected double logNormalDens(double x, double mean, double stdDev) {
            double diff = x - mean;
            return -(diff * diff / (2.0 * stdDev * stdDev)) - m_normConst - Math.log(stdDev);
        }

        protected double[] logJointDensities(double value) {
            double[] a = new double[this.m_K];
            for (int i = 0; i < this.m_K; ++i) {
                a[i] = this.m_LogPriors[i] + this.logNormalDens(value, this.m_Means[i], this.m_StdDevs[i]);
            }
            return a;
        }

        public double logDensity(double value) {
            double[] a = this.logJointDensities(value);
            double max2 = a[Utils.maxIndex(a)];
            double sum = 0.0;
            for (int i = 0; i < a.length; ++i) {
                sum += Math.exp(a[i] - max2);
            }
            return max2 + Math.log(sum);
        }

        public double[][] predictIntervals(double conf) {
            double val = Statistics.normalInverse(1.0 - (1.0 - conf) / 2.0);
            double min2 = Double.MAX_VALUE;
            double max2 = -1.7976931348623157E308;
            for (int i = 0; i < this.m_Means.length; ++i) {
                double r;
                double l = this.m_Means[i] - val * this.m_StdDevs[i];
                if (l < min2) {
                    min2 = l;
                }
                if (!((r = this.m_Means[i] + val * this.m_StdDevs[i]) > max2)) continue;
                max2 = r;
            }
            double delta = (max2 - min2) / (double)UnivariateMixtureEstimator.this.m_NumIntervals;
            double[] probabilities = new double[UnivariateMixtureEstimator.this.m_NumIntervals];
            double leftVal = Math.exp(this.logDensity(min2));
            for (int i = 0; i < UnivariateMixtureEstimator.this.m_NumIntervals; ++i) {
                double rightVal = Math.exp(this.logDensity(min2 + (double)(i + 1) * delta));
                probabilities[i] = 0.5 * (leftVal + rightVal) * delta;
                leftVal = rightVal;
            }
            int[] sortedIndices = Utils.sort(probabilities);
            double sum = 0.0;
            boolean[] toUse = new boolean[probabilities.length];
            for (int k = 0; sum < conf && k < toUse.length; sum += probabilities[sortedIndices[toUse.length - (k + 1)]], ++k) {
                toUse[sortedIndices[toUse.length - (k + 1)]] = true;
            }
            probabilities = null;
            ArrayList<double[]> intervals = new ArrayList<double[]>();
            double[] interval = null;
            boolean haveStartedInterval = false;
            for (int i = 0; i < UnivariateMixtureEstimator.this.m_NumIntervals; ++i) {
                if (toUse[i]) {
                    if (!haveStartedInterval) {
                        haveStartedInterval = true;
                        interval = new double[]{min2 + (double)i * delta, min2 + (double)(i + 1) * delta};
                    }
                    continue;
                }
                if (!haveStartedInterval) continue;
                haveStartedInterval = false;
                intervals.add(interval);
            }
            if (haveStartedInterval) {
                intervals.add(interval);
            }
            return (double[][])intervals.toArray((T[])new double[0][0]);
        }

        public double predictQuantile(double percentage) {
            double valRight = Statistics.normalInverse(percentage);
            double valLeft = Statistics.normalInverse(0.001);
            double min2 = Double.MAX_VALUE;
            double max2 = -1.7976931348623157E308;
            for (int i = 0; i < this.m_Means.length; ++i) {
                double r;
                double l = this.m_Means[i] - valLeft * this.m_StdDevs[i];
                if (l < min2) {
                    min2 = l;
                }
                if (!((r = this.m_Means[i] + valRight * this.m_StdDevs[i]) > max2)) continue;
                max2 = r;
            }
            double delta = (max2 - min2) / (double)UnivariateMixtureEstimator.this.m_NumIntervals;
            double sum = 0.0;
            double leftVal = Math.exp(this.logDensity(min2));
            for (int i = 0; i < UnivariateMixtureEstimator.this.m_NumIntervals; ++i) {
                if (sum >= percentage) {
                    return min2 + (double)i * delta;
                }
                double rightVal = Math.exp(this.logDensity(min2 + (double)(i + 1) * delta));
                sum += 0.5 * (leftVal + rightVal) * delta;
                leftVal = rightVal;
            }
            return max2;
        }
    }
}

