/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class DataGenerator
implements OptionHandler,
Randomizable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3698585946221802578L;
    protected boolean m_Debug = false;
    protected Instances m_DatasetFormat = null;
    protected String m_RelationName = "";
    protected int m_NumExamplesAct;
    protected transient PrintWriter m_DefaultOutput;
    protected transient PrintWriter m_Output = this.m_DefaultOutput = new PrintWriter(new OutputStreamWriter(System.out));
    protected int m_Seed;
    protected Random m_Random = null;
    protected boolean m_CreatingRelationName = false;
    protected static HashSet<String> m_OptionBlacklist = new HashSet();

    public DataGenerator() {
        DataGenerator.clearBlacklist();
        this.setNumExamplesAct(this.defaultNumExamplesAct());
        this.setSeed(this.defaultSeed());
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tPrints this help.", "h", 1, "-h"));
        result.addElement(new Option("\tThe name of the output file, otherwise the generated data is\n\tprinted to stdout.", "o", 1, "-o <file>"));
        result.addElement(new Option("\tThe name of the relation.", "r", 1, "-r <name>"));
        result.addElement(new Option("\tWhether to print debug informations.", "d", 0, "-d"));
        result.addElement(new Option("\tThe seed for random function (default " + this.defaultSeed() + ")", "S", 1, "-S"));
        return result.elements();
    }

    public Vector<Option> enumToVector(Enumeration<Option> enu) {
        Vector<Option> options = new Vector<Option>();
        options.addAll(Collections.list(enu));
        return options;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('r', options = this.removeBlacklist(options));
        if (tmpStr.length() != 0) {
            this.setRelationName(Utils.unquote(tmpStr));
        } else {
            this.setRelationName("");
        }
        tmpStr = Utils.getOption('o', options);
        if (tmpStr.length() != 0) {
            this.setOutput(new PrintWriter(new FileOutputStream(tmpStr)));
        } else if (this.getOutput() == null) {
            throw new Exception("No Output defined!");
        }
        this.setDebug(Utils.getFlag('d', options));
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(this.defaultSeed());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getRelationName().length() > 0) {
            result.add("-r");
            result.add(Utils.quote(this.getRelationName()));
        }
        if (this.getDebug()) {
            result.add("-d");
        }
        result.add("-S");
        result.add("" + this.getSeed());
        return result.toArray(new String[result.size()]);
    }

    public Instances defineDataFormat() throws Exception {
        return this.m_DatasetFormat;
    }

    public abstract Instance generateExample() throws Exception;

    public abstract Instances generateExamples() throws Exception;

    public abstract String generateStart() throws Exception;

    public abstract String generateFinished() throws Exception;

    public abstract boolean getSingleModeFlag() throws Exception;

    public void setDebug(boolean debug2) {
        this.m_Debug = debug2;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Whether the generator is run in debug mode or not.";
    }

    public void setRelationName(String relationName) {
        this.m_RelationName = relationName;
    }

    protected String defaultRelationName() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        String[] options = this.getOptions();
        for (int i = 0; i < options.length; ++i) {
            String option = options[i].trim();
            if (i > 0) {
                result.append("_");
            }
            result.append(option.replaceAll(" ", "_"));
        }
        return result.toString();
    }

    protected String getRelationNameToUse() {
        String result = this.getRelationName();
        if (result.length() == 0) {
            result = this.defaultRelationName();
        }
        return result;
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return "The relation name of the generated data (if empty, a generic one will be supplied).";
    }

    protected int defaultNumExamplesAct() {
        return 0;
    }

    protected void setNumExamplesAct(int numExamplesAct) {
        this.m_NumExamplesAct = numExamplesAct;
    }

    public int getNumExamplesAct() {
        return this.m_NumExamplesAct;
    }

    protected String numExamplesActTipText() {
        return "The actual number of examples to generate.";
    }

    public void setOutput(PrintWriter newOutput) {
        this.m_Output = newOutput;
        this.m_DefaultOutput = null;
    }

    public PrintWriter getOutput() {
        return this.m_Output;
    }

    public PrintWriter defaultOutput() {
        return this.m_DefaultOutput;
    }

    public String outputTipText() {
        return "The output writer to use for printing the generated data.";
    }

    public void setDatasetFormat(Instances newFormat) {
        this.m_DatasetFormat = new Instances(newFormat, 0);
    }

    public Instances getDatasetFormat() {
        if (this.m_DatasetFormat != null) {
            return new Instances(this.m_DatasetFormat, 0);
        }
        return null;
    }

    public String formatTipText() {
        return "The data format to use.";
    }

    protected int defaultSeed() {
        return 1;
    }

    @Override
    public int getSeed() {
        return this.m_Seed;
    }

    @Override
    public void setSeed(int newSeed) {
        this.m_Seed = newSeed;
        this.m_Random = new Random(newSeed);
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public Random getRandom() {
        if (this.m_Random == null) {
            this.m_Random = new Random(this.getSeed());
        }
        return this.m_Random;
    }

    public void setRandom(Random newRandom) {
        this.m_Random = newRandom;
    }

    public String randomTipText() {
        return "The random number generator to use.";
    }

    protected String toStringFormat() {
        if (this.m_DatasetFormat == null) {
            return "";
        }
        return this.m_DatasetFormat.toString();
    }

    protected static void clearBlacklist() {
        m_OptionBlacklist.clear();
    }

    protected static void addToBlacklist(String option) {
        m_OptionBlacklist.add(option);
    }

    protected static boolean isOnBlacklist(String option) {
        return m_OptionBlacklist.contains(option);
    }

    protected String[] removeBlacklist(String[] options) {
        Option option;
        Enumeration<Option> enm = this.listOptions();
        Hashtable<String, Option> pool = new Hashtable<String, Option>();
        while (enm.hasMoreElements()) {
            option = enm.nextElement();
            if (!DataGenerator.isOnBlacklist(option.name())) continue;
            pool.put(option.name(), option);
        }
        Enumeration enm2 = pool.keys();
        while (enm2.hasMoreElements()) {
            option = (Option)pool.get(enm2.nextElement());
            try {
                if (option.numArguments() == 0) {
                    Utils.getFlag(option.name(), options);
                    continue;
                }
                Utils.getOption(option.name(), options);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return options;
    }

    protected static String makeOptionString(DataGenerator generator) {
        StringBuffer result = new StringBuffer();
        result.append("\nData Generator options:\n\n");
        Enumeration<Option> enm = generator.listOptions();
        while (enm.hasMoreElements()) {
            Option option = enm.nextElement();
            if (DataGenerator.isOnBlacklist(option.name())) continue;
            result.append(option.synopsis() + "\n" + option.description() + "\n");
        }
        return result.toString();
    }

    public String getPrologue() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("%");
        sb.append("% Commandline");
        sb.append("%");
        sb.append("% " + this.getClass().getName() + " " + Utils.joinOptions(this.getOptions()));
        sb.append("%");
        String commentAtStart = this.generateStart();
        if (commentAtStart.length() > 0) {
            sb.append("%");
            sb.append("% Prologue");
            sb.append("%");
            sb.append(commentAtStart.trim());
            sb.append("%");
        }
        return sb.toString();
    }

    public String getEpilogue() throws Exception {
        StringBuilder sb = new StringBuilder();
        String commentAtEnd = this.generateFinished();
        if (commentAtEnd.length() > 0) {
            sb.append("%");
            sb.append("% Epilogue");
            sb.append("%");
            sb.append(commentAtEnd.trim());
            sb.append("%");
        }
        return sb.toString();
    }

    public static void makeData(DataGenerator generator, String[] options) throws Exception {
        boolean printhelp = Utils.getFlag('h', options);
        if (!printhelp) {
            try {
                int i;
                options = generator.removeBlacklist(options);
                generator.setOptions(options);
                Vector<String> unknown = new Vector<String>();
                for (i = 0; i < options.length; ++i) {
                    if (options[i].length() == 0) continue;
                    unknown.add(options[i]);
                }
                if (unknown.size() > 0) {
                    System.out.print("Unknown options:");
                    for (i = 0; i < unknown.size(); ++i) {
                        System.out.print(" " + (String)unknown.get(i));
                    }
                    System.out.println();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                printhelp = true;
            }
        }
        if (printhelp) {
            System.out.println(DataGenerator.makeOptionString(generator));
            return;
        }
        generator.setDatasetFormat(generator.defineDataFormat());
        PrintWriter output = generator.getOutput();
        output.println(generator.getPrologue());
        boolean singleMode = generator.getSingleModeFlag();
        if (singleMode) {
            output.println(generator.toStringFormat());
            for (int i = 0; i < generator.getNumExamplesAct(); ++i) {
                output.println(generator.generateExample());
            }
        } else {
            Instances data = generator.generateExamples();
            for (int i = 0; i < data.numInstances(); ++i) {
                if (i % 1000 == 0) {
                    output.flush();
                }
                output.println(data.instance(i));
            }
            output.flush();
        }
        output.println(generator.getEpilogue());
        output.flush();
        if (generator.getOutput() != generator.defaultOutput()) {
            output.close();
        }
    }

    public static void runDataGenerator(DataGenerator datagenerator, String[] options) {
        try {
            DataGenerator.makeData(datagenerator, options);
        }
        catch (Exception e2) {
            if (e2.getMessage() != null && e2.getMessage().indexOf("Data Generator options") == -1) {
                e2.printStackTrace();
            }
            System.err.println(e2.getMessage());
        }
    }
}

