/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class XMLDocument
implements RevisionHandler {
    public static final String PI = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    public static final String DTD_DOCTYPE = "DOCTYPE";
    public static final String DTD_ELEMENT = "ELEMENT";
    public static final String DTD_ATTLIST = "ATTLIST";
    public static final String DTD_OPTIONAL = "?";
    public static final String DTD_AT_LEAST_ONE = "+";
    public static final String DTD_ZERO_OR_MORE = "*";
    public static final String DTD_SEPARATOR = "|";
    public static final String DTD_CDATA = "CDATA";
    public static final String DTD_ANY = "ANY";
    public static final String DTD_PCDATA = "#PCDATA";
    public static final String DTD_IMPLIED = "#IMPLIED";
    public static final String DTD_REQUIRED = "#REQUIRED";
    public static final String ATT_VERSION = "version";
    public static final String ATT_NAME = "name";
    public static final String VAL_YES = "yes";
    public static final String VAL_NO = "no";
    protected DocumentBuilderFactory m_Factory = DocumentBuilderFactory.newInstance();
    protected DocumentBuilder m_Builder = null;
    protected boolean m_Validating = false;
    protected Document m_Document = null;
    protected String m_DocType = null;
    protected String m_RootNode = null;
    protected XPath m_XPath = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom").newXPath();

    public XMLDocument() throws Exception {
        this.setDocType(null);
        this.setRootNode(null);
        this.setValidating(false);
    }

    public XMLDocument(String xml) throws Exception {
        this();
        this.read(xml);
    }

    public XMLDocument(File file) throws Exception {
        this();
        this.read(file);
    }

    public XMLDocument(InputStream stream) throws Exception {
        this();
        this.read(stream);
    }

    public XMLDocument(Reader reader) throws Exception {
        this();
        this.read(reader);
    }

    public DocumentBuilderFactory getFactory() {
        return this.m_Factory;
    }

    public DocumentBuilder getBuilder() {
        return this.m_Builder;
    }

    public boolean getValidating() {
        return this.m_Validating;
    }

    public void setValidating(boolean validating) throws Exception {
        this.m_Validating = validating;
        this.m_Factory.setValidating(validating);
        this.m_Builder = this.m_Factory.newDocumentBuilder();
        this.clear();
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public void setDocument(Document newDocument) {
        this.m_Document = newDocument;
    }

    public void setDocType(String docType) {
        this.m_DocType = docType;
    }

    public String getDocType() {
        return this.m_DocType;
    }

    public void setRootNode(String rootNode) {
        this.m_RootNode = rootNode == null ? "root" : rootNode;
    }

    public String getRootNode() {
        return this.m_RootNode;
    }

    public void clear() {
        this.newDocument(this.getDocType(), this.getRootNode());
    }

    public Document newDocument(String docType, String rootNode) {
        this.m_Document = this.getBuilder().newDocument();
        this.m_Document.appendChild(this.m_Document.createElement(rootNode));
        this.setDocType(docType);
        return this.getDocument();
    }

    public Document read(String xml) throws Exception {
        if (xml.toLowerCase().indexOf("<?xml") > -1) {
            return this.read(new ByteArrayInputStream(xml.getBytes()));
        }
        return this.read(new File(xml));
    }

    public Document read(File file) throws Exception {
        this.m_Document = this.getBuilder().parse(file);
        return this.getDocument();
    }

    public Document read(InputStream stream) throws Exception {
        this.m_Document = this.getBuilder().parse(stream);
        return this.getDocument();
    }

    public Document read(Reader reader) throws Exception {
        this.m_Document = this.getBuilder().parse(new InputSource(reader));
        return this.getDocument();
    }

    public void write(String file) throws Exception {
        this.write(new File(file));
    }

    public void write(File file) throws Exception {
        this.write(new BufferedWriter(new FileWriter(file)));
    }

    public void write(OutputStream stream) throws Exception {
        String xml = this.toString();
        stream.write(xml.getBytes(), 0, xml.length());
        stream.flush();
    }

    public void write(Writer writer) throws Exception {
        writer.write(this.toString());
        writer.flush();
    }

    public static Vector<Element> getChildTags(Node parent) {
        return XMLDocument.getChildTags(parent, "");
    }

    public static Vector<Element> getChildTags(Node parent, String name) {
        Vector<Element> result = new Vector<Element>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element) || name.length() != 0 && !((Element)list.item(i)).getTagName().equals(name)) continue;
            result.add((Element)list.item(i));
        }
        return result;
    }

    protected Object eval(String xpath, QName type) {
        Object result;
        try {
            result = this.m_XPath.evaluate(xpath, this.m_Document, type);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            result = null;
        }
        return result;
    }

    public NodeList findNodes(String xpath) {
        return (NodeList)this.eval(xpath, XPathConstants.NODESET);
    }

    public Node getNode(String xpath) {
        return (Node)this.eval(xpath, XPathConstants.NODE);
    }

    public Boolean evalBoolean(String xpath) {
        return (Boolean)this.eval(xpath, XPathConstants.BOOLEAN);
    }

    public Double evalDouble(String xpath) {
        return (Double)this.eval(xpath, XPathConstants.NUMBER);
    }

    public String evalString(String xpath) {
        return (String)this.eval(xpath, XPathConstants.STRING);
    }

    public static String getContent(Element node) {
        String result = "";
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 3) continue;
            result = result + item.getNodeValue();
        }
        return result.trim();
    }

    protected StringBuffer toString(StringBuffer buf, Node parent, int depth) {
        String indent = "";
        for (int i = 0; i < depth; ++i) {
            indent = indent + "   ";
        }
        if (parent.getNodeType() == 3) {
            if (!parent.getNodeValue().trim().equals("")) {
                buf.append(indent + parent.getNodeValue().trim() + "\n");
            }
        } else if (parent.getNodeType() == 8) {
            buf.append(indent + "<!--" + parent.getNodeValue() + "-->\n");
        } else {
            Node node;
            int n;
            buf.append(indent + "<" + parent.getNodeName());
            if (parent.hasAttributes()) {
                NamedNodeMap atts = parent.getAttributes();
                for (n = 0; n < atts.getLength(); ++n) {
                    node = atts.item(n);
                    buf.append(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
                }
            }
            if (parent.hasChildNodes()) {
                NodeList list = parent.getChildNodes();
                if (list.getLength() == 1 && list.item(0).getNodeType() == 3) {
                    buf.append(">");
                    buf.append(list.item(0).getNodeValue().trim());
                    buf.append("</" + parent.getNodeName() + ">\n");
                } else {
                    buf.append(">\n");
                    for (n = 0; n < list.getLength(); ++n) {
                        node = list.item(n);
                        this.toString(buf, node, depth + 1);
                    }
                    buf.append(indent + "</" + parent.getNodeName() + ">\n");
                }
            } else {
                buf.append("/>\n");
            }
        }
        return buf;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        String header = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n";
        if (this.getDocType() != null) {
            header = header + this.getDocType() + "\n\n";
        }
        return this.toString(new StringBuffer(header), this.getDocument().getDocumentElement(), 0).toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            XMLDocument doc = new XMLDocument();
            doc.read(args[0]);
            doc.print();
            if (args.length > 1) {
                doc.write(args[1]);
            }
        }
    }
}

