/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stopwords;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.stopwords.StopwordsHandler;

public abstract class AbstractStopwords
implements OptionHandler,
StopwordsHandler,
Serializable {
    private static final long serialVersionUID = -1975256329586388142L;
    protected boolean m_Initialized;
    protected boolean m_Debug;

    public abstract String globalInfo();

    protected void reset() {
        this.m_Initialized = false;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tIf set, stopword scheme is run in debug mode and\n\tmay output additional info to the console", "D", 0, "-D"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag("D", options));
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.getDebug()) {
            options.add("-D");
        }
        return options.toArray(new String[options.size()]);
    }

    public void setDebug(boolean debug2) {
        this.m_Debug = debug2;
        this.reset();
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, stopwords scheme may output additional info to the console.";
    }

    protected void error(String msg) {
        System.err.println(this.getClass().getName() + "-ERROR: " + msg);
    }

    protected void debug(String msg) {
        System.err.println(this.getClass().getName() + "-DEBUG: " + msg);
    }

    protected void initialize() {
    }

    protected abstract boolean is(String var1);

    @Override
    public boolean isStopword(String word) {
        if (!this.m_Initialized) {
            if (this.m_Debug) {
                this.debug("Initializing stopwords");
            }
            this.initialize();
            this.m_Initialized = true;
        }
        boolean result = this.is(word);
        if (this.m_Debug) {
            this.debug(word + " --> " + result);
        }
        return result;
    }
}

