/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.neighboursearch.kdtrees.KDTreeNode;

public abstract class KDTreeNodeSplitter
implements Serializable,
OptionHandler,
RevisionHandler {
    private static final long serialVersionUID = 7222420817095067166L;
    protected Instances m_Instances;
    protected EuclideanDistance m_EuclideanDistance;
    protected int[] m_InstList;
    protected boolean m_NormalizeNodeWidth;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int WIDTH = 2;

    public KDTreeNodeSplitter() {
    }

    public KDTreeNodeSplitter(int[] instList, Instances insts, EuclideanDistance e2) {
        this.m_InstList = instList;
        this.m_Instances = insts;
        this.m_EuclideanDistance = e2;
    }

    @Override
    public Enumeration<Option> listOptions() {
        return new Vector().elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
    }

    @Override
    public String[] getOptions() {
        return new String[0];
    }

    protected void correctlyInitialized() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied.");
        }
        if (this.m_InstList == null) {
            throw new Exception("No instance list supplied.");
        }
        if (this.m_EuclideanDistance == null) {
            throw new Exception("No Euclidean distance function supplied.");
        }
        if (this.m_Instances.numInstances() != this.m_InstList.length) {
            throw new Exception("The supplied instance list doesn't seem to match the supplied instances");
        }
    }

    public abstract void splitNode(KDTreeNode var1, int var2, double[][] var3, double[][] var4) throws Exception;

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
    }

    public void setInstanceList(int[] instList) {
        this.m_InstList = instList;
    }

    public void setEuclideanDistanceFunction(EuclideanDistance func) {
        this.m_EuclideanDistance = func;
    }

    public void setNodeWidthNormalization(boolean normalize) {
        this.m_NormalizeNodeWidth = normalize;
    }

    protected int widestDim(double[][] nodeRanges, double[][] universe) {
        int classIdx = this.m_Instances.classIndex();
        double widest = 0.0;
        int w = -1;
        if (this.m_NormalizeNodeWidth) {
            for (int i = 0; i < nodeRanges.length; ++i) {
                double newWidest = nodeRanges[i][2] / universe[i][2];
                if (!(newWidest > widest) || i == classIdx) continue;
                widest = newWidest;
                w = i;
            }
        } else {
            for (int i = 0; i < nodeRanges.length; ++i) {
                if (!(nodeRanges[i][2] > widest) || i == classIdx) continue;
                widest = nodeRanges[i][2];
                w = i;
            }
        }
        return w;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }
}

