/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import weka.core.InheritanceUtils;
import weka.core.PluginManager;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.CSVLoader;
import weka.core.converters.CSVSaver;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.Loader;
import weka.core.converters.Saver;
import weka.core.converters.SerializedInstancesLoader;
import weka.core.converters.SerializedInstancesSaver;
import weka.core.converters.TextDirectoryLoader;
import weka.core.converters.URLSourcedLoader;
import weka.core.converters.XRFFLoader;
import weka.core.converters.XRFFSaver;
import weka.gui.GenericPropertiesCreator;

public class ConverterResources {
    public static final String CORE_FILE_LOADERS = ArffLoader.class.getName() + "," + CSVLoader.class.getName() + "," + DatabaseConverter.class.getName() + "," + SerializedInstancesLoader.class.getName() + "," + TextDirectoryLoader.class.getName() + "," + XRFFLoader.class.getName();
    public static final String CORE_FILE_SAVERS = ArffSaver.class.getName() + "," + CSVSaver.class.getName() + "," + DatabaseConverter.class.getName() + "," + SerializedInstancesSaver.class.getName() + "," + XRFFSaver.class.getName();
    protected static Hashtable<String, List<String>> m_FileLoaders;
    protected static Hashtable<String, List<String>> m_URLFileLoaders;
    protected static Hashtable<String, List<String>> m_FileSavers;

    public static boolean isCoreFileLoader(String classname) {
        Object[] classnames = CORE_FILE_LOADERS.split(",");
        boolean result = Arrays.binarySearch(classnames, classname) >= 0;
        return result;
    }

    public static boolean isCoreFileSaver(String classname) {
        Object[] classnames = CORE_FILE_SAVERS.split(",");
        boolean result = Arrays.binarySearch(classnames, classname) >= 0;
        return result;
    }

    public static Hashtable<String, List<String>> getFileLoaders() {
        return m_FileLoaders;
    }

    public static Hashtable<String, List<String>> getURLFileLoaders() {
        return m_URLFileLoaders;
    }

    public static Hashtable<String, List<String>> getFileSavers() {
        return m_FileSavers;
    }

    public static void initialize() {
        List<String> classnames;
        block12: {
            try {
                m_FileLoaders = new Hashtable();
                m_URLFileLoaders = new Hashtable();
                m_FileSavers = new Hashtable();
                Properties props = GenericPropertiesCreator.getGlobalOutputProperties();
                if (props == null) {
                    GenericPropertiesCreator creator = new GenericPropertiesCreator();
                    creator.execute(false);
                    props = creator.getOutputProperties();
                }
                m_FileLoaders = ConverterResources.getFileConverters(props.getProperty(Loader.class.getName(), CORE_FILE_LOADERS), new String[]{FileSourcedConverter.class.getName()});
                m_URLFileLoaders = ConverterResources.getFileConverters(props.getProperty(Loader.class.getName(), CORE_FILE_LOADERS), new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                m_FileSavers = ConverterResources.getFileConverters(props.getProperty(Saver.class.getName(), CORE_FILE_SAVERS), new String[]{FileSourcedConverter.class.getName()});
                if (m_FileLoaders.size() != 0) break block12;
            }
            catch (Exception e2) {
                List<String> classnames2;
                block13: {
                    try {
                        e2.printStackTrace();
                        if (m_FileLoaders.size() != 0) break block13;
                    }
                    catch (Throwable throwable) {
                        List<String> classnames3;
                        if (m_FileLoaders.size() == 0) {
                            classnames3 = PluginManager.getPluginNamesOfTypeList(AbstractFileLoader.class.getName());
                            m_FileLoaders = classnames3.size() > 0 ? ConverterResources.getFileConverters(classnames3, new String[]{FileSourcedConverter.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
                        }
                        if (m_URLFileLoaders.size() == 0) {
                            classnames3 = PluginManager.getPluginNamesOfTypeList(AbstractFileLoader.class.getName());
                            m_URLFileLoaders = classnames3.size() > 0 ? ConverterResources.getFileConverters(classnames3, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                        }
                        if (m_FileSavers.size() == 0) {
                            classnames3 = PluginManager.getPluginNamesOfTypeList(AbstractFileSaver.class.getName());
                            m_FileSavers = classnames3.size() > 0 ? ConverterResources.getFileConverters(classnames3, new String[]{FileSourcedConverter.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
                        }
                        throw throwable;
                    }
                    classnames2 = PluginManager.getPluginNamesOfTypeList(AbstractFileLoader.class.getName());
                    m_FileLoaders = classnames2.size() > 0 ? ConverterResources.getFileConverters(classnames2, new String[]{FileSourcedConverter.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
                }
                if (m_URLFileLoaders.size() == 0) {
                    classnames2 = PluginManager.getPluginNamesOfTypeList(AbstractFileLoader.class.getName());
                    m_URLFileLoaders = classnames2.size() > 0 ? ConverterResources.getFileConverters(classnames2, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
                }
                if (m_FileSavers.size() == 0) {
                    classnames2 = PluginManager.getPluginNamesOfTypeList(AbstractFileSaver.class.getName());
                    m_FileSavers = classnames2.size() > 0 ? ConverterResources.getFileConverters(classnames2, new String[]{FileSourcedConverter.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
                }
            }
            classnames = PluginManager.getPluginNamesOfTypeList(AbstractFileLoader.class.getName());
            m_FileLoaders = classnames.size() > 0 ? ConverterResources.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName()});
        }
        if (m_URLFileLoaders.size() == 0) {
            classnames = PluginManager.getPluginNamesOfTypeList(AbstractFileLoader.class.getName());
            m_URLFileLoaders = classnames.size() > 0 ? ConverterResources.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_LOADERS, new String[]{FileSourcedConverter.class.getName(), URLSourcedLoader.class.getName()});
        }
        if (m_FileSavers.size() == 0) {
            classnames = PluginManager.getPluginNamesOfTypeList(AbstractFileSaver.class.getName());
            m_FileSavers = classnames.size() > 0 ? ConverterResources.getFileConverters(classnames, new String[]{FileSourcedConverter.class.getName()}) : ConverterResources.getFileConverters(CORE_FILE_SAVERS, new String[]{FileSourcedConverter.class.getName()});
        }
    }

    protected static Hashtable<String, List<String>> getFileConverters(String classnames, String[] intf) {
        Vector<String> list = new Vector<String>();
        String[] names = classnames.split(",");
        for (int i = 0; i < names.length; ++i) {
            list.add(names[i]);
        }
        return ConverterResources.getFileConverters(list, intf);
    }

    protected static Hashtable<String, List<String>> getFileConverters(List<String> classnames, String[] intf) {
        Hashtable<String, List<String>> result = new Hashtable<String, List<String>>();
        for (int i = 0; i < classnames.size(); ++i) {
            String[] ext;
            FileSourcedConverter converter;
            Class<?> cls;
            int n;
            String classname = classnames.get(i);
            for (n = 0; n < intf.length; ++n) {
                if (InheritanceUtils.hasInterface(intf[n], classname)) continue;
            }
            try {
                cls = WekaPackageClassLoaderManager.forName(classname);
                converter = (FileSourcedConverter)cls.newInstance();
                ext = converter.getFileExtensions();
            }
            catch (Exception e2) {
                cls = null;
                converter = null;
                ext = new String[]{};
            }
            if (converter == null) continue;
            for (n = 0; n < ext.length; ++n) {
                if (!result.containsKey(ext[n])) {
                    result.put(ext[n], new ArrayList());
                }
                result.get(ext[n]).add(classname);
            }
        }
        return result;
    }
}

