/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.StreamTokenizerUtils;

public class C45Loader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter {
    static final long serialVersionUID = 5454329403218219L;
    public static String FILE_EXTENSION = ".names";
    private File m_sourceFileData = null;
    private transient Reader m_namesReader = null;
    private transient Reader m_dataReader = null;
    private String m_fileStem;
    private int m_numAttribs;
    private boolean[] m_ignore;

    public String globalInfo() {
        return "Reads a file that is C45 format. Can take a filestem or filestem with .names or .data appended. Assumes that path/<filestem>.names and path/<filestem>.data exist and contain the names and data respectively.";
    }

    @Override
    public void reset() throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        }
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{".names", ".data"};
    }

    @Override
    public String getFileDescription() {
        return "C4.5 data files";
    }

    @Override
    public void setSource(File file) throws IOException {
        BufferedReader br;
        String fileStem;
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        String fname = file.getName();
        String path = file.getParent();
        path = path != null ? path + File.separator : "";
        if (fname.indexOf(46) < 0) {
            fileStem = fname;
            fname = fname + ".names";
        } else {
            fileStem = fname.substring(0, fname.lastIndexOf(46));
            fname = fileStem + ".names";
        }
        this.m_fileStem = fileStem;
        this.m_sourceFile = file = new File(path + fname);
        try {
            br = new BufferedReader(new FileReader(file));
            this.m_namesReader = br;
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File not found : " + path + fname);
        }
        this.m_sourceFileData = new File(path + fileStem + ".data");
        try {
            br = new BufferedReader(new FileReader(this.m_sourceFileData));
            this.m_dataReader = br;
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File not found : " + path + fname);
        }
        this.m_File = file.getAbsolutePath();
    }

    @Override
    public Instances getStructure() throws IOException {
        if (this.m_sourceFile == null) {
            throw new IOException("No source has beenspecified");
        }
        if (this.m_structure == null) {
            this.setSource(this.m_sourceFile);
            StreamTokenizer st = new StreamTokenizer(this.m_namesReader);
            this.initTokenizer(st);
            this.readHeader(st);
        }
        return this.m_structure;
    }

    @Override
    public Instances getDataSet() throws IOException {
        if (this.m_sourceFile == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        StreamTokenizer st = new StreamTokenizer(this.m_dataReader);
        this.initTokenizer(st);
        Instances result = new Instances(this.m_structure);
        Instance current = this.getInstance(st);
        while (current != null) {
            result.add(current);
            current = this.getInstance(st);
        }
        try {
            this.m_dataReader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        if (this.m_sourceFile == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(2);
        if (this.m_structure == null) {
            this.getStructure();
        }
        StreamTokenizer st = new StreamTokenizer(this.m_dataReader);
        this.initTokenizer(st);
        Instance nextI = this.getInstance(st);
        if (nextI != null) {
            nextI.setDataset(this.m_structure);
        } else {
            try {
                this.m_dataReader.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return nextI;
    }

    private Instance getInstance(StreamTokenizer tokenizer) throws IOException {
        double[] instance = new double[this.m_structure.numAttributes()];
        StreamTokenizerUtils.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            return null;
        }
        int counter = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i > 0) {
                StreamTokenizerUtils.getToken(tokenizer);
            }
            if (this.m_ignore[i]) continue;
            if (tokenizer.ttype == 63) {
                instance[counter++] = Utils.missingValue();
                continue;
            }
            String val = tokenizer.sval;
            if (i == this.m_numAttribs - 1 && val.charAt(val.length() - 1) == '.') {
                val = val.substring(0, val.length() - 1);
            }
            if (this.m_structure.attribute(counter).isNominal()) {
                int index = this.m_structure.attribute(counter).indexOfValue(val);
                if (index == -1) {
                    StreamTokenizerUtils.errms(tokenizer, "nominal value not declared in header :" + val + " column " + i);
                }
                instance[counter++] = index;
                continue;
            }
            if (this.m_structure.attribute(counter).isNumeric()) {
                try {
                    instance[counter++] = Double.valueOf(val);
                }
                catch (NumberFormatException e2) {
                    StreamTokenizerUtils.errms(tokenizer, "number expected");
                }
                continue;
            }
            System.err.println("Shouldn't get here");
            System.exit(1);
        }
        return new DenseInstance(1.0, instance);
    }

    private String removeTrailingPeriod(String val) {
        if (val.charAt(val.length() - 1) == '.') {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }

    private void readHeader(StreamTokenizer tokenizer) throws IOException {
        ArrayList<Attribute> attribDefs = new ArrayList<Attribute>();
        ArrayList<Integer> ignores = new ArrayList<Integer>();
        StreamTokenizerUtils.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            StreamTokenizerUtils.errms(tokenizer, "premature end of file");
        }
        this.m_numAttribs = 1;
        ArrayList<String> classVals = new ArrayList<String>();
        while (tokenizer.ttype != 10) {
            String val = tokenizer.sval.trim();
            if (val.length() > 0) {
                val = this.removeTrailingPeriod(val);
                classVals.add(val);
            }
            StreamTokenizerUtils.getToken(tokenizer);
        }
        int counter = 0;
        while (tokenizer.ttype != -1) {
            String temp;
            StreamTokenizerUtils.getFirstToken(tokenizer);
            if (tokenizer.ttype == -1) continue;
            String attribName = tokenizer.sval;
            StreamTokenizerUtils.getToken(tokenizer);
            if (tokenizer.ttype == 10) {
                StreamTokenizerUtils.errms(tokenizer, "premature end of line. Expected attribute type.");
            }
            if ((temp = tokenizer.sval.toLowerCase().trim()).startsWith("ignore") || temp.startsWith("label")) {
                ignores.add(new Integer(counter));
                ++counter;
                continue;
            }
            if (temp.startsWith("continuous")) {
                attribDefs.add(new Attribute(attribName));
                ++counter;
                continue;
            }
            ++counter;
            ArrayList<String> attribVals = new ArrayList<String>();
            while (tokenizer.ttype != 10 && tokenizer.ttype != -1) {
                String val = tokenizer.sval.trim();
                if (val.length() > 0) {
                    val = this.removeTrailingPeriod(val);
                    attribVals.add(val);
                }
                StreamTokenizerUtils.getToken(tokenizer);
            }
            attribDefs.add(new Attribute(attribName, attribVals));
        }
        boolean ok = true;
        int i = -1;
        if (classVals.size() == 1) {
            for (i = 0; i < attribDefs.size(); ++i) {
                if (((Attribute)attribDefs.get(i)).name().compareTo(classVals.get(0)) != 0) continue;
                ok = false;
                --this.m_numAttribs;
                break;
            }
        }
        if (ok) {
            attribDefs.add(new Attribute("Class", classVals));
        }
        this.m_structure = new Instances(this.m_fileStem, attribDefs, 0);
        try {
            if (ok) {
                this.m_structure.setClassIndex(this.m_structure.numAttributes() - 1);
            } else {
                this.m_structure.setClassIndex(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_numAttribs = this.m_structure.numAttributes() + ignores.size();
        this.m_ignore = new boolean[this.m_numAttribs];
        for (i = 0; i < ignores.size(); ++i) {
            this.m_ignore[((Integer)ignores.get((int)i)).intValue()] = true;
        }
    }

    private void initTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 31);
        tokenizer.wordChars(32, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.whitespaceChars(58, 58);
        tokenizer.commentChar(124);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.eolIsSignificant(true);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9290 $");
    }

    public static void main(String[] args) {
        C45Loader.runFileLoader(new C45Loader(), args);
    }
}

