/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import weka.core.Environment;
import weka.core.Version;
import weka.core.WekaPackageLibIsolatingClassLoader;

public class WekaPackageClassLoaderManager {
    protected static final WekaPackageClassLoaderManager s_singletonLoader = new WekaPackageClassLoaderManager();
    protected Map<String, WekaPackageLibIsolatingClassLoader> m_packageJarClassLoaders = new HashMap<String, WekaPackageLibIsolatingClassLoader>();
    protected Map<String, WekaPackageLibIsolatingClassLoader> m_classBasedClassLoaderLookup = new HashMap<String, WekaPackageLibIsolatingClassLoader>();
    protected File m_pathToWekaJarFile;

    private WekaPackageClassLoaderManager() {
    }

    protected void injectMTJCoreClasses() {
        if (!WekaPackageClassLoaderManager.classExists("com.github.fommil.netlib.ARPACK")) {
            String debugS = System.getProperty("weka.core.classloader.debug", "false");
            boolean debug2 = debugS.equalsIgnoreCase("true");
            InputStream mtjCoreInputStream = this.getClass().getClassLoader().getResourceAsStream("core.jar");
            InputStream arpackAllInputStream = this.getClass().getClassLoader().getResourceAsStream("arpack_combined.jar");
            InputStream mtjInputStream = this.getClass().getClassLoader().getResourceAsStream("mtj.jar");
            if (mtjCoreInputStream != null && arpackAllInputStream != null && mtjInputStream != null) {
                if (debug2) {
                    System.out.println("[WekaPackageClassLoaderManager] injecting mtj-related core classes into root classloader");
                }
                try {
                    if (debug2) {
                        System.out.println("[WekaPackageClassLoaderManager] Injecting arpack");
                    }
                    WekaPackageClassLoaderManager.injectAllClassesInFromStream(arpackAllInputStream);
                    if (debug2) {
                        System.out.println("[WekaPackageClassLoaderManager] Injecting mtj core");
                    }
                    WekaPackageClassLoaderManager.injectAllClassesInFromStream(mtjCoreInputStream);
                    if (debug2) {
                        System.out.println("[WekaPackageClassLoaderManager] Injecting mtj");
                    }
                    WekaPackageClassLoaderManager.injectAllClassesInFromStream(mtjInputStream);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                System.out.println("WARNING: core mtj jar files are not available as resources to this classloader (" + WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getClass().getClassLoader() + ")");
            }
        }
    }

    public static WekaPackageClassLoaderManager getWekaPackageClassLoaderManager() {
        return s_singletonLoader;
    }

    public static Object objectForName(String className) throws Exception {
        return WekaPackageClassLoaderManager.forName(className).newInstance();
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return WekaPackageClassLoaderManager.forName(className, true);
    }

    public static Class<?> forName(String className, boolean initialize) throws ClassNotFoundException {
        WekaPackageClassLoaderManager cl = WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager();
        ClassLoader toUse = cl.getLoaderForClass(className);
        return Class.forName(className, initialize, toUse);
    }

    public File getPathToWekaJarFile() {
        return this.m_pathToWekaJarFile;
    }

    public URL[] getWekaClassloaderClasspathEntries() {
        ClassLoader parent = this.getClass().getClassLoader();
        if (parent instanceof URLClassLoader) {
            URL[] result;
            for (URL u : result = ((URLClassLoader)parent).getURLs()) {
                if (!u.toString().endsWith("weka.jar")) continue;
                try {
                    this.m_pathToWekaJarFile = new File(u.toURI());
                }
                catch (URISyntaxException e2) {
                    e2.printStackTrace();
                }
            }
            return result;
        }
        if (ClassLoader.getSystemClassLoader().equals(this.getClass().getClassLoader())) {
            return this.getSystemClasspathEntries();
        }
        return this.getWekaClasspathEntries();
    }

    public Set<String> getPackageJarFileClasses() {
        return this.m_classBasedClassLoaderLookup.keySet();
    }

    private URL[] getSystemClasspathEntries() {
        String cp = System.getProperty("java.class.path", "");
        String sep = System.getProperty("path.separator", ":");
        return this.getParts(cp, sep);
    }

    private URL[] getWekaClasspathEntries() {
        String wekaCp = Environment.getSystemWide().getVariableValue("WEKA_CLASSPATH");
        String sep = System.getProperty("path.separator", ":");
        if (wekaCp != null) {
            return this.getParts(wekaCp, sep);
        }
        return new URL[0];
    }

    private URL[] getParts(String cp, String sep) {
        String[] cpParts = cp.split(sep);
        ArrayList<URL> uList = new ArrayList<URL>();
        for (String part : cpParts) {
            try {
                URL url;
                if (part.startsWith("file:")) {
                    part = part.replace(" ", "%20");
                    url = new URI(part).toURL();
                } else {
                    url = new File(part).toURI().toURL();
                    uList.add(url);
                }
                if (!part.endsWith("weka.jar")) continue;
                this.m_pathToWekaJarFile = new File(url.toURI());
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
            catch (URISyntaxException e3) {
                e3.printStackTrace();
            }
        }
        return uList.toArray(new URL[uList.size()]);
    }

    public synchronized void removeClassLoaderForPackage(String packageName) {
        WekaPackageLibIsolatingClassLoader loader = this.m_packageJarClassLoaders.get(packageName);
        if (loader != null) {
            loader.closeClassLoader();
            this.m_packageJarClassLoaders.remove(packageName);
        }
    }

    public synchronized ClassLoader addPackageToClassLoader(File packageDir) throws Exception {
        if (this.m_packageJarClassLoaders.containsKey(packageDir.getName())) {
            this.m_packageJarClassLoaders.get(packageDir.getName()).closeClassLoader();
        }
        WekaPackageLibIsolatingClassLoader packageLoader = new WekaPackageLibIsolatingClassLoader(this, packageDir);
        this.m_packageJarClassLoaders.put(packageDir.getName(), packageLoader);
        Set<String> classes = packageLoader.getPackageJarEntries();
        for (String c : classes) {
            this.m_classBasedClassLoaderLookup.put(c, packageLoader);
        }
        return packageLoader;
    }

    public ClassLoader getLoaderForClass(String className) {
        className = className.replace("[L", "").replace("[", "").replace(";", "");
        ClassLoader result = this.getClass().getClassLoader();
        try {
            Class<?> cl = this.findClass(className);
            return cl.getClassLoader();
        }
        catch (Exception exception) {
            result = this.m_classBasedClassLoaderLookup.get(className);
            if (result == null) {
                result = this.getClass().getClassLoader();
            }
            return result;
        }
    }

    public WekaPackageLibIsolatingClassLoader getPackageClassLoader(String packageName) {
        return this.m_packageJarClassLoaders.get(packageName);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            result = this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (result == null) {
            Map.Entry<String, WekaPackageLibIsolatingClassLoader> e2;
            Iterator<Map.Entry<String, WekaPackageLibIsolatingClassLoader>> iterator = this.m_packageJarClassLoaders.entrySet().iterator();
            while (iterator.hasNext() && (result = (e2 = iterator.next()).getValue().findGloballyVisiblePackageClass(name)) == null) {
            }
        }
        if (result == null) {
            throw new ClassNotFoundException("Unable to find class '" + name + "'");
        }
        return result;
    }

    public URL findResource(String name) {
        URL result;
        block1: {
            Map.Entry<String, WekaPackageLibIsolatingClassLoader> e2;
            result = null;
            result = this.getClass().getClassLoader().getResource(name);
            if (result != null) break block1;
            Iterator<Map.Entry<String, WekaPackageLibIsolatingClassLoader>> iterator = this.m_packageJarClassLoaders.entrySet().iterator();
            while (iterator.hasNext() && (result = (e2 = iterator.next()).getValue().findGloballyVisiblePackageResource(name)) == null) {
            }
        }
        return result;
    }

    public ClassLoader findClassloaderForResource(String name) {
        ClassLoader result = null;
        if (this.getClass().getClassLoader().getResource(name) != null) {
            result = this.getClass().getClassLoader();
        } else {
            for (Map.Entry<String, WekaPackageLibIsolatingClassLoader> e2 : this.m_packageJarClassLoaders.entrySet()) {
                if (e2.getValue().findGloballyVisiblePackageResource(name) == null) continue;
                result = e2.getValue();
            }
        }
        return result;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> result = null;
        try {
            result = this.getClass().getClassLoader().getResources(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            for (Map.Entry<String, WekaPackageLibIsolatingClassLoader> e2 : this.m_packageJarClassLoaders.entrySet()) {
                try {
                    result = e2.getValue().findGloballyVisiblePackageResources(name);
                    if (result == null) continue;
                    break;
                }
                catch (IOException iOException) {
                }
            }
        }
        return result;
    }

    protected Class<?> findClass(String packageName, String className) {
        Class<?> result = null;
        WekaPackageLibIsolatingClassLoader toTry = this.getPackageClassLoader(packageName);
        if (toTry != null) {
            try {
                result = toTry.findClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    protected URL findResource(String packageName, String name) {
        URL result = null;
        WekaPackageLibIsolatingClassLoader toTry = this.getPackageClassLoader(packageName);
        if (toTry != null) {
            result = toTry.getResource(name);
        }
        return result;
    }

    protected Enumeration<URL> findResources(String packageName, String name) {
        Enumeration<URL> result = null;
        WekaPackageLibIsolatingClassLoader toTry = this.getPackageClassLoader(packageName);
        if (toTry != null) {
            try {
                result = toTry.getResources(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    protected static boolean classExists(String className) {
        boolean result = false;
        try {
            Class<?> cls = Class.forName(className);
            result = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return result;
    }

    protected static void injectAllClassesInJar(File jarPath, boolean injectToRootClassLoader) throws Exception {
        WekaPackageClassLoaderManager.injectClasses(jarPath, null, null, injectToRootClassLoader);
    }

    protected static void injectAllClassesInJar(File jarPath) throws Exception {
        WekaPackageClassLoaderManager.injectAllClassesInJar(jarPath, true);
    }

    protected static void injectAllClassesInFromStream(InputStream inStream) throws Exception {
        WekaPackageClassLoaderManager.injectClasses(new BufferedInputStream(inStream), null, null, true);
    }

    protected static void injectClasses(File jarPath, List<String> classJarPaths, List<String> classes, boolean injectToRootClassLoader) throws Exception {
        if (!jarPath.exists()) {
            System.err.println("Path for jar file to inject '" + jarPath.toString() + "' does not seem to exist - skipping");
            return;
        }
        FileInputStream inStream = new FileInputStream(jarPath);
        WekaPackageClassLoaderManager.injectClasses(inStream, classJarPaths, classes, injectToRootClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void injectClasses(InputStream jarStream, List<String> classJarPaths, List<String> classes, boolean injectToRootClassLoader) throws Exception {
        boolean processAllClasses;
        String debugS = System.getProperty("weka.core.classloader.debug", "false");
        boolean debug2 = debugS.equalsIgnoreCase("true");
        boolean bl = processAllClasses = classes == null || classJarPaths == null;
        if (processAllClasses) {
            classes = new ArrayList<String>();
            classJarPaths = new ArrayList<String>();
        }
        ArrayList<byte[]> preloadClassByteCode = new ArrayList<byte[]>();
        ZipInputStream zi = new ZipInputStream(jarStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zi.getNextEntry()) != null) {
            String zipPart;
            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class") || !classJarPaths.contains(zipPart = zipEntry.getName().replace("\\", "/")) && !processAllClasses) continue;
            preloadClassByteCode.add(WekaPackageClassLoaderManager.getByteCode(zi, false));
            zi.closeEntry();
            if (!processAllClasses) continue;
            classes.add(zipEntry.getName().replace(".class", "").replace("\\", "/").replace("/", "."));
        }
        zi.close();
        ArrayList okBytes = new ArrayList();
        ArrayList<String> okClasses = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            if (WekaPackageClassLoaderManager.classExists(classes.get(i))) continue;
            okClasses.add(classes.get(i));
            okBytes.add(preloadClassByteCode.get(i));
        }
        preloadClassByteCode = okBytes;
        classes = okClasses;
        if (preloadClassByteCode.size() > 0) {
            ClassLoader rootClassloader = injectToRootClassLoader ? WekaPackageClassLoaderManager.getRootClassLoader() : WekaPackageClassLoaderManager.getWekaLevelClassloader();
            Class<?> classLoader = Class.forName("java.lang.ClassLoader");
            Method defineClass = classLoader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            ProtectionDomain pd = System.class.getProtectionDomain();
            defineClass.setAccessible(true);
            ArrayList<byte[]> failedToInject = new ArrayList<byte[]>();
            ArrayList<String> classesF = new ArrayList<String>();
            boolean cont = true;
            int numLeft = classes.size();
            try {
                do {
                    if (debug2) {
                        System.out.println("[WekaPackageClassLoaderManager] Injecting classes into the " + (injectToRootClassLoader ? "root classloader..." : "weka-level classloader..."));
                    }
                    for (int i = 0; i < classes.size(); ++i) {
                        if (debug2) {
                            System.out.println("** Injecting " + classes.get(i));
                        }
                        byte[] b = (byte[])preloadClassByteCode.get(i);
                        try {
                            defineClass.invoke((Object)rootClassloader, classes.get(i), b, 0, b.length, pd);
                            continue;
                        }
                        catch (Exception ex) {
                            failedToInject.add(b);
                            classesF.add(classes.get(i));
                        }
                    }
                    cont = failedToInject.size() < numLeft;
                    preloadClassByteCode = failedToInject;
                    classes = classesF;
                    numLeft = failedToInject.size();
                    failedToInject = new ArrayList();
                    classesF = new ArrayList();
                } while (classes.size() > 0 && cont);
            }
            finally {
                defineClass.setAccessible(false);
            }
        }
    }

    private static byte[] getByteCode(InputStream in) throws IOException {
        return WekaPackageClassLoaderManager.getByteCode(in, true);
    }

    private static byte[] getByteCode(InputStream in, boolean closeInput) throws IOException {
        int readLength;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream byteCodeBuf = new ByteArrayOutputStream();
        while ((readLength = in.read(buf)) != -1) {
            byteCodeBuf.write(buf, 0, readLength);
        }
        if (closeInput) {
            in.close();
        }
        return byteCodeBuf.toByteArray();
    }

    private static ClassLoader getRootClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while (cl.getParent() != null) {
            cl = cl.getParent();
        }
        return cl;
    }

    private static ClassLoader getWekaLevelClassloader() {
        return Version.class.getClassLoader();
    }

    protected void performIntegrityCheck() {
        ArrayList<String> problems = new ArrayList<String>();
        for (Map.Entry<String, WekaPackageLibIsolatingClassLoader> e2 : this.m_packageJarClassLoaders.entrySet()) {
            String packageName = e2.getKey();
            WekaPackageLibIsolatingClassLoader child = e2.getValue();
            try {
                if (child.integrityCheck()) continue;
                problems.add(packageName);
            }
            catch (Exception ex) {
                problems.add(packageName);
            }
        }
        ArrayList<String> classKeys = new ArrayList<String>();
        for (String p : problems) {
            System.err.println("[Weka] Integrity: removing classloader for: " + p);
            this.m_packageJarClassLoaders.remove(p);
            for (Map.Entry<String, WekaPackageLibIsolatingClassLoader> e3 : this.m_classBasedClassLoaderLookup.entrySet()) {
                if (!e3.getValue().getPackageName().equals(p)) continue;
                classKeys.add(e3.getKey());
            }
            for (String k : classKeys) {
                this.m_classBasedClassLoaderLookup.remove(k);
            }
        }
    }
}

