/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.CommandlineRunnable;
import weka.core.InheritanceUtils;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;

public class FindWithCapabilities
implements OptionHandler,
CapabilitiesHandler,
RevisionHandler,
CommandlineRunnable {
    protected Capabilities m_Capabilities = new Capabilities(this);
    protected Capabilities m_NotCapabilities = new Capabilities(this);
    protected Vector<String> m_Packages = new Vector();
    protected CapabilitiesHandler m_Handler = null;
    protected String m_Filename = "";
    protected SingleIndex m_ClassIndex = new SingleIndex();
    protected String m_Superclass = "";
    protected boolean m_GenericPropertiesCreator = false;
    protected Vector<String> m_Matches = new Vector();
    protected Vector<String> m_Misses = new Vector();
    protected boolean m_DoNotCheckCapabilities = false;

    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("", "", 0, "All class and attribute options can be prefixed with 'not',\ne.g., '-not-numeric-class'. This makes sure that the returned\nschemes 'cannot' handle numeric classes."));
        result.addElement(new Option("\tThe minimum number of instances (default 1).", "num-instances", 1, "-num-instances <num>"));
        result.addElement(new Option("\tMust handle unray classes.", "unary-class", 0, "-unary-class"));
        result.addElement(new Option("\tMust handle binary classes.", "binary-class", 0, "-binary-class"));
        result.addElement(new Option("\tMust handle nominal classes.", "nominal-class", 0, "-nominal-class"));
        result.addElement(new Option("\tMust handle numeric classes.", "numeric-class", 0, "-numeric-class"));
        result.addElement(new Option("\tMust handle string classes.", "string-class", 0, "-string-class"));
        result.addElement(new Option("\tMust handle date classes.", "date-class", 0, "-date-class"));
        result.addElement(new Option("\tMust handle relational classes.", "relational-class", 0, "-relational-class"));
        result.addElement(new Option("\tMust handle missing class values.", "missing-class-values", 0, "-missing-class-values"));
        result.addElement(new Option("\tDoesn't need a class.", "no-class", 0, "-no-class"));
        result.addElement(new Option("\tMust handle unary attributes.", "unary-atts", 0, "-unary-atts"));
        result.addElement(new Option("\tMust handle binary attributes.", "binary-atts", 0, "-binary-atts"));
        result.addElement(new Option("\tMust handle nominal attributes.", "nominal-atts", 0, "-nominal-atts"));
        result.addElement(new Option("\tMust handle numeric attributes.", "numeric-atts", 0, "-numeric-atts"));
        result.addElement(new Option("\tMust handle string attributes.", "string-atts", 0, "-string-atts"));
        result.addElement(new Option("\tMust handle date attributes.", "date-atts", 0, "-date-atts"));
        result.addElement(new Option("\tMust handle relational attributes.", "relational-atts", 0, "-relational-atts"));
        result.addElement(new Option("\tMust handle missing attribute values.", "missing-att-values", 0, "-missing-att-values"));
        result.addElement(new Option("\tMust handle multi-instance data.", "only-multiinstance", 0, "-only-multiinstance"));
        result.addElement(new Option("\tThe Capabilities handler to base the handling on.\n\tThe other parameters can be used to override the ones\n\tdetermined from the handler. Additional parameters for\n\thandler can be passed on after the '--'.\n\tEither '-W' or '-t' can be used.", "W", 1, "-W <classname>"));
        result.addElement(new Option("\tThe dataset to base the capabilities on.\n\tThe other parameters can be used to override the ones\n\tdetermined from the handler.\n\tEither '-t' or '-W' can be used.", "t", 1, "-t <file>"));
        result.addElement(new Option("\tThe index of the class attribute, -1 for none.\n\t'first' and 'last' are also valid.\n\tOnly in conjunction with option '-t'.", "c", 1, "-c <num>"));
        result.addElement(new Option("\tSuperclass to look for in the packages.\n", "superclass", 1, "-superclass"));
        result.addElement(new Option("\tComma-separated list of packages to search in.", "packages", 1, "-packages"));
        result.addElement(new Option("\tRetrieves the package list from the GenericPropertiesCreator\n\tfor the given superclass. (overrides -packages <list>).", "generic", 1, "-generic"));
        result.addElement(new Option("\tAlso prints the classname that didn't match the criteria.", "misses", 0, "-misses"));
        return result.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setOptions(String[] options) throws Exception {
        StringTokenizer tok;
        this.m_Capabilities = new Capabilities(this);
        boolean initialized = false;
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() != 0) {
            Class<?> cls = Class.forName(tmpStr);
            if (!InheritanceUtils.hasInterface(CapabilitiesHandler.class, cls)) throw new IllegalArgumentException("Class '" + tmpStr + "' is not a CapabilitiesHandler!");
            initialized = true;
            CapabilitiesHandler handler = (CapabilitiesHandler)cls.newInstance();
            if (handler instanceof OptionHandler) {
                ((OptionHandler)((Object)handler)).setOptions(Utils.partitionOptions(options));
            }
            this.setHandler(handler);
        } else {
            tmpStr = Utils.getOption('c', options);
            if (tmpStr.length() != 0) {
                this.setClassIndex(tmpStr);
            } else {
                this.setClassIndex("last");
            }
            tmpStr = Utils.getOption('t', options);
            this.setFilename(tmpStr);
        }
        tmpStr = Utils.getOption("num-instances", options);
        if (tmpStr.length() != 0) {
            this.m_Capabilities.setMinimumNumberInstances(Integer.parseInt(tmpStr));
        } else if (!initialized) {
            this.m_Capabilities.setMinimumNumberInstances(1);
        }
        if (Utils.getFlag("no-class", options)) {
            this.enable(Capabilities.Capability.NO_CLASS);
        }
        if (Utils.getFlag("not-no-class", options)) {
            this.enableNot(Capabilities.Capability.NO_CLASS);
        }
        if (!this.m_Capabilities.handles(Capabilities.Capability.NO_CLASS)) {
            if (Utils.getFlag("nominal-class", options)) {
                this.enable(Capabilities.Capability.NOMINAL_CLASS);
                this.disable(Capabilities.Capability.BINARY_CLASS);
            }
            if (Utils.getFlag("binary-class", options)) {
                this.enable(Capabilities.Capability.BINARY_CLASS);
                this.disable(Capabilities.Capability.UNARY_CLASS);
            }
            if (Utils.getFlag("unary-class", options)) {
                this.enable(Capabilities.Capability.UNARY_CLASS);
            }
            if (Utils.getFlag("numeric-class", options)) {
                this.enable(Capabilities.Capability.NUMERIC_CLASS);
            }
            if (Utils.getFlag("string-class", options)) {
                this.enable(Capabilities.Capability.STRING_CLASS);
            }
            if (Utils.getFlag("date-class", options)) {
                this.enable(Capabilities.Capability.DATE_CLASS);
            }
            if (Utils.getFlag("relational-class", options)) {
                this.enable(Capabilities.Capability.RELATIONAL_CLASS);
            }
            if (Utils.getFlag("missing-class-values", options)) {
                this.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
            }
        }
        if (Utils.getFlag("not-nominal-class", options)) {
            this.enableNot(Capabilities.Capability.NOMINAL_CLASS);
            this.disableNot(Capabilities.Capability.BINARY_CLASS);
        }
        if (Utils.getFlag("not-binary-class", options)) {
            this.enableNot(Capabilities.Capability.BINARY_CLASS);
            this.disableNot(Capabilities.Capability.UNARY_CLASS);
        }
        if (Utils.getFlag("not-unary-class", options)) {
            this.enableNot(Capabilities.Capability.UNARY_CLASS);
        }
        if (Utils.getFlag("not-numeric-class", options)) {
            this.enableNot(Capabilities.Capability.NUMERIC_CLASS);
        }
        if (Utils.getFlag("not-string-class", options)) {
            this.enableNot(Capabilities.Capability.STRING_CLASS);
        }
        if (Utils.getFlag("not-date-class", options)) {
            this.enableNot(Capabilities.Capability.DATE_CLASS);
        }
        if (Utils.getFlag("not-relational-class", options)) {
            this.enableNot(Capabilities.Capability.RELATIONAL_CLASS);
        }
        if (Utils.getFlag("not-relational-class", options)) {
            this.enableNot(Capabilities.Capability.RELATIONAL_CLASS);
        }
        if (Utils.getFlag("not-missing-class-values", options)) {
            this.enableNot(Capabilities.Capability.MISSING_CLASS_VALUES);
        }
        if (Utils.getFlag("nominal-atts", options)) {
            this.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
            this.disable(Capabilities.Capability.BINARY_ATTRIBUTES);
        }
        if (Utils.getFlag("binary-atts", options)) {
            this.enable(Capabilities.Capability.BINARY_ATTRIBUTES);
            this.disable(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("unary-atts", options)) {
            this.enable(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("numeric-atts", options)) {
            this.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        }
        if (Utils.getFlag("string-atts", options)) {
            this.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        }
        if (Utils.getFlag("date-atts", options)) {
            this.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        }
        if (Utils.getFlag("relational-atts", options)) {
            this.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        }
        if (Utils.getFlag("missing-att-values", options)) {
            this.enable(Capabilities.Capability.MISSING_VALUES);
        }
        if (Utils.getFlag("not-nominal-atts", options)) {
            this.enableNot(Capabilities.Capability.NOMINAL_ATTRIBUTES);
            this.disableNot(Capabilities.Capability.BINARY_ATTRIBUTES);
        }
        if (Utils.getFlag("not-binary-atts", options)) {
            this.enableNot(Capabilities.Capability.BINARY_ATTRIBUTES);
            this.disableNot(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("not-unary-atts", options)) {
            this.enableNot(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("not-numeric-atts", options)) {
            this.enableNot(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        }
        if (Utils.getFlag("not-string-atts", options)) {
            this.enableNot(Capabilities.Capability.STRING_ATTRIBUTES);
        }
        if (Utils.getFlag("not-date-atts", options)) {
            this.enableNot(Capabilities.Capability.DATE_ATTRIBUTES);
        }
        if (Utils.getFlag("not-relational-atts", options)) {
            this.enableNot(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        }
        if (Utils.getFlag("not-missing-att-values", options)) {
            this.enableNot(Capabilities.Capability.MISSING_VALUES);
        }
        if (Utils.getFlag("only-multiinstance", options)) {
            this.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        }
        if ((tmpStr = Utils.getOption("superclass", options)).length() == 0) {
            throw new IllegalArgumentException("A superclass has to be specified!");
        }
        this.m_Superclass = tmpStr;
        tmpStr = Utils.getOption("packages", options);
        if (tmpStr.length() != 0) {
            tok = new StringTokenizer(tmpStr, ",");
            this.m_Packages = new Vector();
            while (tok.hasMoreTokens()) {
                this.m_Packages.add(tok.nextToken());
            }
        }
        if (!Utils.getFlag("generic", options)) return;
        GenericPropertiesCreator creator = new GenericPropertiesCreator();
        creator.execute(false);
        Properties props = creator.getInputProperties();
        tok = new StringTokenizer(props.getProperty(this.m_Superclass), ",");
        this.m_Packages = new Vector();
        while (tok.hasMoreTokens()) {
            this.m_Packages.add(tok.nextToken());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-num-instances");
        result.add("" + this.m_Capabilities.getMinimumNumberInstances());
        if (this.isEnabled(Capabilities.Capability.NO_CLASS)) {
            result.add("-no-class");
        } else {
            if (this.isEnabled(Capabilities.Capability.UNARY_CLASS)) {
                result.add("-unary-class");
            }
            if (this.isEnabled(Capabilities.Capability.BINARY_CLASS)) {
                result.add("-binary-class");
            }
            if (this.isEnabled(Capabilities.Capability.NOMINAL_CLASS)) {
                result.add("-nominal-class");
            }
            if (this.isEnabled(Capabilities.Capability.NUMERIC_CLASS)) {
                result.add("-numeric-class");
            }
            if (this.isEnabled(Capabilities.Capability.STRING_CLASS)) {
                result.add("-string-class");
            }
            if (this.isEnabled(Capabilities.Capability.DATE_CLASS)) {
                result.add("-date-class");
            }
            if (this.isEnabled(Capabilities.Capability.RELATIONAL_CLASS)) {
                result.add("-relational-class");
            }
            if (this.isEnabled(Capabilities.Capability.MISSING_CLASS_VALUES)) {
                result.add("-missing-class-values");
            }
        }
        if (this.isEnabled(Capabilities.Capability.UNARY_ATTRIBUTES)) {
            result.add("-unary-atts");
        }
        if (this.isEnabled(Capabilities.Capability.BINARY_ATTRIBUTES)) {
            result.add("-binary-atts");
        }
        if (this.isEnabled(Capabilities.Capability.NOMINAL_ATTRIBUTES)) {
            result.add("-nominal-atts");
        }
        if (this.isEnabled(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.add("-numeric-atts");
        }
        if (this.isEnabled(Capabilities.Capability.STRING_ATTRIBUTES)) {
            result.add("-string-atts");
        }
        if (this.isEnabled(Capabilities.Capability.DATE_ATTRIBUTES)) {
            result.add("-date-atts");
        }
        if (this.isEnabled(Capabilities.Capability.RELATIONAL_ATTRIBUTES)) {
            result.add("-relational-atts");
        }
        if (this.isEnabled(Capabilities.Capability.MISSING_VALUES)) {
            result.add("-missing-att-values");
        }
        if (this.isEnabledNot(Capabilities.Capability.NO_CLASS)) {
            result.add("-not-no-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.UNARY_CLASS)) {
            result.add("-not-unary-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.BINARY_CLASS)) {
            result.add("-not-binary-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.NOMINAL_CLASS)) {
            result.add("-not-nominal-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.NUMERIC_CLASS)) {
            result.add("-not-numeric-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.STRING_CLASS)) {
            result.add("-not-string-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.DATE_CLASS)) {
            result.add("-not-date-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.RELATIONAL_CLASS)) {
            result.add("-not-relational-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.MISSING_CLASS_VALUES)) {
            result.add("-not-missing-class-values");
        }
        if (this.isEnabledNot(Capabilities.Capability.UNARY_ATTRIBUTES)) {
            result.add("-not-unary-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.BINARY_ATTRIBUTES)) {
            result.add("-not-binary-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.NOMINAL_ATTRIBUTES)) {
            result.add("-not-nominal-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.add("-not-numeric-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.STRING_ATTRIBUTES)) {
            result.add("-not-string-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.DATE_ATTRIBUTES)) {
            result.add("-not-date-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.RELATIONAL_ATTRIBUTES)) {
            result.add("-not-relational-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.MISSING_VALUES)) {
            result.add("-not-missing-att-values");
        }
        if (this.isEnabled(Capabilities.Capability.ONLY_MULTIINSTANCE)) {
            result.add("-only-multi-instance");
        }
        if (this.getHandler() != null) {
            result.add("-W");
            result.add(this.getHandler().getClass().getName());
            if (this.getHandler() instanceof OptionHandler) {
                result.add("--");
                String[] options = ((OptionHandler)((Object)this.getHandler())).getOptions();
                for (int i = 0; i < options.length; ++i) {
                    result.add(options[i]);
                }
            }
        } else if (this.getFilename().length() != 0) {
            result.add("-t");
            result.add(this.getFilename());
            result.add("-c");
            result.add(this.m_ClassIndex.getSingleIndex());
        }
        if (this.m_Superclass.length() != 0) {
            result.add("-superclass");
            result.add(this.m_Superclass);
        } else {
            result.add("-packages");
            result.add(this.m_Packages.toString().replaceAll("\\[", "").replaceAll("\\]", ""));
        }
        return result.toArray(new String[result.size()]);
    }

    public void setHandler(CapabilitiesHandler value) {
        this.m_Handler = value;
        this.setCapabilities(this.m_Handler.getCapabilities());
    }

    public CapabilitiesHandler getHandler() {
        return this.m_Handler;
    }

    public void setFilename(String value) {
        this.m_Filename = value;
        if (this.m_Filename.length() != 0) {
            try {
                Instances insts = new Instances(new BufferedReader(new FileReader(this.m_Filename)));
                this.m_ClassIndex.setUpper(insts.numAttributes());
                insts.setClassIndex(Integer.parseInt(this.getClassIndex()) - 1);
                this.setCapabilities(Capabilities.forInstances(insts));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public String getFilename() {
        return this.m_Filename;
    }

    public void setClassIndex(String value) {
        this.m_ClassIndex = value.equals("-1") ? null : new SingleIndex(value);
    }

    public String getClassIndex() {
        if (this.m_ClassIndex == null) {
            return "-1";
        }
        return "" + this.m_ClassIndex.getIndex();
    }

    public void enable(Capabilities.Capability c) {
        this.m_Capabilities.enable(c);
    }

    public boolean isEnabled(Capabilities.Capability c) {
        return this.m_Capabilities.handles(c);
    }

    public void disable(Capabilities.Capability c) {
        this.m_Capabilities.disable(c);
    }

    public void enableNot(Capabilities.Capability c) {
        this.m_NotCapabilities.enable(c);
    }

    public boolean isEnabledNot(Capabilities.Capability c) {
        return this.m_NotCapabilities.handles(c);
    }

    public void disableNot(Capabilities.Capability c) {
        this.m_NotCapabilities.disable(c);
    }

    public boolean handles(Capabilities.Capability c) {
        return this.m_Capabilities.handles(c);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.m_Capabilities;
    }

    public void setCapabilities(Capabilities c) {
        this.m_Capabilities = (Capabilities)c.clone();
    }

    public Capabilities getNotCapabilities() {
        return this.m_NotCapabilities;
    }

    public void setNotCapabilities(Capabilities c) {
        this.m_NotCapabilities = (Capabilities)c.clone();
    }

    public Vector<String> getMatches() {
        return this.m_Matches;
    }

    public Vector<String> getMisses() {
        return this.m_Misses;
    }

    public Vector<String> find() {
        this.m_Matches = new Vector();
        this.m_Misses = new Vector();
        Vector<String> list = ClassDiscovery.find(this.m_Superclass, this.m_Packages.toArray(new String[this.m_Packages.size()]));
        for (int i = 0; i < list.size(); ++i) {
            try {
                Class<?> cls = WekaPackageClassLoaderManager.forName(list.get(i));
                Object obj = WekaPackageClassLoaderManager.objectForName(list.get(i));
                if (cls == this.getClass() || !(obj instanceof CapabilitiesHandler)) continue;
                CapabilitiesHandler handler = (CapabilitiesHandler)obj;
                Capabilities caps = handler.getCapabilities();
                boolean fits = true;
                for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                    if (!this.m_Capabilities.handles(cap) || caps.handles(cap)) continue;
                    fits = false;
                    break;
                }
                if (!fits) {
                    this.m_Misses.add(list.get(i));
                    continue;
                }
                for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                    if (!this.m_NotCapabilities.handles(cap) || !caps.handles(cap)) continue;
                    fits = false;
                    break;
                }
                if (!fits) {
                    this.m_Misses.add(list.get(i));
                    continue;
                }
                if (caps.getMinimumNumberInstances() > this.m_Capabilities.getMinimumNumberInstances()) {
                    this.m_Misses.add(list.get(i));
                    continue;
                }
                this.m_Matches.add(list.get(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_Matches;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14375 $");
    }

    public static void main(String[] args) {
        try {
            FindWithCapabilities find = new FindWithCapabilities();
            find.run(find, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void preExecution() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Object toRun, String[] args) throws Exception {
        GenericObjectEditor.determineClasses();
        boolean printMisses = false;
        try {
            int i;
            FindWithCapabilities find = new FindWithCapabilities();
            try {
                printMisses = Utils.getFlag("misses", args);
                find.setOptions(args);
                Utils.checkForRemainingOptions(args);
            }
            catch (Exception ex) {
                String result = ex.getMessage() + "\n\n" + find.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
                Enumeration<Option> enm = find.listOptions();
                while (enm.hasMoreElements()) {
                    Option option = enm.nextElement();
                    result = result + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(result);
            }
            System.out.println("\nSearching for the following Capabilities:");
            System.out.print("- allowed: ");
            Iterator<Capabilities.Capability> iter = find.getCapabilities().capabilities();
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    System.out.print(", ");
                }
                first = false;
                System.out.print((Object)iter.next());
            }
            System.out.println();
            System.out.print("- not allowed: ");
            iter = find.getNotCapabilities().capabilities();
            first = true;
            if (iter.hasNext()) {
                while (iter.hasNext()) {
                    if (!first) {
                        System.out.print(", ");
                    }
                    first = false;
                    System.out.print((Object)iter.next());
                }
                System.out.println();
            } else {
                System.out.println("-");
            }
            find.find();
            Vector<String> list = find.getMatches();
            if (list.size() == 1) {
                System.out.println("\nFound " + list.size() + " class that matched the criteria:\n");
            } else {
                System.out.println("\nFound " + list.size() + " classes that matched the criteria:\n");
            }
            for (i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
            if (printMisses) {
                list = find.getMisses();
                if (list.size() == 1) {
                    System.out.println("\nFound " + list.size() + " class that didn't match the criteria:\n");
                } else {
                    System.out.println("\nFound " + list.size() + " classes that didn't match the criteria:\n");
                }
                for (i = 0; i < list.size(); ++i) {
                    System.out.println(list.get(i));
                }
            }
            System.out.println();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            System.exit(0);
        }
    }

    @Override
    public void postExecution() throws Exception {
    }
}

