/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.neighboursearch.PerformanceStats;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RandomProjection;
import weka.filters.unsupervised.attribute.Remove;

public class FilteredDistance
implements DistanceFunction,
OptionHandler,
Serializable {
    DistanceFunction m_Distance = new EuclideanDistance();
    Filter m_Filter = new RandomProjection();
    Remove m_Remove = new Remove();

    public FilteredDistance() {
        this.m_Remove.setInvertSelection(true);
        this.m_Remove.setAttributeIndices("first-last");
    }

    public String globalInfo() {
        return "Applies the given filter before calling the given distance function.";
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String distanceTipText() {
        return "The distance to be used.";
    }

    public void setDistance(DistanceFunction distance) {
        this.m_Distance = distance;
    }

    public DistanceFunction getDistance() {
        return this.m_Distance;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tThe filter to use. (default: weka.unsupervised.attribute.RandomProjection", "F", 1, "-F"));
        result.addElement(new Option("\tThe distance function to use. (default: weka.core.EuclideanDistance", "E", 0, "-E"));
        if (this.m_Filter instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.m_Filter.getClass().getName() + ":"));
            result.addAll(Collections.list(this.m_Filter.listOptions()));
        }
        if (this.m_Distance instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to distance function " + this.m_Distance.getClass().getName() + ":"));
            result.addAll(Collections.list(this.m_Distance.listOptions()));
        }
        result.addElement(new Option("\tSpecifies list of columns to used in the calculation of the \n\tdistance. 'first' and 'last' are valid indices.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addElement(new Option("\tInvert matching sense of column indices.", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add(this.getAttributeIndices());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        result.add("-F");
        result.add("" + this.getFilterSpec());
        result.add("-D");
        result.add("" + this.getDistanceSpec());
        return result.toArray(new String[result.size()]);
    }

    protected String getFilterSpec() {
        Filter c = this.getFilter();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions(c.getOptions());
        }
        return c.getClass().getName();
    }

    protected String getDistanceSpec() {
        DistanceFunction c = this.getDistance();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions(c.getOptions());
        }
        return c.getClass().getName();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String distance = Utils.getOption('D', options);
        if (distance.length() != 0) {
            String[] distanceSpec = Utils.splitOptions(distance);
            if (distanceSpec.length == 0) {
                throw new Exception("Invalid distance specification string.");
            }
            String className = distanceSpec[0];
            distanceSpec[0] = "";
            this.setDistance((DistanceFunction)Utils.forName(DistanceFunction.class, className, distanceSpec));
        } else {
            this.setDistance(new EuclideanDistance());
        }
        String filter = Utils.getOption('F', options);
        if (filter.length() != 0) {
            String[] filterSpec = Utils.splitOptions(filter);
            if (filterSpec.length == 0) {
                throw new Exception("Invalid filter specification string.");
            }
            String className = filterSpec[0];
            filterSpec[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, className, filterSpec));
        } else {
            this.setFilter(new RandomProjection());
        }
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
    }

    @Override
    public void setInstances(Instances insts) {
        try {
            this.m_Remove.setInputFormat(insts);
            Instances reducedInstances = Filter.useFilter(insts, this.m_Remove);
            this.m_Filter.setInputFormat(reducedInstances);
            this.m_Distance.setInstances(Filter.useFilter(reducedInstances, this.m_Filter));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public Instances getInstances() {
        return this.m_Distance.getInstances();
    }

    @Override
    public void setAttributeIndices(String value) {
        this.m_Remove.setAttributeIndices(value);
    }

    @Override
    public String getAttributeIndices() {
        return this.m_Remove.getAttributeIndices();
    }

    @Override
    public void setInvertSelection(boolean value) {
        this.m_Remove.setInvertSelection(!value);
    }

    @Override
    public boolean getInvertSelection() {
        return !this.m_Remove.getInvertSelection();
    }

    @Override
    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, null);
    }

    @Override
    public double distance(Instance first, Instance second, PerformanceStats stats) throws Exception {
        return this.distance(first, second, Double.POSITIVE_INFINITY, stats);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        return this.distance(first, second, cutOffValue, null);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        try {
            this.m_Remove.input(first);
            this.m_Filter.input(this.m_Remove.output());
            Instance firstFiltered = this.m_Filter.output();
            this.m_Remove.input(second);
            this.m_Filter.input(this.m_Remove.output());
            Instance secondFiltered = this.m_Filter.output();
            return this.m_Distance.distance(firstFiltered, secondFiltered, cutOffValue, stats);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return -1.0;
        }
    }

    @Override
    public void postProcessDistances(double[] distances) {
        this.m_Distance.postProcessDistances(distances);
    }

    @Override
    public void update(Instance ins) {
        try {
            this.m_Remove.input(ins);
            this.m_Filter.input(this.m_Remove.output());
            this.m_Distance.update(this.m_Filter.output());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void clean() {
        this.m_Distance.clean();
    }
}

