/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.CommandlineRunnable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class AbstractClusterer
implements Clusterer,
Cloneable,
Serializable,
CapabilitiesHandler,
RevisionHandler,
OptionHandler,
CapabilitiesIgnorer,
CommandlineRunnable {
    private static final long serialVersionUID = -6099962589663877632L;
    protected boolean m_Debug = false;
    protected boolean m_DoNotCheckCapabilities = false;

    @Override
    public abstract void buildClusterer(Instances var1) throws Exception;

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        if (dist == null) {
            throw new Exception("Null distribution predicted");
        }
        if (Utils.sum(dist) <= 0.0) {
            throw new Exception("Unable to cluster instance");
        }
        return Utils.maxIndex(dist);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] d = new double[this.numberOfClusters()];
        d[this.clusterInstance((Instance)instance)] = 1.0;
        return d;
    }

    @Override
    public abstract int numberOfClusters() throws Exception;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = Option.listOptionsForClassHierarchy(this.getClass(), AbstractClusterer.class);
        newVector.addElement(new Option("\tIf set, clusterer is run in debug mode and\n\tmay output additional info to the console", "output-debug-info", 0, "-output-debug-info"));
        newVector.addElement(new Option("\tIf set, clusterer capabilities are not checked before clusterer is built\n\t(use with caution).", "-do-not-check-capabilities", 0, "-do-not-check-capabilities"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        Option.setOptionsForHierarchy(options, this, AbstractClusterer.class);
        this.setDebug(Utils.getFlag("output-debug-info", options));
        this.setDoNotCheckCapabilities(Utils.getFlag("do-not-check-capabilities", options));
        Utils.checkForRemainingOptions(options);
    }

    public void setDebug(boolean debug2) {
        this.m_Debug = debug2;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, clusterer may output additional info to the console.";
    }

    @Override
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    @Override
    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    public String doNotCheckCapabilitiesTipText() {
        return "If set, clusterer capabilities are not checked before clusterer is built (Use with caution to reduce runtime).";
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        for (String s : Option.getOptionsForHierarchy(this, AbstractClusterer.class)) {
            options.add(s);
        }
        if (this.getDebug()) {
            options.add("-output-debug-info");
        }
        if (this.getDoNotCheckCapabilities()) {
            options.add("-do-not-check-capabilities");
        }
        return options.toArray(new String[0]);
    }

    public static Clusterer forName(String clustererName, String[] options) throws Exception {
        return (Clusterer)Utils.forName(Clusterer.class, clustererName, options);
    }

    public static Clusterer makeCopy(Clusterer model) throws Exception {
        return (Clusterer)new SerializedObject(model).getObject();
    }

    public static Clusterer[] makeCopies(Clusterer model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model clusterer set");
        }
        Clusterer[] clusterers = new Clusterer[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < clusterers.length; ++i) {
            clusterers[i] = (Clusterer)so.getObject();
        }
        return clusterers;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15520 $");
    }

    public static void runClusterer(Clusterer clusterer, String[] options) {
        try {
            if (clusterer instanceof CommandlineRunnable) {
                ((CommandlineRunnable)((Object)clusterer)).preExecution();
            }
            System.out.println(ClusterEvaluation.evaluateClusterer(clusterer, options));
        }
        catch (Exception e2) {
            if (e2.getMessage() == null || e2.getMessage() != null && e2.getMessage().indexOf("General options") == -1) {
                e2.printStackTrace();
            }
            System.err.println(e2.getMessage());
        }
        try {
            if (clusterer instanceof CommandlineRunnable) {
                ((CommandlineRunnable)((Object)clusterer)).postExecution();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void preExecution() throws Exception {
    }

    @Override
    public void run(Object toRun, String[] options) throws Exception {
        if (!(toRun instanceof Clusterer)) {
            throw new IllegalArgumentException("Object to execute is not a Clusterer!");
        }
        AbstractClusterer.runClusterer((Clusterer)toRun, options);
    }

    @Override
    public void postExecution() throws Exception {
    }
}

