/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;

public class Stats
implements RevisionHandler {
    public static double addErrs(double N, double e2, float CF) {
        if ((double)CF > 0.5) {
            System.err.println("WARNING: confidence value for pruning  too high. Error estimate not modified.");
            return 0.0;
        }
        if (e2 < 1.0) {
            double base = N * (1.0 - Math.pow(CF, 1.0 / N));
            if (e2 == 0.0) {
                return base;
            }
            return base + e2 * (Stats.addErrs(N, 1.0, CF) - base);
        }
        if (e2 + 0.5 >= N) {
            return Math.max(N - e2, 0.0);
        }
        double z = Statistics.normalInverse(1.0f - CF);
        double f = (e2 + 0.5) / N;
        double r = (f + z * z / (2.0 * N) + z * Math.sqrt(f / N - f * f / N + z * z / (4.0 * N * N))) / (1.0 + z * z / N);
        return r * N - e2;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

