/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NBTreeClassifierTree
extends ClassifierTree {
    private static final long serialVersionUID = -4472639447877404786L;

    public NBTreeClassifierTree(ModelSelection toSelectLocModel) {
        super(toSelectLocModel);
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        super.buildClassifier(data);
        this.cleanup(new Instances(data, 0));
        this.assignIDs(-1);
    }

    @Override
    protected ClassifierTree getNewTree(Instances data) throws Exception {
        NBTreeClassifierTree newTree = new NBTreeClassifierTree(this.m_toSelectModel);
        newTree.buildTree(data, false);
        return newTree;
    }

    @Override
    protected ClassifierTree getNewTree(Instances train, Instances test) throws Exception {
        NBTreeClassifierTree newTree = new NBTreeClassifierTree(this.m_toSelectModel);
        newTree.buildTree(train, test, false);
        return newTree;
    }

    public String printLeafModels() {
        StringBuffer text = new StringBuffer();
        if (this.m_isLeaf) {
            text.append("\nLeaf number: " + this.m_id + " ");
            text.append(this.m_localModel.toString());
            text.append("\n");
        } else {
            for (ClassifierTree m_son : this.m_sons) {
                text.append(((NBTreeClassifierTree)m_son).printLeafModels());
            }
        }
        return text.toString();
    }

    @Override
    public String toString() {
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_isLeaf) {
                text.append(": NB");
                text.append(this.m_id);
            } else {
                this.dumpTreeNB(0, text);
            }
            text.append("\n" + this.printLeafModels());
            text.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            text.append("\nSize of the tree : \t" + this.numNodes() + "\n");
            return text.toString();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "Can't print nb tree.";
        }
    }

    private void dumpTreeNB(int depth, StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("\n");
            for (int j = 0; j < depth; ++j) {
                text.append("|   ");
            }
            text.append(this.m_localModel.leftSide(this.m_train));
            text.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                text.append(": NB ");
                text.append(this.m_sons[i].m_id);
                continue;
            }
            ((NBTreeClassifierTree)this.m_sons[i]).dumpTreeNB(depth + 1, text);
        }
    }

    @Override
    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("digraph J48Tree {\n");
        if (this.m_isLeaf) {
            text.append("N" + this.m_id + " [label=\"NB model\" shape=box style=filled ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                text.append("data =\n" + this.m_train + "\n");
                text.append(",\n");
            }
            text.append("]\n");
        } else {
            text.append("N" + this.m_id + " [label=\"" + Utils.backQuoteChars(this.m_localModel.leftSide(this.m_train)) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                text.append("data =\n" + this.m_train + "\n");
                text.append(",\n");
            }
            text.append("]\n");
            this.graphTree(text);
        }
        return text.toString() + "}\n";
    }

    private void graphTree(StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("N" + this.m_id + "->N" + this.m_sons[i].m_id + " [label=\"" + Utils.backQuoteChars(this.m_localModel.rightSide(i, this.m_train).trim()) + "\"]\n");
            if (this.m_sons[i].m_isLeaf) {
                text.append("N" + this.m_sons[i].m_id + " [label=\"NB Model\" shape=box style=filled ");
                if (this.m_train != null && this.m_train.numInstances() > 0) {
                    text.append("data =\n" + this.m_sons[i].m_train + "\n");
                    text.append(",\n");
                }
                text.append("]\n");
                continue;
            }
            text.append("N" + this.m_sons[i].m_id + " [label=\"" + Utils.backQuoteChars(this.m_sons[i].m_localModel.leftSide(this.m_train)) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                text.append("data =\n" + this.m_sons[i].m_train + "\n");
                text.append(",\n");
            }
            text.append("]\n");
            ((NBTreeClassifierTree)this.m_sons[i]).graphTree(text);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }
}

