/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import weka.classifiers.trees.ht.SplitMetric;
import weka.classifiers.trees.ht.WeightMass;

public class GiniSplitMetric
extends SplitMetric
implements Serializable {
    private static final long serialVersionUID = -2037586582742660298L;

    @Override
    public double evaluateSplit(Map<String, WeightMass> preDist, List<Map<String, WeightMass>> postDist) {
        double totalWeight = 0.0;
        double[] distWeights = new double[postDist.size()];
        for (int i = 0; i < postDist.size(); ++i) {
            distWeights[i] = SplitMetric.sum(postDist.get(i));
            totalWeight += distWeights[i];
        }
        double gini = 0.0;
        for (int i = 0; i < postDist.size(); ++i) {
            gini += distWeights[i] / totalWeight * GiniSplitMetric.gini(postDist.get(i), distWeights[i]);
        }
        return 1.0 - gini;
    }

    protected static double gini(Map<String, WeightMass> dist, double sumOfWeights) {
        double gini = 1.0;
        for (Map.Entry<String, WeightMass> e2 : dist.entrySet()) {
            double frac = e2.getValue().m_weight / sumOfWeights;
            gini -= frac * frac;
        }
        return gini;
    }

    public static double gini(Map<String, WeightMass> dist) {
        return GiniSplitMetric.gini(dist, SplitMetric.sum(dist));
    }

    @Override
    public double getMetricRange(Map<String, WeightMass> preDist) {
        return 1.0;
    }
}

