/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import weka.classifiers.rules.Rule;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RuleStats
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -5708153367675298624L;
    private Instances m_Data = null;
    private ArrayList<Rule> m_Ruleset = null;
    private ArrayList<double[]> m_SimpleStats = null;
    private ArrayList<Instances[]> m_Filtered = null;
    private double m_Total = -1.0;
    private static double REDUNDANCY_FACTOR = 0.5;
    private double MDL_THEORY_WEIGHT = 1.0;
    private ArrayList<double[]> m_Distributions = null;

    public RuleStats() {
    }

    public RuleStats(Instances data, ArrayList<Rule> rules) {
        this();
        this.m_Data = data;
        this.m_Ruleset = rules;
    }

    public void cleanUp() {
        this.m_Data = null;
        this.m_Filtered = null;
    }

    public void setNumAllConds(double total) {
        this.m_Total = total < 0.0 ? RuleStats.numAllConditions(this.m_Data) : total;
    }

    public void setData(Instances data) {
        this.m_Data = data;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public void setRuleset(ArrayList<Rule> rules) {
        this.m_Ruleset = rules;
    }

    public ArrayList<Rule> getRuleset() {
        return this.m_Ruleset;
    }

    public int getRulesetSize() {
        return this.m_Ruleset.size();
    }

    public double[] getSimpleStats(int index) {
        if (this.m_SimpleStats != null && index < this.m_SimpleStats.size()) {
            return this.m_SimpleStats.get(index);
        }
        return null;
    }

    public Instances[] getFiltered(int index) {
        if (this.m_Filtered != null && index < this.m_Filtered.size()) {
            return this.m_Filtered.get(index);
        }
        return null;
    }

    public double[] getDistributions(int index) {
        if (this.m_Distributions != null && index < this.m_Distributions.size()) {
            return this.m_Distributions.get(index);
        }
        return null;
    }

    public void setMDLTheoryWeight(double weight) {
        this.MDL_THEORY_WEIGHT = weight;
    }

    public static double numAllConditions(Instances data) {
        double total = 0.0;
        Enumeration<Attribute> attEnum = data.enumerateAttributes();
        while (attEnum.hasMoreElements()) {
            Attribute att = attEnum.nextElement();
            if (att.isNominal()) {
                total += (double)att.numValues();
                continue;
            }
            total += 2.0 * (double)data.numDistinctValues(att);
        }
        return total;
    }

    public void countData() {
        if (this.m_Filtered != null || this.m_Ruleset == null || this.m_Data == null) {
            return;
        }
        int size = this.m_Ruleset.size();
        this.m_Filtered = new ArrayList(size);
        this.m_SimpleStats = new ArrayList(size);
        this.m_Distributions = new ArrayList(size);
        Instances data = new Instances(this.m_Data);
        for (int i = 0; i < size; ++i) {
            double[] stats = new double[6];
            double[] classCounts = new double[this.m_Data.classAttribute().numValues()];
            Instances[] filtered = this.computeSimpleStats(i, data, stats, classCounts);
            this.m_Filtered.add(filtered);
            this.m_SimpleStats.add(stats);
            this.m_Distributions.add(classCounts);
            data = filtered[1];
        }
    }

    public void countData(int index, Instances uncovered, double[][] prevRuleStats) {
        if (this.m_Filtered != null || this.m_Ruleset == null) {
            return;
        }
        int size = this.m_Ruleset.size();
        this.m_Filtered = new ArrayList(size);
        this.m_SimpleStats = new ArrayList(size);
        Instances[] data = new Instances[2];
        data[1] = uncovered;
        for (int i = 0; i < index; ++i) {
            this.m_SimpleStats.add(prevRuleStats[i]);
            if (i + 1 == index) {
                this.m_Filtered.add(data);
                continue;
            }
            this.m_Filtered.add(new Instances[0]);
        }
        for (int j = index; j < size; ++j) {
            double[] stats = new double[6];
            Instances[] filtered = this.computeSimpleStats(j, data[1], stats, null);
            this.m_Filtered.add(filtered);
            this.m_SimpleStats.add(stats);
            data = filtered;
        }
    }

    private Instances[] computeSimpleStats(int index, Instances insts, double[] stats, double[] dist) {
        Rule rule = this.m_Ruleset.get(index);
        Instances[] data = new Instances[]{new Instances(insts, insts.numInstances()), new Instances(insts, insts.numInstances())};
        for (int i = 0; i < insts.numInstances(); ++i) {
            Instance datum = insts.instance(i);
            double weight = datum.weight();
            if (rule.covers(datum)) {
                data[0].add(datum);
                stats[0] = stats[0] + weight;
                if ((int)datum.classValue() == (int)rule.getConsequent()) {
                    stats[2] = stats[2] + weight;
                } else {
                    stats[4] = stats[4] + weight;
                }
                if (dist == null) continue;
                int n = (int)datum.classValue();
                dist[n] = dist[n] + weight;
                continue;
            }
            data[1].add(datum);
            stats[1] = stats[1] + weight;
            if ((int)datum.classValue() != (int)rule.getConsequent()) {
                stats[3] = stats[3] + weight;
                continue;
            }
            stats[5] = stats[5] + weight;
        }
        return data;
    }

    public void addAndUpdate(Rule lastRule) {
        if (this.m_Ruleset == null) {
            this.m_Ruleset = new ArrayList();
        }
        this.m_Ruleset.add(lastRule);
        Instances data = this.m_Filtered == null ? this.m_Data : this.m_Filtered.get(this.m_Filtered.size() - 1)[1];
        double[] stats = new double[6];
        double[] classCounts = new double[this.m_Data.classAttribute().numValues()];
        Instances[] filtered = this.computeSimpleStats(this.m_Ruleset.size() - 1, data, stats, classCounts);
        if (this.m_Filtered == null) {
            this.m_Filtered = new ArrayList();
        }
        this.m_Filtered.add(filtered);
        if (this.m_SimpleStats == null) {
            this.m_SimpleStats = new ArrayList();
        }
        this.m_SimpleStats.add(stats);
        if (this.m_Distributions == null) {
            this.m_Distributions = new ArrayList();
        }
        this.m_Distributions.add(classCounts);
    }

    public static double subsetDL(double t, double k, double p) {
        double rt = Utils.gr(p, 0.0) ? -k * Utils.log2(p) : 0.0;
        return rt -= (t - k) * Utils.log2(1.0 - p);
    }

    public double theoryDL(int index) {
        double k = this.m_Ruleset.get(index).size();
        if (k == 0.0) {
            return 0.0;
        }
        double tdl = Utils.log2(k);
        if (k > 1.0) {
            tdl += 2.0 * Utils.log2(tdl);
        }
        return this.MDL_THEORY_WEIGHT * REDUNDANCY_FACTOR * (tdl += RuleStats.subsetDL(this.m_Total, k, k / this.m_Total));
    }

    public static double dataDL(double expFPOverErr, double cover, double uncover, double fp, double fn) {
        double uncoverBits;
        double coverBits;
        double totalBits = Utils.log2(cover + uncover + 1.0);
        if (Utils.gr(cover, uncover)) {
            double expErr = expFPOverErr * (fp + fn);
            coverBits = RuleStats.subsetDL(cover, fp, expErr / cover);
            uncoverBits = Utils.gr(uncover, 0.0) ? RuleStats.subsetDL(uncover, fn, fn / uncover) : 0.0;
        } else {
            double expErr = (1.0 - expFPOverErr) * (fp + fn);
            coverBits = Utils.gr(cover, 0.0) ? RuleStats.subsetDL(cover, fp, fp / cover) : 0.0;
            uncoverBits = RuleStats.subsetDL(uncover, fn, expErr / uncover);
        }
        return totalBits + coverBits + uncoverBits;
    }

    public double potential(int index, double expFPOverErr, double[] rulesetStat, double[] ruleStat, boolean checkErr) {
        double pcov = rulesetStat[0] - ruleStat[0];
        double puncov = rulesetStat[1] + ruleStat[0];
        double pfp = rulesetStat[4] - ruleStat[4];
        double pfn = rulesetStat[5] + ruleStat[2];
        double dataDLWith = RuleStats.dataDL(expFPOverErr, rulesetStat[0], rulesetStat[1], rulesetStat[4], rulesetStat[5]);
        double theoryDLWith = this.theoryDL(index);
        double dataDLWithout = RuleStats.dataDL(expFPOverErr, pcov, puncov, pfp, pfn);
        double potential = dataDLWith + theoryDLWith - dataDLWithout;
        double err = ruleStat[4] / ruleStat[0];
        boolean overErr = Utils.grOrEq(err, 0.5);
        if (!checkErr) {
            overErr = false;
        }
        if (Utils.grOrEq(potential, 0.0) || overErr) {
            rulesetStat[0] = pcov;
            rulesetStat[1] = puncov;
            rulesetStat[4] = pfp;
            rulesetStat[5] = pfn;
            return potential;
        }
        return Double.NaN;
    }

    public double minDataDLIfDeleted(int index, double expFPRate, boolean checkErr) {
        double[] rulesetStat = new double[6];
        int more = this.m_Ruleset.size() - 1 - index;
        ArrayList<double[]> indexPlus = new ArrayList<double[]>(more);
        for (int j = 0; j < index; ++j) {
            rulesetStat[0] = rulesetStat[0] + this.m_SimpleStats.get(j)[0];
            rulesetStat[2] = rulesetStat[2] + this.m_SimpleStats.get(j)[2];
            rulesetStat[4] = rulesetStat[4] + this.m_SimpleStats.get(j)[4];
        }
        Instances data = index == 0 ? this.m_Data : this.m_Filtered.get(index - 1)[1];
        for (int j = index + 1; j < this.m_Ruleset.size(); ++j) {
            double[] stats = new double[6];
            Instances[] split = this.computeSimpleStats(j, data, stats, null);
            indexPlus.add(stats);
            rulesetStat[0] = rulesetStat[0] + stats[0];
            rulesetStat[2] = rulesetStat[2] + stats[2];
            rulesetStat[4] = rulesetStat[4] + stats[4];
            data = split[1];
        }
        if (more > 0) {
            rulesetStat[1] = ((double[])indexPlus.get(indexPlus.size() - 1))[1];
            rulesetStat[3] = ((double[])indexPlus.get(indexPlus.size() - 1))[3];
            rulesetStat[5] = ((double[])indexPlus.get(indexPlus.size() - 1))[5];
        } else if (index > 0) {
            rulesetStat[1] = this.m_SimpleStats.get(index - 1)[1];
            rulesetStat[3] = this.m_SimpleStats.get(index - 1)[3];
            rulesetStat[5] = this.m_SimpleStats.get(index - 1)[5];
        } else {
            rulesetStat[1] = this.m_SimpleStats.get(0)[0] + this.m_SimpleStats.get(0)[1];
            rulesetStat[3] = this.m_SimpleStats.get(0)[3] + this.m_SimpleStats.get(0)[4];
            rulesetStat[5] = this.m_SimpleStats.get(0)[2] + this.m_SimpleStats.get(0)[5];
        }
        double potential = 0.0;
        for (int k = index + 1; k < this.m_Ruleset.size(); ++k) {
            double[] ruleStat = (double[])indexPlus.get(k - index - 1);
            double ifDeleted = this.potential(k, expFPRate, rulesetStat, ruleStat, checkErr);
            if (Double.isNaN(ifDeleted)) continue;
            potential += ifDeleted;
        }
        double dataDLWithout = RuleStats.dataDL(expFPRate, rulesetStat[0], rulesetStat[1], rulesetStat[4], rulesetStat[5]);
        return dataDLWithout - potential;
    }

    public double minDataDLIfExists(int index, double expFPRate, boolean checkErr) {
        double[] rulesetStat = new double[6];
        for (int j = 0; j < this.m_SimpleStats.size(); ++j) {
            rulesetStat[0] = rulesetStat[0] + this.m_SimpleStats.get(j)[0];
            rulesetStat[2] = rulesetStat[2] + this.m_SimpleStats.get(j)[2];
            rulesetStat[4] = rulesetStat[4] + this.m_SimpleStats.get(j)[4];
            if (j != this.m_SimpleStats.size() - 1) continue;
            rulesetStat[1] = this.m_SimpleStats.get(j)[1];
            rulesetStat[3] = this.m_SimpleStats.get(j)[3];
            rulesetStat[5] = this.m_SimpleStats.get(j)[5];
        }
        double potential = 0.0;
        for (int k = index + 1; k < this.m_SimpleStats.size(); ++k) {
            double[] ruleStat = this.getSimpleStats(k);
            double ifDeleted = this.potential(k, expFPRate, rulesetStat, ruleStat, checkErr);
            if (Double.isNaN(ifDeleted)) continue;
            potential += ifDeleted;
        }
        double dataDLWith = RuleStats.dataDL(expFPRate, rulesetStat[0], rulesetStat[1], rulesetStat[4], rulesetStat[5]);
        return dataDLWith - potential;
    }

    public double relativeDL(int index, double expFPRate, boolean checkErr) {
        return this.minDataDLIfExists(index, expFPRate, checkErr) + this.theoryDL(index) - this.minDataDLIfDeleted(index, expFPRate, checkErr);
    }

    public void reduceDL(double expFPRate, boolean checkErr) {
        boolean needUpdate = false;
        double[] rulesetStat = new double[6];
        for (int j = 0; j < this.m_SimpleStats.size(); ++j) {
            rulesetStat[0] = rulesetStat[0] + this.m_SimpleStats.get(j)[0];
            rulesetStat[2] = rulesetStat[2] + this.m_SimpleStats.get(j)[2];
            rulesetStat[4] = rulesetStat[4] + this.m_SimpleStats.get(j)[4];
            if (j != this.m_SimpleStats.size() - 1) continue;
            rulesetStat[1] = this.m_SimpleStats.get(j)[1];
            rulesetStat[3] = this.m_SimpleStats.get(j)[3];
            rulesetStat[5] = this.m_SimpleStats.get(j)[5];
        }
        for (int k = this.m_SimpleStats.size() - 1; k >= 0; --k) {
            double[] ruleStat = this.m_SimpleStats.get(k);
            double ifDeleted = this.potential(k, expFPRate, rulesetStat, ruleStat, checkErr);
            if (Double.isNaN(ifDeleted)) continue;
            if (k == this.m_SimpleStats.size() - 1) {
                this.removeLast();
                continue;
            }
            this.m_Ruleset.remove(k);
            needUpdate = true;
        }
        if (needUpdate) {
            this.m_Filtered = null;
            this.m_SimpleStats = null;
            this.countData();
        }
    }

    public void removeLast() {
        int last = this.m_Ruleset.size() - 1;
        this.m_Ruleset.remove(last);
        this.m_Filtered.remove(last);
        this.m_SimpleStats.remove(last);
        if (this.m_Distributions != null) {
            this.m_Distributions.remove(last);
        }
    }

    public static Instances rmCoveredBySuccessives(Instances data, ArrayList<Rule> rules, int index) {
        Instances rt = new Instances(data, 0);
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance datum = data.instance(i);
            boolean covered = false;
            for (int j = index + 1; j < rules.size(); ++j) {
                Rule rule = rules.get(j);
                if (!rule.covers(datum)) continue;
                covered = true;
                break;
            }
            if (covered) continue;
            rt.add(datum);
        }
        return rt;
    }

    public static final Instances stratify(Instances data, int folds, Random rand) {
        if (!data.classAttribute().isNominal()) {
            return data;
        }
        Instances result = new Instances(data, 0);
        Instances[] bagsByClasses = new Instances[data.numClasses()];
        for (int i = 0; i < bagsByClasses.length; ++i) {
            bagsByClasses[i] = new Instances(data, 0);
        }
        for (int j = 0; j < data.numInstances(); ++j) {
            Instance datum = data.instance(j);
            bagsByClasses[(int)datum.classValue()].add(datum);
        }
        for (Instances bagsByClasse : bagsByClasses) {
            bagsByClasse.randomize(rand);
        }
        block3: for (int k = 0; k < folds; ++k) {
            int offset = k;
            int bag2 = 0;
            while (true) {
                if (offset >= bagsByClasses[bag2].numInstances()) {
                    offset -= bagsByClasses[bag2].numInstances();
                    if (++bag2 < bagsByClasses.length) continue;
                    continue block3;
                }
                result.add(bagsByClasses[bag2].instance(offset));
                offset += folds;
            }
        }
        return result;
    }

    public double combinedDL(double expFPRate, double predicted) {
        double rt = 0.0;
        if (this.getRulesetSize() > 0) {
            double[] stats = this.m_SimpleStats.get(this.m_SimpleStats.size() - 1);
            for (int j = this.getRulesetSize() - 2; j >= 0; --j) {
                stats[0] = stats[0] + this.getSimpleStats(j)[0];
                stats[2] = stats[2] + this.getSimpleStats(j)[2];
                stats[4] = stats[4] + this.getSimpleStats(j)[4];
            }
            rt += RuleStats.dataDL(expFPRate, stats[0], stats[1], stats[4], stats[5]);
        } else {
            double fn = 0.0;
            for (int j = 0; j < this.m_Data.numInstances(); ++j) {
                if ((int)this.m_Data.instance(j).classValue() != (int)predicted) continue;
                fn += this.m_Data.instance(j).weight();
            }
            rt += RuleStats.dataDL(expFPRate, 0.0, this.m_Data.sumOfWeights(), 0.0, fn);
        }
        for (int i = 0; i < this.getRulesetSize(); ++i) {
            rt += this.theoryDL(i);
        }
        return rt;
    }

    public static final Instances[] partition(Instances data, int numFolds) {
        Instances[] rt = new Instances[2];
        int splits = data.numInstances() * (numFolds - 1) / numFolds;
        rt[0] = new Instances(data, 0, splits);
        rt[1] = new Instances(data, splits, data.numInstances() - splits);
        return rt;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }
}

