/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Collections;
import java.util.Enumeration;
import no.uib.cipr.matrix.DenseCholesky;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSPDDenseMatrix;
import no.uib.cipr.matrix.Vector;
import weka.classifiers.ConditionalDensityEstimator;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class GaussianProcesses
extends RandomizableClassifier
implements IntervalEstimator,
ConditionalDensityEstimator,
TechnicalInformationHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -8620066949967678545L;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = false;
    protected double m_delta = 1.0;
    protected double m_deltaSquared = 1.0;
    protected double m_Alin;
    protected double m_Blin;
    protected Kernel m_kernel = new PolyKernel();
    protected Kernel m_actualKernel;
    protected int m_NumTrain = 0;
    protected double m_avg_target;
    public Matrix m_L;
    protected Vector m_t;
    protected double[] m_weights;

    public String globalInfo() {
        return " Implements Gaussian processes for regression without hyperparameter-tuning. To make choosing an appropriate noise level easier, this implementation applies normalization/standardization to the target attribute as well as the other attributes (if  normalization/standardizaton is turned on). Missing values are replaced by the global mean/mode. Nominal attributes are converted to binary ones. Note that kernel caching is turned off if the kernel used implements CachedKernel.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "David J.C. Mackay");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Introduction to Gaussian Processes");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Dept. of Physics, Cambridge University, UK");
        result.setValue(TechnicalInformation.Field.PS, "http://wol.ra.phy.cam.ac.uk/mackay/gpB.ps.gz");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner(this);
        result.enableAllAttributeDependencies();
        if (result.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.disable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        int i;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(insts);
            insts = new Instances(insts);
            insts.deleteWithMissingClass();
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                for (int i2 = 0; i2 < insts.numAttributes(); ++i2) {
                    if (i2 == insts.classIndex() || insts.attribute(i2).isNumeric()) continue;
                    onlyNumeric = false;
                    break;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(insts);
                insts = Filter.useFilter(insts, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            ((Standardize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            ((Normalize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_NumTrain = insts.numInstances();
        if (this.m_Filter != null) {
            Instance witness = (Instance)insts.instance(0).copy();
            witness.setValue(insts.classIndex(), 0.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            Instance res = this.m_Filter.output();
            this.m_Blin = res.value(insts.classIndex());
            witness.setValue(insts.classIndex(), 1.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            res = this.m_Filter.output();
            this.m_Alin = res.value(insts.classIndex()) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        this.m_actualKernel = Kernel.makeCopy(this.m_kernel);
        if (this.m_kernel instanceof CachedKernel) {
            ((CachedKernel)this.m_actualKernel).setCacheSize(-1);
        }
        this.m_actualKernel.buildKernel(insts);
        double sum = 0.0;
        for (i = 0; i < insts.numInstances(); ++i) {
            sum += insts.instance(i).weight() * insts.instance(i).classValue();
        }
        this.m_avg_target = sum / insts.sumOfWeights();
        this.m_deltaSquared = this.m_delta * this.m_delta;
        this.m_weights = new double[insts.numInstances()];
        for (i = 0; i < insts.numInstances(); ++i) {
            this.m_weights[i] = Math.sqrt(insts.instance(i).weight());
        }
        int n = insts.numInstances();
        this.m_L = new UpperSPDDenseMatrix(n);
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = i3 + 1; j < n; ++j) {
                this.m_L.set(i3, j, this.m_weights[i3] * this.m_weights[j] * this.m_actualKernel.eval(i3, j, insts.instance(i3)));
            }
            this.m_L.set(i3, i3, this.m_weights[i3] * this.m_weights[i3] * this.m_actualKernel.eval(i3, i3, insts.instance(i3)) + this.m_deltaSquared);
        }
        this.m_L = new DenseCholesky(n, true).factor((UpperSPDDenseMatrix)this.m_L).solve(Matrices.identity(n));
        this.m_L = new UpperSPDDenseMatrix(this.m_L);
        DenseVector tt = new DenseVector(n);
        for (int i4 = 0; i4 < n; ++i4) {
            tt.set(i4, this.m_weights[i4] * (insts.instance(i4).classValue() - this.m_avg_target));
        }
        this.m_t = this.m_L.mult(tt, new DenseVector(insts.numInstances()));
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        inst = this.filterInstance(inst);
        DenseVector k = new DenseVector(this.m_NumTrain);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, this.m_weights[i] * this.m_actualKernel.eval(-1, i, inst));
        }
        double result = (k.dot(this.m_t) + this.m_avg_target - this.m_Blin) / this.m_Alin;
        return result;
    }

    protected Instance filterInstance(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        return inst;
    }

    protected double computeStdDev(Instance inst, Vector k) throws Exception {
        double kappa = this.m_actualKernel.eval(-1, -1, inst) + this.m_deltaSquared;
        double s = this.m_L.mult(k, new DenseVector(k.size())).dot(k);
        double sigma = this.m_delta;
        if (kappa > s) {
            sigma = Math.sqrt(kappa - s);
        }
        return sigma;
    }

    @Override
    public double[][] predictIntervals(Instance inst, double confidenceLevel) throws Exception {
        inst = this.filterInstance(inst);
        DenseVector k = new DenseVector(this.m_NumTrain);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, this.m_weights[i] * this.m_actualKernel.eval(-1, i, inst));
        }
        double estimate = k.dot(this.m_t) + this.m_avg_target;
        double sigma = this.computeStdDev(inst, k);
        confidenceLevel = 1.0 - (1.0 - confidenceLevel) / 2.0;
        double z = Statistics.normalInverse(confidenceLevel);
        double[][] interval = new double[1][2];
        interval[0][0] = estimate - z * sigma;
        interval[0][1] = estimate + z * sigma;
        interval[0][0] = (interval[0][0] - this.m_Blin) / this.m_Alin;
        interval[0][1] = (interval[0][1] - this.m_Blin) / this.m_Alin;
        return interval;
    }

    public double getStandardDeviation(Instance inst) throws Exception {
        inst = this.filterInstance(inst);
        DenseVector k = new DenseVector(this.m_NumTrain);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, this.m_weights[i] * this.m_actualKernel.eval(-1, i, inst));
        }
        return this.computeStdDev(inst, k) / this.m_Alin;
    }

    @Override
    public double logDensity(Instance inst, double value) throws Exception {
        inst = this.filterInstance(inst);
        DenseVector k = new DenseVector(this.m_NumTrain);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, this.m_weights[i] * this.m_actualKernel.eval(-1, i, inst));
        }
        double estimate = k.dot(this.m_t) + this.m_avg_target;
        double sigma = this.computeStdDev(inst, k);
        value = value * this.m_Alin + this.m_Blin;
        double z = -Math.log(sigma * Math.sqrt(Math.PI * 2)) - (value -= estimate) * value / (2.0 * sigma * sigma);
        return z + Math.log(this.m_Alin);
    }

    @Override
    public Enumeration<Option> listOptions() {
        java.util.Vector<Option> result = new java.util.Vector<Option>();
        result.addElement(new Option("\tLevel of Gaussian Noise wrt transformed target. (default 1)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addAll(Collections.list(super.listOptions()));
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        result.addAll(Collections.list(this.getKernel().listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setNoise(Double.parseDouble(tmpStr));
        } else {
            this.setNoise(1.0);
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        tmpStr = Utils.getOption('K', options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName(tmpStr, tmpOptions));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        java.util.Vector<String> result = new java.util.Vector<String>();
        result.addElement("-L");
        result.addElement("" + this.getNoise());
        result.addElement("-N");
        result.addElement("" + this.m_filterType);
        result.addElement("-K");
        result.addElement("" + this.m_kernel.getClass().getName() + " " + Utils.joinOptions(this.m_kernel.getOptions()));
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String noiseTipText() {
        return "The level of Gaussian Noise (added to the diagonal of the Covariance Matrix), after the target has been normalized/standardized/left unchanged).";
    }

    public double getNoise() {
        return this.m_delta;
    }

    public void setNoise(double v) {
        this.m_delta = v;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_t == null) {
            return "Gaussian Processes: No model built yet.";
        }
        try {
            int i;
            text.append("Gaussian Processes\n\n");
            text.append("Kernel used:\n  " + this.m_kernel.toString() + "\n\n");
            text.append("All values shown based on: " + TAGS_FILTER[this.m_filterType].getReadable() + "\n\n");
            text.append("Average Target Value : " + this.m_avg_target + "\n");
            text.append("Inverted Covariance Matrix:\n");
            double min2 = this.m_L.get(0, 0);
            double max2 = this.m_L.get(0, 0);
            for (i = 0; i < this.m_NumTrain; ++i) {
                for (int j = 0; j <= i; ++j) {
                    if (this.m_L.get(i, j) < min2) {
                        min2 = this.m_L.get(i, j);
                        continue;
                    }
                    if (!(this.m_L.get(i, j) > max2)) continue;
                    max2 = this.m_L.get(i, j);
                }
            }
            text.append("    Lowest Value = " + min2 + "\n");
            text.append("    Highest Value = " + max2 + "\n");
            text.append("Inverted Covariance Matrix * Target-value Vector:\n");
            min2 = this.m_t.get(0);
            max2 = this.m_t.get(0);
            for (i = 0; i < this.m_NumTrain; ++i) {
                if (this.m_t.get(i) < min2) {
                    min2 = this.m_t.get(i);
                    continue;
                }
                if (!(this.m_t.get(i) > max2)) continue;
                max2 = this.m_t.get(i);
            }
            text.append("    Lowest Value = " + min2 + "\n");
            text.append("    Highest Value = " + max2 + "\n \n");
        }
        catch (Exception e2) {
            return "Can't print the classifier.";
        }
        return text.toString();
    }

    public static void main(String[] argv) {
        GaussianProcesses.runClassifier(new GaussianProcesses(), argv);
    }
}

