/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weka.classifiers.evaluation.AbstractEvaluationMetric;
import weka.classifiers.evaluation.Evaluation;
import weka.classifiers.evaluation.InformationRetrievalEvaluationMetric;
import weka.classifiers.evaluation.ThresholdProducingMetric;

public class EvaluationMetricHelper {
    protected Evaluation m_eval;
    protected Map<String, Integer> m_builtin = new HashMap<String, Integer>();
    protected Map<String, AbstractEvaluationMetric> m_pluginMetrics = new HashMap<String, AbstractEvaluationMetric>();

    public EvaluationMetricHelper(Evaluation eval2) {
        for (int i = 0; i < Evaluation.BUILT_IN_EVAL_METRICS.length; ++i) {
            this.m_builtin.put(Evaluation.BUILT_IN_EVAL_METRICS[i].toLowerCase(), i);
        }
        this.setEvaluation(eval2);
    }

    public void setEvaluation(Evaluation eval2) {
        this.m_eval = eval2;
        this.initializeWithPluginMetrics();
    }

    protected void initializeWithPluginMetrics() {
        this.m_pluginMetrics.clear();
        List<AbstractEvaluationMetric> pluginMetrics = this.m_eval.getPluginMetrics();
        if (pluginMetrics != null && pluginMetrics.size() > 0) {
            for (AbstractEvaluationMetric m : pluginMetrics) {
                List<String> statNames = m.getStatisticNames();
                for (String s : statNames) {
                    this.m_pluginMetrics.put(s.toLowerCase(), m);
                }
            }
        }
    }

    public static List<String> getBuiltInMetricNames() {
        ArrayList<String> builtIn = new ArrayList<String>();
        builtIn.addAll(Arrays.asList(Evaluation.BUILT_IN_EVAL_METRICS));
        return builtIn;
    }

    public static List<String> getPluginMetricNames() {
        ArrayList<String> pluginNames = new ArrayList<String>();
        ArrayList<AbstractEvaluationMetric> pluginMetrics = AbstractEvaluationMetric.getPluginMetrics();
        if (pluginMetrics != null) {
            for (AbstractEvaluationMetric m : pluginMetrics) {
                List<String> statNames = m.getStatisticNames();
                for (String s : statNames) {
                    pluginNames.add(s.toLowerCase());
                }
            }
        }
        return pluginNames;
    }

    public static List<String> getAllMetricNames() {
        List<String> metrics = EvaluationMetricHelper.getBuiltInMetricNames();
        metrics.addAll(EvaluationMetricHelper.getPluginMetricNames());
        return metrics;
    }

    protected boolean builtInMetricIsMaximisable(int metricIndex) throws Exception {
        switch (metricIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return true;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return true;
            }
            case 16: {
                return false;
            }
            case 17: {
                return true;
            }
            case 18: {
                return false;
            }
            case 19: {
                return true;
            }
            case 20: {
                return true;
            }
            case 21: {
                return true;
            }
            case 22: {
                return true;
            }
            case 23: {
                return true;
            }
            case 24: {
                return true;
            }
        }
        throw new Exception("Unknown built-in metric");
    }

    protected double getBuiltinMetricValue(int metricIndex, int ... classValIndex) throws Exception {
        boolean hasValIndex = classValIndex != null && classValIndex.length == 1;
        switch (metricIndex) {
            case 0: {
                return this.m_eval.correct();
            }
            case 1: {
                return this.m_eval.incorrect();
            }
            case 2: {
                return this.m_eval.kappa();
            }
            case 3: {
                return this.m_eval.totalCost();
            }
            case 4: {
                return this.m_eval.avgCost();
            }
            case 5: {
                return this.m_eval.KBRelativeInformation();
            }
            case 6: {
                return this.m_eval.KBInformation();
            }
            case 7: {
                return this.m_eval.correlationCoefficient();
            }
            case 8: {
                return this.m_eval.SFPriorEntropy();
            }
            case 9: {
                return this.m_eval.SFSchemeEntropy();
            }
            case 10: {
                return this.m_eval.SFEntropyGain();
            }
            case 11: {
                return this.m_eval.meanAbsoluteError();
            }
            case 12: {
                return this.m_eval.rootMeanSquaredError();
            }
            case 13: {
                return this.m_eval.relativeAbsoluteError();
            }
            case 14: {
                return this.m_eval.rootRelativeSquaredError();
            }
            case 15: {
                return this.m_eval.coverageOfTestCasesByPredictedRegions();
            }
            case 16: {
                return this.m_eval.sizeOfPredictedRegions();
            }
            case 17: {
                return hasValIndex ? this.m_eval.truePositiveRate(classValIndex[0]) : this.m_eval.weightedTruePositiveRate();
            }
            case 18: {
                return hasValIndex ? this.m_eval.falsePositiveRate(classValIndex[0]) : this.m_eval.weightedFalsePositiveRate();
            }
            case 19: {
                return hasValIndex ? this.m_eval.precision(classValIndex[0]) : this.m_eval.weightedPrecision();
            }
            case 20: {
                return hasValIndex ? this.m_eval.recall(classValIndex[0]) : this.m_eval.weightedRecall();
            }
            case 21: {
                return hasValIndex ? this.m_eval.fMeasure(classValIndex[0]) : this.m_eval.weightedFMeasure();
            }
            case 22: {
                return hasValIndex ? this.m_eval.matthewsCorrelationCoefficient(classValIndex[0]) : this.m_eval.weightedMatthewsCorrelation();
            }
            case 23: {
                return hasValIndex ? this.m_eval.areaUnderROC(classValIndex[0]) : this.m_eval.weightedAreaUnderROC();
            }
            case 24: {
                return hasValIndex ? this.m_eval.areaUnderPRC(classValIndex[0]) : this.m_eval.weightedAreaUnderPRC();
            }
        }
        throw new Exception("Unknown built-in metric");
    }

    protected double getPluginMetricValue(AbstractEvaluationMetric m, String statName, int ... classValIndex) throws Exception {
        boolean hasValIndex;
        boolean bl = hasValIndex = classValIndex != null && classValIndex.length == 1;
        if (m instanceof InformationRetrievalEvaluationMetric) {
            return hasValIndex ? ((InformationRetrievalEvaluationMetric)((Object)m)).getStatistic(statName, classValIndex[0]) : ((InformationRetrievalEvaluationMetric)((Object)m)).getClassWeightedAverageStatistic(statName);
        }
        return m.getStatistic(statName);
    }

    protected boolean pluginMetricIsMaximisable(AbstractEvaluationMetric m, String statName) {
        return m.statisticIsMaximisable(statName);
    }

    public double getNamedMetric(String statName, int ... classValIndex) throws Exception {
        if (classValIndex != null && classValIndex.length > 1) {
            throw new IllegalArgumentException("Only one class value index should be supplied");
        }
        Integer builtinIndex = this.m_builtin.get(statName.toLowerCase());
        if (builtinIndex != null) {
            return this.getBuiltinMetricValue(builtinIndex, classValIndex);
        }
        AbstractEvaluationMetric m = this.m_pluginMetrics.get(statName.toLowerCase());
        if (m == null) {
            throw new Exception("Unknown evaluation metric: " + statName);
        }
        return this.getPluginMetricValue(m, statName, classValIndex);
    }

    public double[] getNamedMetricThresholds(String statName) throws Exception {
        Integer builtinIndex = this.m_builtin.get(statName.toLowerCase());
        if (builtinIndex != null) {
            return null;
        }
        AbstractEvaluationMetric m = this.m_pluginMetrics.get(statName.toLowerCase());
        if (m == null) {
            throw new Exception("Unknown evaluation metric: " + statName);
        }
        if (m instanceof ThresholdProducingMetric) {
            return ((ThresholdProducingMetric)((Object)m)).getThresholds();
        }
        return null;
    }

    public boolean metricIsMaximisable(String statName) throws Exception {
        Integer builtinIndex = this.m_builtin.get(statName.toLowerCase());
        if (builtinIndex != null) {
            return this.builtInMetricIsMaximisable(builtinIndex);
        }
        AbstractEvaluationMetric m = this.m_pluginMetrics.get(statName.toLowerCase());
        if (m == null) {
            throw new Exception("Unknown evaluation metric: " + statName);
        }
        return this.pluginMetricIsMaximisable(m, statName);
    }
}

