/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.BatchPredictor;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.CommandlineRunnable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class AbstractClassifier
implements Classifier,
BatchPredictor,
Cloneable,
Serializable,
OptionHandler,
CapabilitiesHandler,
RevisionHandler,
CapabilitiesIgnorer,
CommandlineRunnable {
    private static final long serialVersionUID = 6502780192411755341L;
    protected boolean m_Debug = false;
    protected boolean m_DoNotCheckCapabilities = false;
    public static int NUM_DECIMAL_PLACES_DEFAULT = 2;
    protected int m_numDecimalPlaces = NUM_DECIMAL_PLACES_DEFAULT;
    public static String BATCH_SIZE_DEFAULT = "100";
    protected String m_BatchSize = BATCH_SIZE_DEFAULT;

    public static Classifier forName(String classifierName, String[] options) throws Exception {
        return (AbstractClassifier)Utils.forName(Classifier.class, classifierName, options);
    }

    public static Classifier makeCopy(Classifier model) throws Exception {
        return (Classifier)new SerializedObject(model).getObject();
    }

    public static Classifier[] makeCopies(Classifier model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model classifier set");
        }
        Classifier[] classifiers = new Classifier[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < classifiers.length; ++i) {
            classifiers[i] = (Classifier)so.getObject();
        }
        return classifiers;
    }

    public static void runClassifier(Classifier classifier, String[] options) {
        try {
            if (classifier instanceof CommandlineRunnable) {
                ((CommandlineRunnable)((Object)classifier)).preExecution();
            }
            System.out.println(Evaluation.evaluateModel(classifier, options));
        }
        catch (Exception e2) {
            if (e2.getMessage() != null && e2.getMessage().indexOf("General options") == -1 || e2.getMessage() == null) {
                e2.printStackTrace();
            }
            System.err.println(e2.getMessage());
        }
        if (classifier instanceof CommandlineRunnable) {
            try {
                ((CommandlineRunnable)((Object)classifier)).postExecution();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        if (dist == null) {
            throw new Exception("Null distribution predicted");
        }
        switch (instance.classAttribute().type()) {
            case 1: {
                double max2 = 0.0;
                int maxIndex = 0;
                for (int i = 0; i < dist.length; ++i) {
                    if (!(dist[i] > max2)) continue;
                    maxIndex = i;
                    max2 = dist[i];
                }
                if (max2 > 0.0) {
                    return maxIndex;
                }
                return Utils.missingValue();
            }
            case 0: 
            case 3: {
                return dist[0];
            }
        }
        return Utils.missingValue();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dist = new double[instance.numClasses()];
        switch (instance.classAttribute().type()) {
            case 1: {
                double classification = this.classifyInstance(instance);
                if (Utils.isMissingValue(classification)) {
                    return dist;
                }
                dist[(int)classification] = 1.0;
                return dist;
            }
            case 0: 
            case 3: {
                dist[0] = this.classifyInstance(instance);
                return dist;
            }
        }
        return dist;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = Option.listOptionsForClassHierarchy(this.getClass(), AbstractClassifier.class);
        newVector.addElement(new Option("\tIf set, classifier is run in debug mode and\n\tmay output additional info to the console", "output-debug-info", 0, "-output-debug-info"));
        newVector.addElement(new Option("\tIf set, classifier capabilities are not checked before classifier is built\n\t(use with caution).", "-do-not-check-capabilities", 0, "-do-not-check-capabilities"));
        newVector.addElement(new Option("\tThe number of decimal places for the output of numbers in the model (default " + this.m_numDecimalPlaces + ").", "num-decimal-places", 1, "-num-decimal-places"));
        newVector.addElement(new Option("\tThe desired batch size for batch prediction  (default " + this.m_BatchSize + ").", "batch-size", 1, "-batch-size"));
        return newVector.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        for (String s : Option.getOptionsForHierarchy(this, AbstractClassifier.class)) {
            options.add(s);
        }
        if (this.getDebug()) {
            options.add("-output-debug-info");
        }
        if (this.getDoNotCheckCapabilities()) {
            options.add("-do-not-check-capabilities");
        }
        if (this.getNumDecimalPlaces() != NUM_DECIMAL_PLACES_DEFAULT) {
            options.add("-num-decimal-places");
            options.add("" + this.getNumDecimalPlaces());
        }
        if (!this.getBatchSize().equals(BATCH_SIZE_DEFAULT)) {
            options.add("-batch-size");
            options.add("" + this.getBatchSize());
        }
        return options.toArray(new String[0]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        Option.setOptionsForHierarchy(options, this, AbstractClassifier.class);
        this.setDebug(Utils.getFlag("output-debug-info", options));
        this.setDoNotCheckCapabilities(Utils.getFlag("do-not-check-capabilities", options));
        String optionString = Utils.getOption("num-decimal-places", options);
        if (optionString.length() != 0) {
            this.setNumDecimalPlaces(new Integer(optionString));
        }
        if ((optionString = Utils.getOption("batch-size", options)).length() != 0) {
            this.setBatchSize(optionString);
        }
        Utils.checkForRemainingOptions(options);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setDebug(boolean debug2) {
        this.m_Debug = debug2;
    }

    public String debugTipText() {
        return "If set to true, classifier may output additional info to the console.";
    }

    @Override
    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    @Override
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    public String doNotCheckCapabilitiesTipText() {
        return "If set, classifier capabilities are not checked before classifier is built (Use with caution to reduce runtime).";
    }

    public String numDecimalPlacesTipText() {
        return "The number of decimal places to be used for the output of numbers in the model.";
    }

    public int getNumDecimalPlaces() {
        return this.m_numDecimalPlaces;
    }

    public void setNumDecimalPlaces(int num) {
        this.m_numDecimalPlaces = num;
    }

    public String batchSizeTipText() {
        return "The preferred number of instances to process if batch prediction is being performed. More or fewer instances may be provided, but this gives implementations a chance to specify a preferred batch size.";
    }

    @Override
    public void setBatchSize(String size) {
        this.m_BatchSize = size;
    }

    @Override
    public String getBatchSize() {
        return this.m_BatchSize;
    }

    @Override
    public boolean implementsMoreEfficientBatchPrediction() {
        return false;
    }

    @Override
    public double[][] distributionsForInstances(Instances batch) throws Exception {
        double[][] batchPreds = new double[batch.numInstances()][];
        for (int i = 0; i < batch.numInstances(); ++i) {
            batchPreds[i] = this.distributionForInstance(batch.instance(i));
        }
        return batchPreds;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15520 $");
    }

    @Override
    public void preExecution() throws Exception {
    }

    @Override
    public void run(Object toRun, String[] options) throws Exception {
        if (!(toRun instanceof Classifier)) {
            throw new IllegalArgumentException("Object to run is not a Classifier!");
        }
        AbstractClassifier.runClassifier((Classifier)toRun, options);
    }

    @Override
    public void postExecution() throws Exception {
    }
}

