/*
 * Decompiled with CFR 0.152.
 */
package spark.route;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.FilterImpl;
import spark.RouteImpl;
import spark.route.HttpMethod;
import spark.route.RouteEntry;
import spark.routematch.RouteMatch;
import spark.utils.MimeParse;
import spark.utils.StringUtils;

public class Routes {
    private static final Logger LOG = LoggerFactory.getLogger(Routes.class);
    private static final char SINGLE_QUOTE = '\'';
    private List<RouteEntry> routes = new ArrayList<RouteEntry>();

    public static Routes create() {
        return new Routes();
    }

    protected Routes() {
    }

    public void add(HttpMethod httpMethod, RouteImpl route) {
        this.add(httpMethod, route.getPath(), route.getAcceptType(), route);
    }

    public void add(HttpMethod httpMethod, FilterImpl filter) {
        this.add(httpMethod, filter.getPath(), filter.getAcceptType(), filter);
    }

    public RouteMatch find(HttpMethod httpMethod, String path, String acceptType) {
        List<RouteEntry> routeEntries = this.findTargetsForRequestedRoute(httpMethod, path);
        RouteEntry entry = this.findTargetWithGivenAcceptType(routeEntries, acceptType);
        return entry != null ? new RouteMatch(entry.target, entry.path, path, acceptType, httpMethod) : null;
    }

    public List<RouteMatch> findMultiple(HttpMethod httpMethod, String path, String acceptType) {
        ArrayList<RouteMatch> matchSet = new ArrayList<RouteMatch>();
        List<RouteEntry> routeEntries = this.findTargetsForRequestedRoute(httpMethod, path);
        for (RouteEntry routeEntry : routeEntries) {
            if (acceptType != null) {
                String bestMatch = MimeParse.bestMatch(Arrays.asList(routeEntry.acceptedType), acceptType);
                if (!this.routeWithGivenAcceptType(bestMatch)) continue;
                matchSet.add(new RouteMatch(routeEntry.target, routeEntry.path, path, acceptType, httpMethod));
                continue;
            }
            matchSet.add(new RouteMatch(routeEntry.target, routeEntry.path, path, acceptType, httpMethod));
        }
        return matchSet;
    }

    public List<RouteMatch> findAll() {
        ArrayList<RouteMatch> matchSet = new ArrayList<RouteMatch>();
        List<RouteEntry> routeEntries = this.routes;
        for (RouteEntry routeEntry : routeEntries) {
            matchSet.add(new RouteMatch(routeEntry.target, routeEntry.path, "ALL_ROUTES", routeEntry.acceptedType, routeEntry.httpMethod));
        }
        return matchSet;
    }

    public void clear() {
        this.routes.clear();
    }

    public boolean remove(String path, String httpMethod) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("path cannot be null or blank");
        }
        if (StringUtils.isEmpty(httpMethod)) {
            throw new IllegalArgumentException("httpMethod cannot be null or blank");
        }
        HttpMethod method = HttpMethod.valueOf(httpMethod);
        return this.removeRoute(method, path);
    }

    public boolean remove(String path) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("path cannot be null or blank");
        }
        return this.removeRoute(null, path);
    }

    private void add(HttpMethod method, String url, String acceptedType, Object target) {
        RouteEntry entry = new RouteEntry();
        entry.httpMethod = method;
        entry.path = url;
        entry.target = target;
        entry.acceptedType = acceptedType;
        LOG.debug("Adds route: " + entry);
        this.routes.add(entry);
    }

    private Map<String, RouteEntry> getAcceptedMimeTypes(List<RouteEntry> routes) {
        HashMap<String, RouteEntry> acceptedTypes = new HashMap<String, RouteEntry>();
        for (RouteEntry routeEntry : routes) {
            if (acceptedTypes.containsKey(routeEntry.acceptedType)) continue;
            acceptedTypes.put(routeEntry.acceptedType, routeEntry);
        }
        return acceptedTypes;
    }

    private boolean routeWithGivenAcceptType(String bestMatch) {
        return !"".equals(bestMatch);
    }

    private List<RouteEntry> findTargetsForRequestedRoute(HttpMethod httpMethod, String path) {
        ArrayList<RouteEntry> matchSet = new ArrayList<RouteEntry>();
        for (RouteEntry entry : this.routes) {
            if (!entry.matches(httpMethod, path)) continue;
            matchSet.add(entry);
        }
        return matchSet;
    }

    private RouteEntry findTargetWithGivenAcceptType(List<RouteEntry> routeMatches, String acceptType) {
        if (acceptType != null && routeMatches.size() > 0) {
            Map<String, RouteEntry> acceptedMimeTypes = this.getAcceptedMimeTypes(routeMatches);
            String bestMatch = MimeParse.bestMatch(acceptedMimeTypes.keySet(), acceptType);
            if (this.routeWithGivenAcceptType(bestMatch)) {
                return acceptedMimeTypes.get(bestMatch);
            }
            return null;
        }
        if (routeMatches.size() > 0) {
            return routeMatches.get(0);
        }
        return null;
    }

    private boolean removeRoute(HttpMethod httpMethod, String path) {
        ArrayList<RouteEntry> forRemoval = new ArrayList<RouteEntry>();
        for (RouteEntry routeEntry : this.routes) {
            HttpMethod httpMethodToMatch = httpMethod;
            if (httpMethod == null) {
                httpMethodToMatch = routeEntry.httpMethod;
            }
            if (!routeEntry.matches(httpMethodToMatch, path)) continue;
            LOG.debug("Removing path {}", (Object)path, (Object)(httpMethod == null ? "" : " with HTTP method " + (Object)((Object)httpMethod)));
            forRemoval.add(routeEntry);
        }
        return this.routes.removeAll(forRemoval);
    }

    @Deprecated
    public void add(String route, String acceptType, Object target) {
        try {
            HttpMethod method;
            int singleQuoteIndex = route.indexOf(39);
            String httpMethod = route.substring(0, singleQuoteIndex).trim().toLowerCase();
            String url = route.substring(singleQuoteIndex + 1, route.length() - 1).trim();
            try {
                method = HttpMethod.valueOf(httpMethod);
            }
            catch (IllegalArgumentException e2) {
                LOG.error("The @Route value: " + route + " has an invalid HTTP method part: " + httpMethod + ".");
                return;
            }
            this.add(method, url, acceptType, target);
        }
        catch (Exception e3) {
            LOG.error("The @Route value: " + route + " is not in the correct format", e3);
        }
    }
}

