/*
 * Decompiled with CFR 0.152.
 */
package spark.http.matching;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.CustomErrorPages;
import spark.ExceptionHandlerImpl;
import spark.ExceptionMapper;
import spark.RequestResponseFactory;
import spark.http.matching.Body;
import spark.http.matching.RequestWrapper;
import spark.http.matching.ResponseWrapper;

final class GeneralError {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralError.class);

    GeneralError() {
    }

    static void modify(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Body body, RequestWrapper requestWrapper, ResponseWrapper responseWrapper, ExceptionMapper exceptionMapper, Exception e2) {
        ExceptionHandlerImpl handler = exceptionMapper.getHandler(e2);
        if (handler != null) {
            handler.handle(e2, requestWrapper, responseWrapper);
            String bodyAfterFilter = responseWrapper.getDelegate().body();
            if (bodyAfterFilter != null) {
                body.set(bodyAfterFilter);
            }
        } else {
            LOG.error("", e2);
            httpResponse.setStatus(500);
            if (CustomErrorPages.existsFor(500)) {
                requestWrapper.setDelegate(RequestResponseFactory.create(httpRequest));
                responseWrapper.setDelegate(RequestResponseFactory.create(httpResponse));
                body.set(CustomErrorPages.getFor(500, requestWrapper, responseWrapper));
            } else {
                body.set("<html><body><h2>500 Internal Server Error</h2></body></html>");
            }
        }
    }
}

