/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.CustomErrorPages;
import spark.ExceptionHandler;
import spark.ExceptionHandlerImpl;
import spark.ExceptionMapper;
import spark.Experimental;
import spark.FilterImpl;
import spark.HaltException;
import spark.Redirect;
import spark.Request;
import spark.Response;
import spark.Routable;
import spark.Route;
import spark.RouteGroup;
import spark.RouteImpl;
import spark.embeddedserver.EmbeddedServer;
import spark.embeddedserver.EmbeddedServers;
import spark.embeddedserver.jetty.websocket.WebSocketHandlerClassWrapper;
import spark.embeddedserver.jetty.websocket.WebSocketHandlerInstanceWrapper;
import spark.embeddedserver.jetty.websocket.WebSocketHandlerWrapper;
import spark.globalstate.ServletFlag;
import spark.route.HttpMethod;
import spark.route.Routes;
import spark.route.ServletRoutes;
import spark.routematch.RouteMatch;
import spark.ssl.SslStores;
import spark.staticfiles.MimeType;
import spark.staticfiles.StaticFilesConfiguration;

public final class Service
extends Routable {
    private static final Logger LOG = LoggerFactory.getLogger("spark.Spark");
    public static final int SPARK_DEFAULT_PORT = 4567;
    protected static final String DEFAULT_ACCEPT_TYPE = "*/*";
    protected boolean initialized = false;
    protected int port = 4567;
    protected String ipAddress = "0.0.0.0";
    protected SslStores sslStores;
    protected Map<String, WebSocketHandlerWrapper> webSocketHandlers = null;
    protected int maxThreads = -1;
    protected int minThreads = -1;
    protected int threadIdleTimeoutMillis = -1;
    protected Optional<Integer> webSocketIdleTimeoutMillis = Optional.empty();
    protected EmbeddedServer server;
    protected Deque<String> pathDeque = new ArrayDeque<String>();
    protected Routes routes;
    private CountDownLatch initLatch = new CountDownLatch(1);
    private CountDownLatch stopLatch = new CountDownLatch(0);
    private Object embeddedServerIdentifier = EmbeddedServers.defaultIdentifier();
    public final Redirect redirect;
    public final StaticFiles staticFiles;
    private final StaticFilesConfiguration staticFilesConfiguration;
    private final ExceptionMapper exceptionMapper = new ExceptionMapper();
    private Consumer<Exception> initExceptionHandler = e2 -> {
        LOG.error("ignite failed", (Throwable)e2);
        System.exit(100);
    };

    public static Service ignite() {
        return new Service();
    }

    private Service() {
        this.redirect = Redirect.create(this);
        this.staticFiles = new StaticFiles();
        this.staticFilesConfiguration = ServletFlag.isRunningFromServlet() ? StaticFilesConfiguration.servletInstance : StaticFilesConfiguration.create();
    }

    public synchronized void embeddedServerIdentifier(Object obj) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.embeddedServerIdentifier = obj;
    }

    public synchronized Object embeddedServerIdentifier() {
        return this.embeddedServerIdentifier;
    }

    public synchronized Service ipAddress(String ipAddress) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.ipAddress = ipAddress;
        return this;
    }

    public synchronized Service port(int port) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.port = port;
        return this;
    }

    public synchronized int port() {
        if (this.initialized) {
            return this.port;
        }
        throw new IllegalStateException("This must be done after route mapping has begun");
    }

    public synchronized Service secure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        return this.secure(keystoreFile, keystorePassword, null, truststoreFile, truststorePassword, false);
    }

    public synchronized Service secure(String keystoreFile, String keystorePassword, String certAlias, String truststoreFile, String truststorePassword) {
        return this.secure(keystoreFile, keystorePassword, certAlias, truststoreFile, truststorePassword, false);
    }

    public synchronized Service secure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword, boolean needsClientCert) {
        return this.secure(keystoreFile, keystorePassword, null, truststoreFile, truststorePassword, needsClientCert);
    }

    public synchronized Service secure(String keystoreFile, String keystorePassword, String certAlias, String truststoreFile, String truststorePassword, boolean needsClientCert) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (keystoreFile == null) {
            throw new IllegalArgumentException("Must provide a keystore file to run secured");
        }
        this.sslStores = SslStores.create(keystoreFile, keystorePassword, certAlias, truststoreFile, truststorePassword, needsClientCert);
        return this;
    }

    public synchronized Service threadPool(int maxThreads) {
        return this.threadPool(maxThreads, -1, -1);
    }

    public synchronized Service threadPool(int maxThreads, int minThreads, int idleTimeoutMillis) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.maxThreads = maxThreads;
        this.minThreads = minThreads;
        this.threadIdleTimeoutMillis = idleTimeoutMillis;
        return this;
    }

    public synchronized Service staticFileLocation(String folder) {
        if (this.initialized && !ServletFlag.isRunningFromServlet()) {
            this.throwBeforeRouteMappingException();
        }
        if (!this.staticFilesConfiguration.isStaticResourcesSet()) {
            this.staticFilesConfiguration.configure(folder);
        } else {
            LOG.warn("Static file location has already been set");
        }
        return this;
    }

    public synchronized Service externalStaticFileLocation(String externalFolder) {
        if (this.initialized && !ServletFlag.isRunningFromServlet()) {
            this.throwBeforeRouteMappingException();
        }
        if (!this.staticFilesConfiguration.isExternalStaticResourcesSet()) {
            this.staticFilesConfiguration.configureExternal(externalFolder);
        } else {
            LOG.warn("External static file location has already been set");
        }
        return this;
    }

    public boolean unmap(String path) {
        return this.routes.remove(path);
    }

    public boolean unmap(String path, String httpMethod) {
        return this.routes.remove(path, httpMethod);
    }

    public void webSocket(String path, Class<?> handlerClass) {
        this.addWebSocketHandler(path, new WebSocketHandlerClassWrapper(handlerClass));
    }

    public void webSocket(String path, Object handler) {
        this.addWebSocketHandler(path, new WebSocketHandlerInstanceWrapper(handler));
    }

    private synchronized void addWebSocketHandler(String path, WebSocketHandlerWrapper handlerWrapper) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (ServletFlag.isRunningFromServlet()) {
            throw new IllegalStateException("WebSockets are only supported in the embedded server");
        }
        Objects.requireNonNull(path, "WebSocket path cannot be null");
        if (this.webSocketHandlers == null) {
            this.webSocketHandlers = new HashMap<String, WebSocketHandlerWrapper>();
        }
        this.webSocketHandlers.put(path, handlerWrapper);
    }

    public synchronized Service webSocketIdleTimeoutMillis(int timeoutMillis) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (ServletFlag.isRunningFromServlet()) {
            throw new IllegalStateException("WebSockets are only supported in the embedded server");
        }
        this.webSocketIdleTimeoutMillis = Optional.of(timeoutMillis);
        return this;
    }

    public synchronized void notFound(String page) {
        CustomErrorPages.add(404, page);
    }

    public synchronized void internalServerError(String page) {
        CustomErrorPages.add(500, page);
    }

    public synchronized void notFound(Route route) {
        CustomErrorPages.add(404, route);
    }

    public synchronized void internalServerError(Route route) {
        CustomErrorPages.add(500, route);
    }

    public void awaitInitialization() {
        if (!this.initialized) {
            throw new IllegalStateException("Server has not been properly initialized");
        }
        try {
            this.initLatch.await();
        }
        catch (InterruptedException e2) {
            LOG.info("Interrupted by another thread");
            Thread.currentThread().interrupt();
        }
    }

    private void throwBeforeRouteMappingException() {
        throw new IllegalStateException("This must be done before route mapping has begun");
    }

    private boolean hasMultipleHandlers() {
        return this.webSocketHandlers != null;
    }

    public synchronized void stop() {
        if (!this.initialized) {
            return;
        }
        this.initiateStop();
    }

    public void awaitStop() {
        try {
            this.stopLatch.await();
        }
        catch (InterruptedException e2) {
            LOG.warn("Interrupted by another thread");
            Thread.currentThread().interrupt();
        }
    }

    private void initiateStop() {
        this.stopLatch = new CountDownLatch(1);
        Thread stopThread = new Thread(() -> {
            if (this.server != null) {
                this.server.extinguish();
                this.initLatch = new CountDownLatch(1);
            }
            this.routes.clear();
            this.exceptionMapper.clear();
            this.staticFilesConfiguration.clear();
            this.initialized = false;
            this.stopLatch.countDown();
        });
        stopThread.start();
    }

    public void path(String path, RouteGroup routeGroup) {
        this.pathDeque.addLast(path);
        routeGroup.addRoutes();
        this.pathDeque.removeLast();
    }

    public String getPaths() {
        return this.pathDeque.stream().collect(Collectors.joining(""));
    }

    public List<RouteMatch> routes() {
        return this.routes.findAll();
    }

    @Override
    public void addRoute(HttpMethod httpMethod, RouteImpl route) {
        this.init();
        this.routes.add(httpMethod, route.withPrefix(this.getPaths()));
    }

    @Override
    public void addFilter(HttpMethod httpMethod, FilterImpl filter) {
        this.init();
        this.routes.add(httpMethod, filter.withPrefix(this.getPaths()));
    }

    @Override
    @Deprecated
    public void addRoute(String httpMethod, RouteImpl route) {
        this.init();
        this.routes.add(httpMethod + " '" + this.getPaths() + route.getPath() + "'", route.getAcceptType(), route);
    }

    @Override
    @Deprecated
    public void addFilter(String httpMethod, FilterImpl filter) {
        this.init();
        this.routes.add(httpMethod + " '" + this.getPaths() + filter.getPath() + "'", filter.getAcceptType(), filter);
    }

    public synchronized void init() {
        if (!this.initialized) {
            this.initializeRouteMatcher();
            if (!ServletFlag.isRunningFromServlet()) {
                new Thread(() -> {
                    try {
                        EmbeddedServers.initialize();
                        if (this.embeddedServerIdentifier == null) {
                            this.embeddedServerIdentifier = EmbeddedServers.defaultIdentifier();
                        }
                        this.server = EmbeddedServers.create(this.embeddedServerIdentifier, this.routes, this.exceptionMapper, this.staticFilesConfiguration, this.hasMultipleHandlers());
                        this.server.configureWebSockets(this.webSocketHandlers, this.webSocketIdleTimeoutMillis);
                        this.port = this.server.ignite(this.ipAddress, this.port, this.sslStores, this.maxThreads, this.minThreads, this.threadIdleTimeoutMillis);
                    }
                    catch (Exception e2) {
                        this.initExceptionHandler.accept(e2);
                    }
                    try {
                        this.initLatch.countDown();
                        this.server.join();
                    }
                    catch (InterruptedException e3) {
                        LOG.error("server interrupted", e3);
                        Thread.currentThread().interrupt();
                    }
                }).start();
            }
            this.initialized = true;
        }
    }

    private void initializeRouteMatcher() {
        this.routes = ServletFlag.isRunningFromServlet() ? ServletRoutes.get() : Routes.create();
    }

    public synchronized int activeThreadCount() {
        if (this.server != null) {
            return this.server.activeThreadCount();
        }
        return 0;
    }

    public synchronized <T extends Exception> void exception(Class<T> exceptionClass, final ExceptionHandler<? super T> handler) {
        ExceptionHandlerImpl wrapper = new ExceptionHandlerImpl<T>(exceptionClass){

            @Override
            public void handle(T exception, Request request, Response response) {
                handler.handle(exception, request, response);
            }
        };
        this.exceptionMapper.map(exceptionClass, wrapper);
    }

    public HaltException halt() {
        throw new HaltException();
    }

    public HaltException halt(int status) {
        throw new HaltException(status);
    }

    public HaltException halt(String body) {
        throw new HaltException(body);
    }

    public HaltException halt(int status, String body) {
        throw new HaltException(status, body);
    }

    public void initExceptionHandler(Consumer<Exception> initExceptionHandler) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.initExceptionHandler = initExceptionHandler;
    }

    public final class StaticFiles {
        public void location(String folder) {
            Service.this.staticFileLocation(folder);
        }

        public void externalLocation(String externalFolder) {
            Service.this.externalStaticFileLocation(externalFolder);
        }

        public void headers(Map<String, String> headers) {
            Service.this.staticFilesConfiguration.putCustomHeaders(headers);
        }

        public void header(String key, String value) {
            Service.this.staticFilesConfiguration.putCustomHeader(key, value);
        }

        @Experimental(value="Functionality will not be removed. The API might change")
        public void expireTime(long seconds) {
            Service.this.staticFilesConfiguration.setExpireTimeSeconds(seconds);
        }

        public void registerMimeType(String extension, String mimeType) {
            MimeType.register(extension, mimeType);
        }

        public void disableMimeTypeGuessing() {
            MimeType.disableGuessing();
        }
    }
}

