/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseImporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.AttributeType;
import org.jgrapht.io.DefaultAttribute;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.JsonBaseListener;
import org.jgrapht.io.JsonLexer;
import org.jgrapht.io.JsonParser;
import org.jgrapht.io.VertexProvider;
import org.jgrapht.util.SupplierUtil;

@Deprecated
public class JSONImporter<V, E>
extends AbstractBaseImporter<V, E>
implements GraphImporter<V, E> {
    public JSONImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        super(vertexProvider, edgeProvider);
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        try {
            ThrowingErrorListener errorListener = new ThrowingErrorListener();
            JsonLexer lexer = new JsonLexer(CharStreams.fromReader(input));
            lexer.removeErrorListeners();
            lexer.addErrorListener(errorListener);
            JsonParser parser2 = new JsonParser(new CommonTokenStream(lexer));
            parser2.removeErrorListeners();
            parser2.addErrorListener(errorListener);
            JsonParser.JsonContext graphContext = parser2.json();
            ParseTreeWalker walker = new ParseTreeWalker();
            CreateGraphJsonListener listener = new CreateGraphJsonListener();
            walker.walk(listener, graphContext);
            listener.updateGraph(graph);
        }
        catch (IOException e2) {
            throw new ImportException("Failed to import json graph: " + e2.getMessage(), e2);
        }
        catch (ParseCancellationException pe) {
            throw new ImportException("Failed to import json graph: " + pe.getMessage(), pe);
        }
        catch (IllegalArgumentException iae) {
            throw new ImportException("Failed to import json graph: " + iae.getMessage(), iae);
        }
    }

    private static class PartialEdge {
        String source;
        String target;
        Map<String, Attribute> attributes;

        public PartialEdge(String source, String target, Map<String, Attribute> attributes) {
            this.source = source;
            this.target = target;
            this.attributes = attributes;
        }
    }

    private static class Node {
        Map<String, Attribute> attributes;

        public Node(Map<String, Attribute> attributes) {
            this.attributes = attributes;
        }
    }

    private class CreateGraphJsonListener
    extends JsonBaseListener {
        private static final String GRAPH = "graph";
        private static final String NODES = "nodes";
        private static final String EDGES = "edges";
        private static final String ID = "id";
        private static final String WEIGHT = "weight";
        private static final String SOURCE = "source";
        private static final String TARGET = "target";
        private int objectLevel;
        private int arrayLevel;
        private boolean insideNodes;
        private boolean insideNodesArray;
        private boolean insideNode;
        private boolean insideEdges;
        private boolean insideEdgesArray;
        private boolean insideEdge;
        private Deque<String> pairNames;
        private String nodeId;
        private String sourceId;
        private String targetId;
        private Map<String, Attribute> attributes;
        private Map<String, Node> nodes;
        private List<Node> singletons;
        private List<PartialEdge> edges;

        private CreateGraphJsonListener() {
        }

        public void updateGraph(Graph<V, E> graph) throws ImportException {
            boolean isWeighted = graph.getType().isWeighted();
            HashMap map = new HashMap();
            for (String string : this.nodes.keySet()) {
                Node n = this.nodes.get(string);
                Object vertex = JSONImporter.this.vertexProvider.buildVertex(string, n.attributes);
                map.put(string, vertex);
                graph.addVertex(vertex);
            }
            if (!this.singletons.isEmpty()) {
                Supplier<String> singletonIdSupplier = SupplierUtil.createRandomUUIDStringSupplier();
                for (Node n : this.singletons) {
                    graph.addVertex(JSONImporter.this.vertexProvider.buildVertex(singletonIdSupplier.get(), n.attributes));
                }
            }
            for (PartialEdge partialEdge : this.edges) {
                AttributeType type;
                Attribute weight;
                String label = "e_" + partialEdge.source + "_" + partialEdge.target;
                Object from = map.get(partialEdge.source);
                if (from == null) {
                    throw new ImportException("Node " + partialEdge.source + " does not exist");
                }
                Object to = map.get(partialEdge.target);
                if (to == null) {
                    throw new ImportException("Node " + partialEdge.target + " does not exist");
                }
                Object e2 = JSONImporter.this.edgeProvider.buildEdge(from, to, label, partialEdge.attributes);
                graph.addEdge(from, to, e2);
                if (!isWeighted || (weight = partialEdge.attributes.get(WEIGHT)) == null || !(type = weight.getType()).equals((Object)AttributeType.FLOAT) && !type.equals((Object)AttributeType.DOUBLE)) continue;
                graph.setEdgeWeight(e2, Double.parseDouble(weight.getValue()));
            }
        }

        @Override
        public void enterJson(JsonParser.JsonContext ctx) {
            this.objectLevel = 0;
            this.arrayLevel = 0;
            this.insideNodes = false;
            this.insideNodesArray = false;
            this.insideNode = false;
            this.insideEdges = false;
            this.insideEdgesArray = false;
            this.insideEdge = false;
            this.nodes = new LinkedHashMap<String, Node>();
            this.singletons = new ArrayList<Node>();
            this.edges = new ArrayList<PartialEdge>();
            this.pairNames = new ArrayDeque<String>();
            this.pairNames.push(GRAPH);
        }

        @Override
        public void enterObj(JsonParser.ObjContext ctx) {
            ++this.objectLevel;
            if (this.objectLevel == 2 && this.arrayLevel == 1) {
                if (this.insideNodesArray) {
                    this.insideNode = true;
                    this.nodeId = null;
                    this.attributes = new HashMap<String, Attribute>();
                } else if (this.insideEdgesArray) {
                    this.insideEdge = true;
                    this.sourceId = null;
                    this.targetId = null;
                    this.attributes = new HashMap<String, Attribute>();
                }
            }
        }

        @Override
        public void exitObj(JsonParser.ObjContext ctx) {
            if (this.objectLevel == 2 && this.arrayLevel == 1) {
                if (this.insideNodesArray) {
                    if (this.nodeId == null) {
                        this.singletons.add(new Node(this.attributes));
                    } else if (this.nodes.put(this.nodeId, new Node(this.attributes)) != null) {
                        throw new IllegalArgumentException("Duplicate node id " + this.nodeId);
                    }
                    this.insideNode = false;
                    this.attributes = null;
                } else if (this.insideEdgesArray) {
                    if (this.sourceId == null || this.targetId == null) {
                        if (this.sourceId == null) {
                            throw new IllegalArgumentException("Edge with missing source detected");
                        }
                        throw new IllegalArgumentException("Edge with missing target detected");
                    }
                    this.edges.add(new PartialEdge(this.sourceId, this.targetId, this.attributes));
                    this.insideEdge = false;
                    this.attributes = null;
                }
            }
            --this.objectLevel;
        }

        @Override
        public void enterArray(JsonParser.ArrayContext ctx) {
            ++this.arrayLevel;
            if (this.insideNodes && this.objectLevel == 1 && this.arrayLevel == 1) {
                this.insideNodesArray = true;
            } else if (this.insideEdges && this.objectLevel == 1 && this.arrayLevel == 1) {
                this.insideEdgesArray = true;
            }
        }

        @Override
        public void exitArray(JsonParser.ArrayContext ctx) {
            if (this.insideNodes && this.objectLevel == 1 && this.arrayLevel == 1) {
                this.insideNodesArray = false;
            } else if (this.insideEdges && this.objectLevel == 1 && this.arrayLevel == 1) {
                this.insideEdgesArray = false;
            }
            --this.arrayLevel;
        }

        @Override
        public void enterPair(JsonParser.PairContext ctx) {
            String name = this.unquote(ctx.STRING().getText());
            if (this.objectLevel == 1 && this.arrayLevel == 0) {
                if (NODES.equals(name)) {
                    this.insideNodes = true;
                } else if (EDGES.equals(name)) {
                    this.insideEdges = true;
                }
            }
            this.pairNames.push(name);
        }

        @Override
        public void exitPair(JsonParser.PairContext ctx) {
            String name = this.unquote(ctx.STRING().getText());
            if (this.objectLevel == 1 && this.arrayLevel == 0) {
                if (NODES.equals(name)) {
                    this.insideNodes = false;
                } else if (EDGES.equals(name)) {
                    this.insideEdges = false;
                }
            }
            this.pairNames.pop();
        }

        @Override
        public void enterValue(JsonParser.ValueContext ctx) {
            String name = this.pairNames.element();
            if (this.objectLevel == 2 && this.arrayLevel < 2) {
                if (this.insideNode) {
                    if (ID.equals(name)) {
                        this.nodeId = this.readIdentifier(ctx);
                    } else {
                        this.attributes.put(name, this.readAttribute(ctx));
                    }
                } else if (this.insideEdge) {
                    if (SOURCE.equals(name)) {
                        this.sourceId = this.readIdentifier(ctx);
                    } else if (TARGET.equals(name)) {
                        this.targetId = this.readIdentifier(ctx);
                    } else {
                        this.attributes.put(name, this.readAttribute(ctx));
                    }
                }
            }
        }

        private Attribute readAttribute(JsonParser.ValueContext ctx) {
            String other;
            String stringValue = this.readString(ctx);
            if (stringValue != null) {
                return DefaultAttribute.createAttribute(stringValue);
            }
            TerminalNode tn = ctx.NUMBER();
            if (tn != null) {
                String value = tn.getText();
                try {
                    return DefaultAttribute.createAttribute(Integer.parseInt(value, 10));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return DefaultAttribute.createAttribute(Long.parseLong(value, 10));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            return DefaultAttribute.createAttribute(Double.parseDouble(value));
                        }
                        catch (NumberFormatException numberFormatException3) {
                            // empty catch block
                        }
                    }
                }
            }
            if ((other = ctx.getText()) != null) {
                if ("true".equals(other)) {
                    return DefaultAttribute.createAttribute(Boolean.TRUE);
                }
                if ("false".equals(other)) {
                    return DefaultAttribute.createAttribute(Boolean.FALSE);
                }
                if ("null".equals(other)) {
                    return DefaultAttribute.NULL;
                }
                return new DefaultAttribute<String>(other, AttributeType.UNKNOWN);
            }
            return DefaultAttribute.NULL;
        }

        private String unquote(String value) {
            if (value.startsWith("\"") && value.endsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }

        private String readString(JsonParser.ValueContext ctx) {
            TerminalNode tn = ctx.STRING();
            if (tn == null) {
                return null;
            }
            return this.unquote(tn.getText());
        }

        private String readIdentifier(JsonParser.ValueContext ctx) {
            TerminalNode tn = ctx.STRING();
            if (tn != null) {
                return this.unquote(tn.getText());
            }
            tn = ctx.NUMBER();
            if (tn == null) {
                return null;
            }
            try {
                return Long.valueOf(tn.getText(), 10).toString();
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Failed to read valid identifier");
            }
        }
    }

    private class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e2) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

