/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.text.StringEscapeUtils;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseImporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.AttributeType;
import org.jgrapht.io.DefaultAttribute;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.GmlBaseListener;
import org.jgrapht.io.GmlLexer;
import org.jgrapht.io.GmlParser;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.VertexProvider;

@Deprecated
public class GmlImporter<V, E>
extends AbstractBaseImporter<V, E>
implements GraphImporter<V, E> {
    public GmlImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        super(vertexProvider, edgeProvider);
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        try {
            ThrowingErrorListener errorListener = new ThrowingErrorListener();
            GmlLexer lexer = new GmlLexer(CharStreams.fromReader(input));
            lexer.removeErrorListeners();
            lexer.addErrorListener(errorListener);
            GmlParser parser2 = new GmlParser(new CommonTokenStream(lexer));
            parser2.removeErrorListeners();
            parser2.addErrorListener(errorListener);
            GmlParser.GmlContext graphContext = parser2.gml();
            ParseTreeWalker walker = new ParseTreeWalker();
            CreateGraphGmlListener listener = new CreateGraphGmlListener();
            walker.walk(listener, graphContext);
            listener.updateGraph(graph);
        }
        catch (IOException e2) {
            throw new ImportException("Failed to import gml graph: " + e2.getMessage(), e2);
        }
        catch (ParseCancellationException pe) {
            throw new ImportException("Failed to import gml graph: " + pe.getMessage(), pe);
        }
        catch (IllegalArgumentException iae) {
            throw new ImportException("Failed to import gml graph: " + iae.getMessage(), iae);
        }
    }

    private class PartialEdge {
        Integer source;
        Integer target;
        Double weight;
        Map<String, Attribute> attributes;

        public PartialEdge(Integer source, Integer target, Double weight, Map<String, Attribute> attributes) {
            this.source = source;
            this.target = target;
            this.weight = weight;
            this.attributes = attributes;
        }
    }

    private class Node {
        Map<String, Attribute> attributes;

        public Node(Map<String, Attribute> attributes) {
            this.attributes = attributes;
        }
    }

    private class CreateGraphGmlListener
    extends GmlBaseListener {
        private static final String NODE = "node";
        private static final String EDGE = "edge";
        private static final String GRAPH = "graph";
        private static final String WEIGHT = "weight";
        private static final String ID = "id";
        private static final String SOURCE = "source";
        private static final String TARGET = "target";
        private boolean foundGraph;
        private boolean insideGraph;
        private boolean insideNode;
        private boolean insideEdge;
        private int level;
        private Integer nodeId;
        private Integer sourceId;
        private Integer targetId;
        private Double weight;
        private Map<String, Attribute> attributes;
        private StringBuilder stringBuffer;
        private Map<Integer, Node> nodes;
        private List<Node> singletons;
        private List<PartialEdge> edges;

        private CreateGraphGmlListener() {
        }

        public void updateGraph(Graph<V, E> graph) throws ImportException {
            if (this.foundGraph) {
                boolean isWeighted = graph.getType().isWeighted();
                int maxVertexId = 1;
                HashMap map = new HashMap();
                for (Integer id : this.nodes.keySet()) {
                    Node n = this.nodes.get(id);
                    maxVertexId = Math.max(maxVertexId, id);
                    Object vertex = GmlImporter.this.vertexProvider.buildVertex(id.toString(), n.attributes);
                    map.put(id, vertex);
                    graph.addVertex(vertex);
                }
                for (Node n : this.singletons) {
                    String id = String.valueOf(++maxVertexId);
                    graph.addVertex(GmlImporter.this.vertexProvider.buildVertex(id, n.attributes));
                }
                for (PartialEdge pe : this.edges) {
                    String label = "e_" + pe.source + "_" + pe.target;
                    Object from = map.get(pe.source);
                    if (from == null) {
                        throw new ImportException("Node " + pe.source + " does not exist");
                    }
                    Object to = map.get(pe.target);
                    if (to == null) {
                        throw new ImportException("Node " + pe.target + " does not exist");
                    }
                    Object e2 = GmlImporter.this.edgeProvider.buildEdge(from, to, label, pe.attributes);
                    graph.addEdge(from, to, e2);
                    if (pe.weight == null || !isWeighted) continue;
                    graph.setEdgeWeight(e2, pe.weight);
                }
            }
        }

        @Override
        public void enterGml(GmlParser.GmlContext ctx) {
            this.foundGraph = false;
            this.insideGraph = false;
            this.insideNode = false;
            this.insideEdge = false;
            this.nodes = new HashMap<Integer, Node>();
            this.singletons = new ArrayList<Node>();
            this.edges = new ArrayList<PartialEdge>();
            this.level = 0;
        }

        @Override
        public void enterNumberKeyValue(GmlParser.NumberKeyValueContext ctx) {
            if (!this.insideNode && !this.insideEdge) {
                return;
            }
            if (this.level < 2) {
                return;
            }
            String key = ctx.ID().getText();
            String value = ctx.NUMBER().getText();
            if (this.level == 2) {
                if (this.insideNode) {
                    if (key.equals(ID)) {
                        try {
                            this.nodeId = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        this.attributes.put(key, this.parseNumberAttribute(value));
                    }
                } else {
                    assert (this.insideEdge);
                    switch (key) {
                        case "source": {
                            try {
                                this.sourceId = Integer.parseInt(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "target": {
                            try {
                                this.targetId = Integer.parseInt(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "weight": {
                            try {
                                this.weight = Double.parseDouble(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        default: {
                            this.attributes.put(key, this.parseNumberAttribute(value));
                            break;
                        }
                    }
                }
            } else {
                assert (this.level >= 3);
                this.stringBuffer.append(' ');
                this.stringBuffer.append(key);
                this.stringBuffer.append(' ');
                this.stringBuffer.append(value);
            }
        }

        @Override
        public void enterListKeyValue(GmlParser.ListKeyValueContext ctx) {
            String key = ctx.ID().getText();
            if (this.level == 0 && key.equals(GRAPH)) {
                this.foundGraph = true;
                this.insideGraph = true;
            } else if (this.level == 1 && this.insideGraph && key.equals(NODE)) {
                this.insideNode = true;
                this.nodeId = null;
                this.attributes = new HashMap<String, Attribute>();
            } else if (this.level == 1 && this.insideGraph && key.equals(EDGE)) {
                this.insideEdge = true;
                this.sourceId = null;
                this.targetId = null;
                this.weight = null;
                this.attributes = new HashMap<String, Attribute>();
            } else if (this.insideNode || this.insideEdge) {
                if (this.level == 2) {
                    this.stringBuffer = new StringBuilder();
                    this.stringBuffer.append('[');
                } else if (this.level >= 3) {
                    this.stringBuffer.append(' ');
                    this.stringBuffer.append(key);
                    this.stringBuffer.append(' ');
                    this.stringBuffer.append('[');
                }
            }
            ++this.level;
        }

        @Override
        public void exitListKeyValue(GmlParser.ListKeyValueContext ctx) {
            String key = ctx.ID().getText();
            --this.level;
            if (this.level == 0 && key.equals(GRAPH)) {
                this.insideGraph = false;
            } else if (this.level == 1 && this.insideGraph && key.equals(NODE)) {
                if (this.nodeId == null) {
                    this.singletons.add(new Node(this.attributes));
                } else {
                    this.nodes.put(this.nodeId, new Node(this.attributes));
                }
                this.insideNode = false;
                this.attributes = null;
            } else if (this.level == 1 && this.insideGraph && key.equals(EDGE)) {
                if (this.sourceId != null && this.targetId != null) {
                    this.edges.add(new PartialEdge(this.sourceId, this.targetId, this.weight, this.attributes));
                }
                this.insideEdge = false;
                this.attributes = null;
            } else if (this.insideNode || this.insideEdge) {
                if (this.level == 2) {
                    this.stringBuffer.append(' ');
                    this.stringBuffer.append(']');
                    this.attributes.put(key, new DefaultAttribute<String>(this.stringBuffer.toString(), AttributeType.UNKNOWN));
                    this.stringBuffer = null;
                } else if (this.level >= 3) {
                    this.stringBuffer.append(' ');
                    this.stringBuffer.append(']');
                }
            }
        }

        @Override
        public void enterStringKeyValue(GmlParser.StringKeyValueContext ctx) {
            if (!this.insideNode && !this.insideEdge) {
                return;
            }
            if (this.level < 2) {
                return;
            }
            String key = ctx.ID().getText();
            String text = ctx.STRING().getText();
            String noQuotes = text.subSequence(1, text.length() - 1).toString();
            String unescapedText = StringEscapeUtils.unescapeJava(noQuotes);
            if (this.level == 2) {
                if (key.equals(ID)) {
                    throw new IllegalArgumentException("Invalid type for attribute id: string");
                }
                if (key.equals(SOURCE)) {
                    throw new IllegalArgumentException("Invalid type for attribute source: string");
                }
                if (key.equals(TARGET)) {
                    throw new IllegalArgumentException("Invalid type for attribute target: string");
                }
                if (key.equals(WEIGHT)) {
                    throw new IllegalArgumentException("Invalid type for attribute weight: string");
                }
                this.attributes.put(key, DefaultAttribute.createAttribute(unescapedText));
            } else if (this.level >= 3) {
                this.stringBuffer.append(' ');
                this.stringBuffer.append(key);
                this.stringBuffer.append(' ');
                this.stringBuffer.append(text);
            }
        }

        private Attribute parseNumberAttribute(String value) {
            try {
                return DefaultAttribute.createAttribute(Integer.parseInt(value, 10));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return DefaultAttribute.createAttribute(Long.parseLong(value, 10));
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        return DefaultAttribute.createAttribute(Double.parseDouble(value));
                    }
                    catch (NumberFormatException numberFormatException3) {
                        return DefaultAttribute.createAttribute(value);
                    }
                }
            }
        }
    }

    private class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e2) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

